/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.impl.core.query.lucene.CachingIndexReader;
import org.exoplatform.services.log.ExoLogger;

final class DocNumberCache {
    private static Log log = ExoLogger.getLogger((String)"jcr.DocNumberCache");
    private static final long LOG_INTERVAL = 10000L;
    private final LRUMap docNumbers;
    private long lastLog;
    private long misses;
    private long accesses;

    DocNumberCache(int size) {
        this.docNumbers = new LRUMap(size);
    }

    synchronized void put(String identifier, CachingIndexReader reader, int n) {
        Entry e = (Entry)this.docNumbers.get((Object)identifier);
        if (e != null) {
            if (reader.getCreationTick() <= e.reader.getCreationTick()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Ignoring put(). New entry is not from a newer reader. existing: " + e.reader.getCreationTick() + ", new: " + reader.getCreationTick()));
                }
                e = null;
            }
        } else {
            e = new Entry(reader, n);
        }
        if (e != null) {
            this.docNumbers.put((Object)identifier, (Object)e);
        }
    }

    synchronized Entry get(String identifier) {
        Entry entry = (Entry)this.docNumbers.get((Object)identifier);
        if (log.isInfoEnabled()) {
            ++this.accesses;
            if (entry == null) {
                ++this.misses;
            }
            if (this.accesses > 1000L && System.currentTimeMillis() - this.lastLog > 10000L) {
                long ratio = 100L;
                if (this.misses != 0L) {
                    ratio -= this.misses * 100L / this.accesses;
                }
                StringBuffer statistics = new StringBuffer();
                statistics.append("size=").append(this.docNumbers.size());
                statistics.append("/").append(this.docNumbers.maxSize());
                statistics.append(", #accesses=").append(this.accesses);
                statistics.append(", #hits=").append(this.accesses - this.misses);
                statistics.append(", #misses=").append(this.misses);
                statistics.append(", cacheRatio=").append(ratio).append("%");
                log.info((Object)statistics);
                this.accesses = 0L;
                this.misses = 0L;
                this.lastLog = System.currentTimeMillis();
            }
        }
        return entry;
    }

    public static final class Entry {
        final CachingIndexReader reader;
        final int doc;

        Entry(CachingIndexReader reader, int doc) {
            this.reader = reader;
            this.doc = doc;
        }
    }
}

