/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNodeIterator;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheableWorkspaceDataManager;
import org.exoplatform.services.jcr.impl.dataflow.session.WorkspaceStorageDataManagerProxy;
import org.exoplatform.services.log.ExoLogger;

class DocOrderNodeDataIteratorImpl
implements ScoreNodeIterator {
    private static Log log = ExoLogger.getLogger((String)"jcr.DocOrderNodeDataIteratorImpl");
    private boolean ordered = false;
    protected String[] identifiers;
    protected Float[] scores;
    protected final SessionDataManager dataManager;
    protected int ipos = -1;
    protected int invalid = 0;
    private NodeImpl inext;
    private final boolean cached;
    private SessionImpl session;

    DocOrderNodeDataIteratorImpl(SessionDataManager dataManager, String[] identifiers, Float[] scores) {
        this.dataManager = dataManager;
        this.session = null;
        this.identifiers = identifiers;
        this.scores = scores;
        this.cached = true;
    }

    DocOrderNodeDataIteratorImpl(SessionDataManager dataManager, String[] identifiers, Float[] scores, boolean cached) {
        this.dataManager = dataManager;
        this.session = null;
        this.identifiers = identifiers;
        this.scores = scores;
        this.cached = cached;
    }

    DocOrderNodeDataIteratorImpl(SessionImpl session, String[] identifiers, Float[] scores) {
        this.dataManager = session.getTransientNodesManager();
        this.session = session;
        this.identifiers = identifiers;
        this.scores = scores;
        this.cached = true;
    }

    public Object next() {
        return this.nextNodeImpl();
    }

    public Node nextNode() {
        return this.nextNodeImpl();
    }

    public NodeImpl nextNodeImpl() {
        this.initOrderedIterator();
        if (this.inext == null) {
            throw new NoSuchElementException();
        }
        NodeImpl n = this.inext;
        this.fetchNext();
        return n;
    }

    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public void skip(long skipNum) {
        this.initOrderedIterator();
        if (skipNum < 0L) {
            throw new IllegalArgumentException("skipNum must not be negative");
        }
        if ((long)this.ipos + skipNum > (long)this.identifiers.length) {
            throw new NoSuchElementException();
        }
        if (skipNum > 0L) {
            this.ipos = (int)((long)this.ipos + (skipNum - 1L));
            this.fetchNext();
        }
    }

    public long getSize() {
        return this.identifiers.length - this.invalid;
    }

    public long getPosition() {
        this.initOrderedIterator();
        return this.ipos - this.invalid;
    }

    public boolean hasNext() {
        this.initOrderedIterator();
        return this.inext != null;
    }

    public float getScore() {
        this.initOrderedIterator();
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.scores[this.ipos].floatValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initOrderedIterator() {
        if (this.ordered) {
            return;
        }
        long time = System.currentTimeMillis();
        ScoreNode[] nodes = new ScoreNode[this.identifiers.length];
        for (int i = 0; i < this.identifiers.length; ++i) {
            nodes[i] = new ScoreNode(this.identifiers[i], this.scores[i]);
        }
        final LinkedHashSet invalidIdentifiers = new LinkedHashSet(2);
        final HashMap lcache = new HashMap();
        try {
            WorkspaceStorageDataManagerProxy pmanager;
            DataManager dataManager = pmanager = this.session != null ? (DataManager)this.session.getContainer().getComponentInstanceOfType(CacheableWorkspaceDataManager.class) : this.dataManager.getTransactManager().getStorageDataManager();
            do {
                if (invalidIdentifiers.size() > 0) {
                    ArrayList<ScoreNode> tmp = new ArrayList<ScoreNode>();
                    for (int i = 0; i < nodes.length; ++i) {
                        if (nodes[i] != null) {
                            if (invalidIdentifiers.contains(nodes[i].identifier)) continue;
                            tmp.add(nodes[i]);
                            continue;
                        }
                        log.warn((Object)"Invalid identifiers set contains null ScoreNode, skiped");
                    }
                    nodes = tmp.toArray(new ScoreNode[tmp.size()]);
                    invalidIdentifiers.clear();
                }
                try {
                    Arrays.sort(nodes, new Comparator<ScoreNode>(){

                        private NodeData getNode(String id) throws RepositoryException {
                            NodeData node = (NodeData)lcache.get(id);
                            if (node == null) {
                                node = (NodeData)pmanager.getItemData(id);
                                if (node != null) {
                                    lcache.put(id, node);
                                }
                                return node;
                            }
                            return node;
                        }

                        @Override
                        public int compare(ScoreNode n1, ScoreNode n2) {
                            try {
                                int commonDepth;
                                NodeData ndata2;
                                NodeData ndata1;
                                try {
                                    ndata1 = this.getNode(n1.identifier);
                                    if (ndata1 == null) {
                                        throw new RepositoryException("Node not found for " + n1.identifier);
                                    }
                                }
                                catch (RepositoryException e) {
                                    invalidIdentifiers.add(n1.identifier);
                                    throw new SortFailedException();
                                }
                                try {
                                    ndata2 = this.getNode(n2.identifier);
                                    if (ndata2 == null) {
                                        throw new RepositoryException("Node not found for " + n2.identifier);
                                    }
                                }
                                catch (RepositoryException e) {
                                    invalidIdentifiers.add(n2.identifier);
                                    throw new SortFailedException();
                                }
                                QPath path1 = ndata1.getQPath();
                                QPath path2 = ndata2.getQPath();
                                QPathEntry[] pentries1 = path1.getEntries();
                                QPathEntry[] pentries2 = path2.getEntries();
                                for (commonDepth = 0; pentries1.length > commonDepth && pentries2.length > commonDepth && pentries1[commonDepth].equals(pentries2[commonDepth]); ++commonDepth) {
                                }
                                if (pentries1.length - 1 == --commonDepth) {
                                    return -1;
                                }
                                if (pentries2.length - 1 == commonDepth) {
                                    return 1;
                                }
                                return ndata1.getOrderNumber() - ndata2.getOrderNumber();
                            }
                            catch (SortFailedException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                log.error((Object)("Exception while sorting nodes in document order: " + e.toString()), (Throwable)e);
                                if (n1 != null) {
                                    invalidIdentifiers.add(n1.identifier);
                                } else {
                                    log.warn((Object)"Null ScoreNode n1 will not be added into invalid identifiers set");
                                }
                                if (n2 != null) {
                                    invalidIdentifiers.add(n2.identifier);
                                } else {
                                    log.warn((Object)"Null ScoreNode n2 will not be added into invalid identifiers set");
                                }
                                throw new SortFailedException();
                            }
                        }
                    });
                }
                catch (SortFailedException e) {
                    // empty catch block
                }
            } while (invalidIdentifiers.size() > 0);
            if (this.identifiers.length != nodes.length) {
                this.identifiers = new String[nodes.length];
                this.scores = new Float[nodes.length];
            }
            for (int i = 0; i < nodes.length; ++i) {
                this.identifiers[i] = nodes[i].identifier;
                this.scores[i] = nodes[i].score;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("" + this.identifiers.length + " node(s) ordered in " + (System.currentTimeMillis() - time) + " ms"));
            }
        }
        finally {
            this.session = null;
            lcache.clear();
        }
        this.fetchNext();
        this.ordered = true;
    }

    protected void fetchNext() {
        this.inext = null;
        while (this.inext == null && this.ipos + 1 < this.identifiers.length) {
            try {
                this.inext = (NodeImpl)this.dataManager.getItemByIdentifier(this.identifiers[this.ipos + 1], true);
            }
            catch (RepositoryException e) {
                log.warn((Object)("Exception retrieving Node with UUID: " + this.identifiers[this.ipos + 1] + ": " + (Object)((Object)e)), (Throwable)e);
                ++this.invalid;
            }
            ++this.ipos;
        }
        if (this.identifiers.length == 0) {
            this.ipos = this.identifiers.length;
        } else if (this.ipos + 1 == this.identifiers.length && this.inext == null) {
            ++this.ipos;
        }
    }

    private static final class ScoreNode {
        final String identifier;
        final Float score;

        ScoreNode(String identifier, Float score) {
            this.identifier = identifier;
            this.score = score;
        }
    }

    private static final class SortFailedException
    extends RuntimeException {
        private SortFailedException() {
        }
    }
}

