/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreDocComparator;
import org.apache.lucene.search.SortComparator;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.SharedFieldCache;

class SharedFieldSortComparator
extends SortComparator {
    static final SortComparator PROPERTIES = new SharedFieldSortComparator(FieldNames.PROPERTIES);
    private final String field;

    public SharedFieldSortComparator(String fieldname) {
        this.field = fieldname;
    }

    public ScoreDocComparator newComparator(IndexReader reader, String propertyName) throws IOException {
        final FieldCache.StringIndex index = SharedFieldCache.INSTANCE.getStringIndex(reader, this.field, propertyName, this);
        return new ScoreDocComparator(){

            public final int compare(ScoreDoc i, ScoreDoc j) {
                int fi = index.order[i.doc];
                int fj = index.order[j.doc];
                if (fi < fj) {
                    return -1;
                }
                if (fi > fj) {
                    return 1;
                }
                return 0;
            }

            public Comparable sortValue(ScoreDoc i) {
                return "";
            }

            public int sortType() {
                return 9;
            }
        };
    }

    protected Comparable getComparable(String termtext) {
        throw new UnsupportedOperationException();
    }
}

