/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.value;

import java.io.IOException;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.core.JCRPath;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.value.BaseValue;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;

public class PathValue
extends BaseValue {
    public static final int TYPE = 8;
    private final LocationFactory locationFactory;

    public PathValue(QPath path, LocationFactory locationFactory) throws IOException {
        super(8, new TransientValueData(path));
        this.locationFactory = locationFactory;
    }

    public PathValue(TransientValueData data, LocationFactory locationFactory) throws IOException, RepositoryException {
        super(8, data);
        this.locationFactory = locationFactory;
    }

    public String getString() throws ValueFormatException, IllegalStateException, RepositoryException {
        JCRPath path = this.locationFactory.createJCRPath(this.getQPath());
        return path.getAsString(false);
    }

    public Calendar getDate() throws ValueFormatException, IllegalStateException, RepositoryException {
        throw new ValueFormatException("conversion to date failed: inconvertible types");
    }

    public long getLong() throws ValueFormatException, IllegalStateException, RepositoryException {
        throw new ValueFormatException("conversion to long failed: inconvertible types");
    }

    public boolean getBoolean() throws ValueFormatException, IllegalStateException, RepositoryException {
        throw new ValueFormatException("conversion to boolean failed: inconvertible types");
    }

    public double getDouble() throws ValueFormatException, IllegalStateException, RepositoryException {
        throw new ValueFormatException("conversion to double failed: inconvertible types");
    }

    public QPath getQPath() throws ValueFormatException, IllegalStateException, RepositoryException {
        return QPath.parse(this.getInternalString());
    }
}

