/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.dataflow.persistent.WorkspaceStorageCache;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspaceStorageCacheImpl;
import org.exoplatform.services.jcr.impl.storage.SystemDataContainerHolder;
import org.exoplatform.services.jcr.storage.WorkspaceDataContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheableWorkspaceDataManager
extends WorkspacePersistentDataManager {
    protected final WorkspaceStorageCache cache;
    protected final Map<Integer, DataRequest> requestCache;

    public CacheableWorkspaceDataManager(WorkspaceDataContainer dataContainer, WorkspaceStorageCacheImpl cache, SystemDataContainerHolder systemDataContainerHolder) {
        super(dataContainer, systemDataContainerHolder);
        this.cache = cache;
        this.requestCache = new HashMap<Integer, DataRequest>();
        this.addItemPersistenceListener(cache);
    }

    @Override
    public ItemData getItemData(String identifier) throws RepositoryException {
        ItemData data = this.getCachedItemData(identifier);
        if (data == null) {
            return this.getPersistedItemData(identifier);
        }
        return data;
    }

    @Override
    public ItemData getItemData(NodeData parentData, QPathEntry name) throws RepositoryException {
        ItemData data = this.getCachedItemData(parentData, name);
        if (data == null) {
            data = this.getPersistedItemData(parentData, name);
        }
        return data;
    }

    @Override
    public List<NodeData> getChildNodesData(NodeData nodeData) throws RepositoryException {
        return this.getChildNodesData(nodeData, false);
    }

    @Override
    public List<PropertyData> getChildPropertiesData(NodeData nodeData) throws RepositoryException {
        return this.getChildPropertiesData(nodeData, false);
    }

    @Override
    public List<PropertyData> listChildPropertiesData(NodeData nodeData) throws RepositoryException {
        return this.listChildPropertiesData(nodeData, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<NodeData> getChildNodesData(NodeData nodeData, boolean forcePersistentRead) throws RepositoryException {
        DataRequest request = new DataRequest(nodeData.getIdentifier(), 1);
        List<NodeData> childNodes = null;
        if (!forcePersistentRead && this.cache.isEnabled()) {
            request.waitSame();
            childNodes = this.cache.getChildNodes(nodeData);
            if (childNodes != null) {
                return childNodes;
            }
        }
        try {
            request.start();
            childNodes = super.getChildNodesData(nodeData);
            if (this.cache.isEnabled()) {
                NodeData parentData = (NodeData)this.cache.get(nodeData.getIdentifier());
                if (parentData == null) {
                    parentData = (NodeData)super.getItemData(nodeData.getIdentifier());
                }
                this.cache.addChildNodes(parentData, childNodes);
            }
            List<NodeData> list = childNodes;
            return list;
        }
        finally {
            request.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PropertyData> getChildPropertiesData(NodeData nodeData, boolean forcePersistentRead) throws RepositoryException {
        DataRequest request = new DataRequest(nodeData.getIdentifier(), 2);
        List<PropertyData> childProperties = null;
        if (!forcePersistentRead && this.cache.isEnabled()) {
            request.waitSame();
            childProperties = this.cache.getChildProperties(nodeData);
            if (childProperties != null) {
                return childProperties;
            }
        }
        try {
            request.start();
            childProperties = super.getChildPropertiesData(nodeData);
            if (this.cache.isEnabled()) {
                NodeData parentData = (NodeData)this.cache.get(nodeData.getIdentifier());
                if (parentData == null) {
                    parentData = (NodeData)super.getItemData(nodeData.getIdentifier());
                }
                this.cache.addChildProperties(parentData, childProperties);
            }
            List<PropertyData> list = childProperties;
            return list;
        }
        finally {
            request.done();
        }
    }

    protected List<PropertyData> listChildPropertiesData(NodeData nodeData, boolean forcePersistentRead) throws RepositoryException {
        DataRequest request = new DataRequest(nodeData.getIdentifier(), 2);
        List<PropertyData> childProperties = null;
        if (!forcePersistentRead && this.cache.isEnabled()) {
            request.waitSame();
            childProperties = this.cache.getChildProperties(nodeData);
            if (childProperties != null) {
                return childProperties;
            }
        }
        return super.listChildPropertiesData(nodeData);
    }

    @Override
    public List<PropertyData> getReferencesData(String identifier, boolean skipVersionStorage) throws RepositoryException {
        return super.getReferencesData(identifier, skipVersionStorage);
    }

    public WorkspaceStorageCache getCache() {
        return this.cache;
    }

    protected ItemData getCachedItemData(NodeData parentData, QPathEntry name) throws RepositoryException {
        return this.cache.get(parentData.getIdentifier(), name);
    }

    protected ItemData getPersistedItemData(NodeData parentData, QPathEntry name) throws RepositoryException {
        ItemData data = null;
        data = super.getItemData(parentData, name);
        if (data != null && this.cache.isEnabled()) {
            this.cache.put(data);
        }
        return data;
    }

    protected ItemData getCachedItemData(String identifier) throws RepositoryException {
        return this.cache.get(identifier);
    }

    protected ItemData getPersistedItemData(String identifier) throws RepositoryException {
        ItemData data = super.getItemData(identifier);
        if (data != null && this.cache.isEnabled()) {
            this.cache.put(data);
        }
        return data;
    }

    protected class DataRequest {
        public static final int GET_NODES = 1;
        public static final int GET_PROPERTIES = 2;
        private static final int GET_ITEM_ID = 3;
        private static final int GET_ITEM_NAME = 4;
        protected final int type;
        protected final String parentId;
        protected final String id;
        protected final QPathEntry name;
        protected final int hcode;
        protected boolean stared;

        DataRequest(String parentId, int type) {
            this.parentId = parentId;
            this.name = null;
            this.id = null;
            this.type = type;
            this.hcode = 31 * (31 + this.type) + this.parentId.hashCode();
        }

        DataRequest(String parentId, QPathEntry name) {
            this.parentId = parentId;
            this.name = name;
            this.id = null;
            this.type = 4;
            int hc = 31 * (31 + this.type) + this.parentId.hashCode();
            this.hcode = 31 * hc + this.name.hashCode();
        }

        DataRequest(String id) {
            this.parentId = null;
            this.name = null;
            this.id = id;
            this.type = 3;
            this.hcode = 31 * (31 + this.type) + this.id.hashCode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DataRequest waitSame() {
            DataRequest prev = null;
            Map<Integer, DataRequest> map = CacheableWorkspaceDataManager.this.requestCache;
            synchronized (map) {
                prev = CacheableWorkspaceDataManager.this.requestCache.get(this.hashCode());
            }
            if (prev != null) {
                while (prev.isStarted()) {
                    try {
                        Thread.yield();
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void start() {
            this.stared = true;
            Map<Integer, DataRequest> map = CacheableWorkspaceDataManager.this.requestCache;
            synchronized (map) {
                CacheableWorkspaceDataManager.this.requestCache.put(this.hashCode(), this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void done() {
            this.stared = false;
            Map<Integer, DataRequest> map = CacheableWorkspaceDataManager.this.requestCache;
            synchronized (map) {
                CacheableWorkspaceDataManager.this.requestCache.remove(this.hashCode());
            }
        }

        boolean isStarted() {
            return this.stared;
        }

        public boolean equals(Object obj) {
            return this.hcode == obj.hashCode();
        }

        public int hashCode() {
            return this.hcode;
        }
    }
}

