/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.dataflow.ChangesLogIterator;
import org.exoplatform.services.jcr.dataflow.CompositeChangesLog;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ACLInheritanceSupportedWorkspaceDataManager;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheableWorkspaceDataManager;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionableWorkspaceDataManager
extends ACLInheritanceSupportedWorkspaceDataManager {
    private static Log log = ExoLogger.getLogger((String)"jcr.VersionableWorkspaceDataManager");
    private ACLInheritanceSupportedWorkspaceDataManager versionDataManager;

    public VersionableWorkspaceDataManager(CacheableWorkspaceDataManager persistentManager) {
        super(persistentManager);
    }

    public void setSystemDataManager(DataManager systemDataManager) {
        this.versionDataManager = (ACLInheritanceSupportedWorkspaceDataManager)systemDataManager;
    }

    @Override
    public List<NodeData> getChildNodesData(NodeData nodeData) throws RepositoryException {
        QPath path = nodeData.getQPath();
        if (this.isSystemDescendant(path) && !this.equals(this.versionDataManager)) {
            return this.versionDataManager.getChildNodesData(nodeData);
        }
        return super.getChildNodesData(nodeData);
    }

    @Override
    public List<PropertyData> getChildPropertiesData(NodeData nodeData) throws RepositoryException {
        QPath path = nodeData.getQPath();
        if (this.isSystemDescendant(path) && !this.equals(this.versionDataManager)) {
            return this.versionDataManager.getChildPropertiesData(nodeData);
        }
        return super.getChildPropertiesData(nodeData);
    }

    @Override
    public List<PropertyData> listChildPropertiesData(NodeData nodeData) throws RepositoryException {
        QPath path = nodeData.getQPath();
        if (this.isSystemDescendant(path) && !this.equals(this.versionDataManager)) {
            return this.versionDataManager.listChildPropertiesData(nodeData);
        }
        return super.listChildPropertiesData(nodeData);
    }

    @Override
    public ItemData getItemData(NodeData parentData, QPathEntry name) throws RepositoryException {
        ItemData data = super.getItemData(parentData, name);
        if (data != null) {
            return data;
        }
        if (!this.equals(this.versionDataManager) && (data = this.versionDataManager.getItemData(parentData, name)) != null && this.isSystemDescendant(data.getQPath())) {
            return data;
        }
        return null;
    }

    @Override
    public ItemData getItemData(String identifier) throws RepositoryException {
        ItemData data = super.getItemData(identifier);
        if (data != null) {
            return data;
        }
        if (!this.equals(this.versionDataManager) && (data = this.versionDataManager.getItemData(identifier)) != null && this.isSystemDescendant(data.getQPath())) {
            return data;
        }
        return null;
    }

    public void save(CompositeChangesLog changesLog) throws RepositoryException, InvalidItemStateException {
        ChangesLogIterator logIterator = changesLog.getLogIterator();
        boolean saveVersions = false;
        TransactionChangesLog versionLog = new TransactionChangesLog();
        boolean saveNonVersions = false;
        TransactionChangesLog nonVersionLog = new TransactionChangesLog();
        while (logIterator.hasNextLog()) {
            ArrayList<ItemState> vstates = new ArrayList<ItemState>();
            ArrayList<ItemState> nvstates = new ArrayList<ItemState>();
            PlainChangesLog changes = logIterator.nextLog();
            for (ItemState change : changes.getAllStates()) {
                if (this.isSystemDescendant(change.getData().getQPath()) && !this.equals(this.versionDataManager)) {
                    vstates.add(change);
                    continue;
                }
                nvstates.add(change);
            }
            if (vstates.size() > 0) {
                versionLog.addLog(new PlainChangesLogImpl(vstates, changes.getSessionId(), changes.getEventType()));
                saveVersions = true;
            }
            if (nvstates.size() <= 0) continue;
            nonVersionLog.addLog(new PlainChangesLogImpl(nvstates, changes.getSessionId(), changes.getEventType()));
            saveNonVersions = true;
        }
        if (saveVersions) {
            this.versionDataManager.save(versionLog);
        }
        if (saveNonVersions) {
            super.save(nonVersionLog);
        }
    }

    private boolean isSystemDescendant(QPath path) {
        return path.equals(Constants.JCR_SYSTEM_PATH) || path.isDescendantOf(Constants.JCR_SYSTEM_PATH, false);
    }
}

