/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListener;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.dataflow.TransientItemData;
import org.exoplatform.services.jcr.impl.storage.SystemDataContainerHolder;
import org.exoplatform.services.jcr.storage.WorkspaceDataContainer;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkspacePersistentDataManager
implements DataManager {
    protected Log log = ExoLogger.getLogger((String)"jcr.WorkspacePersistentDataManager");
    protected WorkspaceDataContainer dataContainer;
    protected WorkspaceDataContainer systemDataContainer;
    protected List<ItemsPersistenceListener> listeners;

    public WorkspacePersistentDataManager(WorkspaceDataContainer dataContainer, SystemDataContainerHolder systemDataContainerHolder) {
        this.dataContainer = dataContainer;
        this.listeners = new ArrayList<ItemsPersistenceListener>();
        this.systemDataContainer = systemDataContainerHolder.getContainer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(ItemStateChangesLog changesLog) throws RepositoryException {
        List<ItemState> changes = changesLog.getAllStates();
        Object regularConnection = null;
        Object systemConnection = null;
        try {
            for (ItemState itemState : changes) {
                if (!itemState.isPersisted()) continue;
                long start = System.currentTimeMillis();
                TransientItemData data = (TransientItemData)itemState.getData();
                Object conn = null;
                conn = this.isSystemPath(data.getQPath()) ? (systemConnection == null ? (systemConnection = this.systemDataContainer != this.dataContainer ? (this.systemDataContainer.equals(this.dataContainer) && regularConnection != null ? this.systemDataContainer.reuseConnection((WorkspaceStorageConnection)regularConnection) : this.systemDataContainer.openConnection()) : (regularConnection == null ? this.dataContainer.openConnection() : regularConnection)) : systemConnection) : (regularConnection == null ? (regularConnection = this.systemDataContainer != this.dataContainer ? (this.dataContainer.equals(this.systemDataContainer) && systemConnection != null ? this.dataContainer.reuseConnection((WorkspaceStorageConnection)systemConnection) : this.dataContainer.openConnection()) : (systemConnection == null ? this.dataContainer.openConnection() : systemConnection)) : regularConnection);
                data.increasePersistedVersion();
                if (itemState.isAdded()) {
                    this.doAdd(data, (WorkspaceStorageConnection)conn);
                } else if (itemState.isUpdated()) {
                    this.doUpdate(data, (WorkspaceStorageConnection)conn);
                } else if (itemState.isDeleted()) {
                    this.doDelete(data, (WorkspaceStorageConnection)conn);
                } else if (itemState.isRenamed()) {
                    this.doRename(data, (WorkspaceStorageConnection)conn);
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)(ItemState.nameFromValue(itemState.getState()) + " " + (System.currentTimeMillis() - start) + "ms, " + data.getQPath().getAsString()));
            }
            if (regularConnection != null) {
                regularConnection.commit();
            }
            if (systemConnection != null && !systemConnection.equals(regularConnection)) {
                systemConnection.commit();
            }
        }
        finally {
            if (regularConnection != null && regularConnection.isOpened()) {
                regularConnection.rollback();
            }
            if (systemConnection != null && !systemConnection.equals(regularConnection) && systemConnection.isOpened()) {
                systemConnection.rollback();
            }
        }
        this.notifySaveItems(changesLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemData getItemData(String identifier) throws RepositoryException {
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            ItemData itemData = con.getItemData(identifier);
            return itemData;
        }
        finally {
            con.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> getReferencesData(String identifier, boolean skipVersionStorage) throws RepositoryException {
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            List<PropertyData> allRefs = con.getReferencesData(identifier);
            ArrayList<PropertyData> refProps = new ArrayList<PropertyData>();
            for (int i = 0; i < allRefs.size(); ++i) {
                PropertyData ref = allRefs.get(i);
                if (skipVersionStorage) {
                    if (ref.getQPath().isDescendantOf(Constants.JCR_VERSION_STORAGE_PATH, false)) continue;
                    refProps.add(ref);
                    continue;
                }
                refProps.add(ref);
            }
            ArrayList<PropertyData> arrayList = refProps;
            return arrayList;
        }
        finally {
            con.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NodeData> getChildNodesData(NodeData nodeData) throws RepositoryException {
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            ArrayList<NodeData> childNodes = con.getChildNodesData(nodeData);
            ArrayList<NodeData> arrayList = childNodes != null ? childNodes : new ArrayList<NodeData>();
            return arrayList;
        }
        finally {
            con.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> getChildPropertiesData(NodeData nodeData) throws RepositoryException {
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            ArrayList<PropertyData> childProperties = con.getChildPropertiesData(nodeData);
            ArrayList<PropertyData> arrayList = childProperties != null ? childProperties : new ArrayList<PropertyData>();
            return arrayList;
        }
        finally {
            con.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyData> listChildPropertiesData(NodeData nodeData) throws RepositoryException {
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            ArrayList<PropertyData> childProperties = con.listChildPropertiesData(nodeData);
            ArrayList<PropertyData> arrayList = childProperties != null ? childProperties : new ArrayList<PropertyData>();
            return arrayList;
        }
        finally {
            con.rollback();
        }
    }

    private void checkSameNameSibling(NodeData node, WorkspaceStorageConnection con) throws RepositoryException {
        QPathEntry myName;
        NodeData parent;
        ItemData sibling;
        if (!("00exo0jcr0root0uuid0000000000000".equals(node.getIdentifier()) || node.getQPath().getIndex() <= 1 || (sibling = con.getItemData(parent = (NodeData)con.getItemData(node.getParentIdentifier()), new QPathEntry((myName = node.getQPath().getEntries()[node.getQPath().getEntries().length - 1]).getNamespace(), myName.getName(), myName.getIndex() - 1))) != null && sibling.isNode())) {
            throw new InvalidItemStateException("Node can't be saved " + node.getQPath().getAsString() + ". No same-name sibling exists with index " + (myName.getIndex() - 1) + ".");
        }
    }

    protected void doDelete(TransientItemData item, WorkspaceStorageConnection con) throws RepositoryException, InvalidItemStateException {
        if (item.isNode()) {
            con.delete((NodeData)((Object)item));
        } else {
            con.delete((PropertyData)((Object)item));
        }
    }

    protected void doUpdate(TransientItemData item, WorkspaceStorageConnection con) throws RepositoryException, InvalidItemStateException {
        if (item.isNode()) {
            con.update((NodeData)((Object)item));
        } else {
            con.update((PropertyData)((Object)item));
        }
    }

    protected void doAdd(TransientItemData item, WorkspaceStorageConnection con) throws RepositoryException, InvalidItemStateException {
        if (item.isNode()) {
            NodeData node = (NodeData)((Object)item);
            this.checkSameNameSibling(node, con);
            con.add(node);
        } else {
            con.add((PropertyData)((Object)item));
        }
    }

    protected void doRename(TransientItemData item, WorkspaceStorageConnection con) throws RepositoryException, InvalidItemStateException {
        NodeData node = (NodeData)((Object)item);
        this.checkSameNameSibling(node, con);
        con.rename(node);
    }

    public Calendar getCurrentTime() {
        return this.dataContainer.getCurrentTime();
    }

    public void addItemPersistenceListener(ItemsPersistenceListener listener) {
        this.listeners.add(listener);
        this.log.info((Object)("Workspace Data manager of '" + this.dataContainer.getName() + "' registered listener: " + listener));
    }

    protected void notifySaveItems(ItemStateChangesLog changesLog) {
        for (ItemsPersistenceListener listener : this.listeners) {
            listener.onSaveItems(changesLog);
        }
    }

    private boolean isSystemPath(QPath path) {
        return path.equals(Constants.JCR_SYSTEM_PATH) || path.isDescendantOf(Constants.JCR_SYSTEM_PATH, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemData getItemData(NodeData parentData, QPathEntry name) throws RepositoryException {
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            ItemData itemData = con.getItemData(parentData, name);
            return itemData;
        }
        finally {
            con.rollback();
        }
    }
}

