/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.db;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Properties;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.GenericConnectionFactory;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;

public class OraclePoolConnectionFactory
extends GenericConnectionFactory {
    public static int CONNPOOL_MAX_LIMIT = 20;
    public static int CONNPOOL_MIN_LIMIT = 2;
    public static int CONNPOOL_INCREMENT = 1;
    protected final Object ociPool;

    public OraclePoolConnectionFactory(String dbDriver, String dbUrl, String dbUserName, String dbPassword, String containerName, boolean multiDb, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner) throws RepositoryException {
        super(dbDriver, dbUrl, dbUserName, dbPassword, containerName, multiDb, valueStorageProvider, maxBufferSize, swapDirectory, swapCleaner);
        Object cpool = null;
        try {
            Class<?> cpoolClass = OraclePoolConnectionFactory.class.getClassLoader().loadClass("oracle.jdbc.pool.OracleOCIConnectionPool");
            Constructor<?> cpoolConstructor = cpoolClass.getConstructor(String.class, String.class, String.class, Properties.class);
            cpool = cpoolConstructor.newInstance(this.dbUserName, this.dbPassword, this.dbUrl, null);
            Method setConnectionCachingEnabled = cpool.getClass().getMethod("setConnectionCachingEnabled", Boolean.TYPE);
            setConnectionCachingEnabled.invoke(cpool, true);
        }
        catch (Throwable e) {
            cpool = null;
            String err = "Oracle OCI connection pool is unavailable due to error " + e;
            if (e.getCause() != null) {
                err = err + " (" + e.getCause() + ")";
            }
            err = err + ". Standard JDBC DriverManager will be used for connections opening.";
            if (this.log.isDebugEnabled()) {
                this.log.warn((Object)err, e);
            }
            this.log.warn((Object)err);
        }
        this.ociPool = cpool;
        try {
            this.reconfigure();
            this.displayPoolConfig();
        }
        catch (Throwable e) {
            if (this.log.isDebugEnabled()) {
                this.log.warn((Object)("Oracle OCI connection pool configuration error " + e), e);
            }
            this.log.warn((Object)("Oracle OCI connection pool configuration error " + e));
        }
    }

    public Connection getJdbcConnection() throws RepositoryException {
        if (this.ociPool != null) {
            try {
                return this.getPoolConnection();
            }
            catch (Throwable e) {
                throw new RepositoryException("Oracle OCI pool connection open error " + e, e);
            }
        }
        return super.getJdbcConnection();
    }

    protected Connection getPoolConnection() throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method getConnection = this.ociPool.getClass().getMethod("getConnection", new Class[0]);
        return (Connection)getConnection.invoke(this.ociPool, new Object[0]);
    }

    protected void reconfigure() throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        if (this.ociPool != null) {
            Properties p1 = new Properties();
            String minLimitName = (String)this.ociPool.getClass().getField("CONNPOOL_MIN_LIMIT").get(null);
            String maxLimitName = (String)this.ociPool.getClass().getField("CONNPOOL_MAX_LIMIT").get(null);
            String incrName = (String)this.ociPool.getClass().getField("CONNPOOL_INCREMENT").get(null);
            p1.put(minLimitName, Integer.toString(CONNPOOL_MIN_LIMIT));
            p1.put(maxLimitName, Integer.toString(CONNPOOL_MAX_LIMIT));
            p1.put(incrName, Integer.toString(CONNPOOL_INCREMENT));
            this.ociPool.getClass().getMethod("setPoolConfig", Properties.class).invoke(this.ociPool, p1);
        }
    }

    protected void displayPoolConfig() throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.ociPool != null) {
            this.log.info((Object)" =========== Oracle OCI connection pool config =========== ");
            this.log.info((Object)(" Min poolsize Limit:\t" + this.ociPool.getClass().getMethod("getMinLimit", new Class[0]).invoke(this.ociPool, new Object[0])));
            this.log.info((Object)(" Max poolsize Limit:\t" + this.ociPool.getClass().getMethod("getMaxLimit", new Class[0]).invoke(this.ociPool, new Object[0])));
            this.log.info((Object)(" PoolSize:\t\t\t" + this.ociPool.getClass().getMethod("getPoolSize", new Class[0]).invoke(this.ociPool, new Object[0])));
            this.log.info((Object)(" ActiveSize:\t\t" + this.ociPool.getClass().getMethod("getActiveSize", new Class[0]).invoke(this.ociPool, new Object[0])));
        }
    }
}

