/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.impl.storage.value.fs.FileIOChannel;
import org.exoplatform.services.jcr.impl.storage.value.fs.FileValueStorage;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.value.ValueIOChannel;
import org.exoplatform.services.log.ExoLogger;

public class TreeFileValueStorage
extends FileValueStorage {
    private static Log chLog = ExoLogger.getLogger((String)"jcr.TreeFileIOChannel");
    private static Log fLog = ExoLogger.getLogger((String)"jcr.TreeFile");

    public TreeFileValueStorage() {
        this.cleaner = new TreeFileCleaner();
    }

    public ValueIOChannel openIOChannel() throws IOException {
        return new TreeFileIOChannel(this.rootDir, this.cleaner);
    }

    private static synchronized boolean mkdirs(File dir) {
        return dir.mkdirs();
    }

    protected class TreeFileIOChannel
    extends FileIOChannel {
        TreeFileIOChannel(File rootDir, FileCleaner cleaner) {
            super(rootDir, cleaner, TreeFileValueStorage.this.getId());
        }

        protected File getFile(String propertyId, int orderNumber) {
            File dir = new File(this.rootDir.getAbsolutePath() + this.buildPath(propertyId));
            TreeFileValueStorage.mkdirs(dir);
            return new TreeFile(dir.getAbsolutePath() + File.separator + propertyId + orderNumber);
        }

        protected File[] getFiles(String propertyId) {
            File dir = new File(this.rootDir.getAbsolutePath() + this.buildPath(propertyId));
            String[] fileNames = dir.list();
            File[] files = new File[fileNames.length];
            for (int i = 0; i < fileNames.length; ++i) {
                files[i] = new TreeFile(dir.getAbsolutePath() + File.separator + fileNames[i]);
            }
            return files;
        }

        protected String buildPath(String fileName) {
            return this.buildPathX8(fileName);
        }

        protected String buildPathX(String fileName) {
            char[] chs = fileName.toCharArray();
            String path = "";
            for (char ch : chs) {
                path = path + File.separator + ch;
            }
            return path;
        }

        protected String buildPathX8(String fileName) {
            int xLength = 8;
            char[] chs = fileName.toCharArray();
            String path = "";
            for (int i = 0; i < 8; ++i) {
                path = path + File.separator + chs[i];
            }
            path = path + fileName.substring(8);
            return path;
        }

        protected String buildPathXX2X4(String fileName) {
            int xxLength = 4;
            int xLength = 8;
            boolean xxBlock = true;
            char[] chs = fileName.toCharArray();
            String path = "";
            for (int xxi = 0; xxi < 4; ++xxi) {
                char ch = chs[xxi];
                path = path + (xxBlock ? File.separator + ch : Character.valueOf(ch));
                xxBlock = !xxBlock;
            }
            for (int xi = 4; xi < 8; ++xi) {
                path = path + File.separator + chs[xi];
            }
            path = path + fileName.substring(8);
            return path;
        }

        protected String buildPathXX(String fileName) {
            char[] chs = fileName.toCharArray();
            String path = "";
            boolean block = true;
            for (char ch : chs) {
                path = path + (block ? File.separator + ch : Character.valueOf(ch));
                block = !block;
            }
            return path;
        }

        protected String buildPathXX8(String fileName) {
            int xxLength = 16;
            char[] chs = fileName.toCharArray();
            String path = "";
            boolean block = true;
            for (int i = 0; i < 16; ++i) {
                char ch = chs[i];
                path = path + (block ? File.separator + ch : Character.valueOf(ch));
                block = !block;
            }
            path = path + fileName.substring(16);
            return path;
        }
    }

    protected class TreeFileCleaner
    extends FileCleaner {
        protected TreeFileCleaner() {
        }

        public synchronized void addFile(File file) {
            super.addFile(new TreeFile(file.getAbsolutePath()));
        }
    }

    protected class TreeFile
    extends File {
        private static final long serialVersionUID = 5125295927077006487L;

        TreeFile(String fileName) {
            super(fileName);
        }

        public boolean delete() {
            boolean res = super.delete();
            if (res) {
                this.deleteParent(new File(this.getParent()));
            }
            return res;
        }

        protected boolean deleteParent(File fp) {
            String rootPath;
            boolean res = false;
            String fpPath = fp.getAbsolutePath();
            if (fpPath.startsWith(rootPath = TreeFileValueStorage.this.rootDir.getAbsolutePath()) && fpPath.length() > rootPath.length()) {
                if (fp.isDirectory()) {
                    String[] ls = fp.list();
                    if (ls.length <= 0) {
                        res = fp.delete();
                        if (res) {
                            res = this.deleteParent(new File(fp.getParent()));
                        } else {
                            fLog.warn((Object)("Parent directory can not be deleted now. " + fp.getAbsolutePath()));
                            TreeFileValueStorage.this.cleaner.addFile(new TreeFile(fp.getAbsolutePath()));
                        }
                    }
                } else {
                    fLog.warn((Object)("Parent can not be a file but found " + fp.getAbsolutePath()));
                }
            }
            return res;
        }
    }
}

