/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.util.io;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.impl.proccess.WorkerThread;
import org.exoplatform.services.log.ExoLogger;

public class FileCleaner
extends WorkerThread {
    protected static final long DEFAULT_TIMEOUT = 30000L;
    protected static Log log = ExoLogger.getLogger((String)"jcr.FileCleaner");
    protected Set<File> files = new LinkedHashSet<File>();

    public FileCleaner() {
        this(30000L);
    }

    public FileCleaner(long timeout) {
        this(timeout, true);
    }

    public FileCleaner(boolean start) {
        this(30000L, start);
    }

    public FileCleaner(long timeout, boolean start) {
        super(timeout);
        this.setName("FileCleaner " + this.getId());
        this.setDaemon(true);
        this.setPriority(1);
        if (start) {
            this.start();
        }
        this.registerShutdownHook();
        log.info((Object)("FileCleaner instantiated name= " + this.getName() + " timeout= " + timeout));
    }

    public synchronized void addFile(File file) {
        if (file.exists()) {
            this.files.add(file);
        }
    }

    public void halt() {
        try {
            this.callPeriodically();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.files != null && this.files.size() > 0) {
            log.warn((Object)("There are uncleared files: " + this.files.size()));
        }
        super.halt();
    }

    protected void callPeriodically() throws Exception {
        if (this.files != null && this.files.size() > 0) {
            Set<File> oldFiles = this.files;
            this.files = new LinkedHashSet<File>();
            for (File file : oldFiles) {
                if (!file.exists()) continue;
                if (!file.delete()) {
                    log.warn((Object)("Could not delete " + (file.isDirectory() ? "directory" : "file") + ". Will try next time: " + file.getAbsolutePath()));
                    this.files.add(file);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)((file.isDirectory() ? "Directory" : "File") + " deleted : " + file.getAbsolutePath()));
            }
        }
    }

    private void registerShutdownHook() {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Set<File> oldFiles = FileCleaner.this.files;
                    FileCleaner.this.files = null;
                    Set<File> set = oldFiles;
                    synchronized (set) {
                        for (File file : oldFiles) {
                            file.delete();
                        }
                    }
                }
            });
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

