/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml.exporting;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFormatException;
import org.apache.ws.commons.util.Base64;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemDataTraversingVisitor;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.dataflow.NodeDataOrderComparator;
import org.exoplatform.services.jcr.impl.dataflow.PropertyDataOrderComparator;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.util.ISO9075;

public abstract class BaseXmlExporter
extends ItemDataTraversingVisitor {
    public static final String MULTI_VALUE_DELIMITER = " ";
    public static final String DEFAULT_EMPTY_NAMESPACE_PREFIX = "jcr_default_empty_namespace_prefix";
    protected static final String JCR_ROOT = "jcr:root";
    protected boolean noRecurse;
    protected final SessionImpl session;
    protected final String SV_NAMESPACE_URI;
    private final boolean skipBinary;
    protected final NamespaceRegistry namespaceRegistry;

    public BaseXmlExporter(SessionImpl session, ItemDataConsumer dataManager, boolean skipBinary, int maxLevel) throws NamespaceException, RepositoryException {
        super(dataManager, maxLevel);
        this.session = session;
        this.skipBinary = skipBinary;
        this.namespaceRegistry = session.getWorkspace().getNamespaceRegistry();
        this.SV_NAMESPACE_URI = session.getNamespaceURI("sv");
    }

    public abstract void export(NodeData var1) throws Exception;

    public boolean isNoRecurse() {
        return this.noRecurse;
    }

    public void setNoRecurse(boolean noRecurse) {
        this.noRecurse = noRecurse;
    }

    public void visit(NodeData node) throws RepositoryException {
        try {
            this.entering(node, this.currentLevel);
            if (this.maxLevel == -1 || this.currentLevel < this.maxLevel) {
                ++this.currentLevel;
                List<PropertyData> properies = this.dataManager.getChildPropertiesData(node);
                Collections.sort(properies, new PropertyDataOrderComparator());
                for (PropertyData data : properies) {
                    InternalQName propName = data.getQPath().getName();
                    if (Constants.JCR_LOCKISDEEP.equals((Object)propName) || Constants.JCR_LOCKOWNER.equals((Object)propName)) continue;
                    data.accept(this);
                }
                if (!this.isNoRecurse() && this.currentLevel > 0) {
                    List<NodeData> nodes = this.dataManager.getChildNodesData(node);
                    Collections.sort(nodes, new NodeDataOrderComparator());
                    for (NodeData data : nodes) {
                        data.accept(this);
                    }
                }
                --this.currentLevel;
            }
            this.leaving(node, this.currentLevel);
        }
        catch (RepositoryException re) {
            this.currentLevel = 0;
            throw re;
        }
    }

    protected String getValueAsStringForExport(ValueData data, int type) throws IllegalStateException, IOException, RepositoryException {
        String charValue = null;
        switch (type) {
            case 2: {
                if (this.skipBinary) {
                    charValue = "";
                    break;
                }
                charValue = Base64.encode((byte[])data.getAsByteArray(), (int)0, (int)((int)data.getLength()), (int)0, (String)"");
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                try {
                    charValue = this.session.getRepository().getSystemSession().getValueFactory().loadValue((TransientValueData)data, type).getString();
                    break;
                }
                catch (ValueFormatException e) {
                    throw new RepositoryException((Throwable)e);
                }
                catch (UnsupportedRepositoryOperationException e) {
                    throw new RepositoryException((Throwable)e);
                }
            }
            default: {
                charValue = new String(data.getAsByteArray(), "UTF-8");
            }
        }
        return charValue;
    }

    protected String getExportName(ItemData data, boolean encode) throws RepositoryException {
        String nodeName;
        QPath itemPath = data.getQPath();
        if (Constants.ROOT_PATH.equals(itemPath)) {
            nodeName = JCR_ROOT;
        } else {
            String prefix;
            InternalQName internalNodeName = itemPath.getName();
            if (encode) {
                internalNodeName = ISO9075.encode(itemPath.getName());
            }
            nodeName = (prefix = this.namespaceRegistry.getPrefix(internalNodeName.getNamespace())).length() == 0 ? "" : prefix + ":";
            nodeName = "".equals(itemPath.getName().getName()) && itemPath.isDescendantOf(Constants.EXO_NAMESPACES_PATH, false) ? nodeName + DEFAULT_EMPTY_NAMESPACE_PREFIX : nodeName + internalNodeName.getName();
        }
        return nodeName;
    }

    public boolean isSkipBinary() {
        return this.skipBinary;
    }
}

