/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml.importing;

import java.util.Map;
import javax.jcr.RepositoryException;
import org.exoplatform.services.ext.action.InvocationContext;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.util.NodeTypeRecognizer;
import org.exoplatform.services.jcr.impl.xml.XmlSaveType;
import org.exoplatform.services.jcr.impl.xml.importing.BaseXmlImporter;
import org.exoplatform.services.jcr.impl.xml.importing.ContentImporter;
import org.exoplatform.services.jcr.impl.xml.importing.DocumentViewImporter;
import org.exoplatform.services.jcr.impl.xml.importing.SystemViewImporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeutralImporter
extends BaseXmlImporter {
    private ContentImporter contentImporter = null;
    private final NodeImpl parent;

    public NeutralImporter(NodeImpl parent, int uuidBehavior, XmlSaveType saveType, InvocationContext context) {
        super(parent, uuidBehavior, saveType, context);
        this.parent = parent;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws RepositoryException {
        if (this.contentImporter == null) {
            throw new IllegalStateException("StartElement must be  call first");
        }
        this.contentImporter.characters(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws RepositoryException {
        if (this.contentImporter == null) {
            throw new IllegalStateException("StartElement must be call first");
        }
        this.contentImporter.endElement(uri, localName, qName);
    }

    @Override
    public void save() throws RepositoryException {
        if (this.contentImporter == null) {
            throw new IllegalStateException("StartElement must be call first");
        }
        this.contentImporter.save();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String name, Map<String, String> atts) throws RepositoryException {
        if (this.contentImporter == null) {
            switch (NodeTypeRecognizer.recognize(namespaceURI, name)) {
                case DOCVIEW: {
                    this.contentImporter = new DocumentViewImporter(this.parent, this.uuidBehavior, this.getSaveType(), this.context);
                    break;
                }
                case SYSVIEW: {
                    this.contentImporter = new SystemViewImporter(this.parent, this.uuidBehavior, this.getSaveType(), this.context);
                    break;
                }
                default: {
                    throw new IllegalStateException("There was an error during ascertaining the type of document. First element " + namespaceURI + ":" + name);
                }
            }
        }
        this.contentImporter.startElement(namespaceURI, localName, name, atts);
    }
}

