/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml.importing.dataflow;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeType;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.xml.importing.dataflow.ImportItemData;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportNodeData
extends TransientNodeData
implements ImportItemData {
    private static Log log = ExoLogger.getLogger((String)"jcr.ImportedNodeData");
    private boolean isMixReferenceable;
    private boolean isMixVersionable;
    private String versionHistoryIdentifier;
    private boolean isContainsVersionhistory;
    private String baseVersionIdentifier;
    private final List<ExtendedNodeType> nodeTypes = new ArrayList<ExtendedNodeType>();

    public ImportNodeData(ItemData parent, InternalQName name, int index) {
        this.qpath = QPath.makeChildPath(parent.getQPath(), name, index);
        this.parentIdentifier = parent.getIdentifier();
    }

    public ImportNodeData(QPath path, String identifier, int version, InternalQName primaryTypeName, InternalQName[] mixinTypeNames, int orderNum, String parentIdentifier, AccessControlList acl) {
        super(path, identifier, version, primaryTypeName, mixinTypeNames, orderNum, parentIdentifier, acl);
    }

    public void addNodeType(ExtendedNodeType nt) {
        this.nodeTypes.add(nt);
    }

    public String getBaseVersionIdentifier() {
        return this.baseVersionIdentifier;
    }

    public List<ExtendedNodeType> getCurrentNodeTypes() {
        return this.nodeTypes;
    }

    @Override
    public InternalQName[] getMixinTypeNames() {
        if (this.mixinTypeNames == null) {
            return new InternalQName[0];
        }
        return this.mixinTypeNames;
    }

    public List<ExtendedNodeType> getNodeTypes() {
        return this.nodeTypes;
    }

    public String getVersionHistoryIdentifier() {
        return this.versionHistoryIdentifier;
    }

    public boolean isContainsVersionhistory() {
        return this.isContainsVersionhistory;
    }

    public boolean isMixReferenceable() {
        return this.isMixReferenceable;
    }

    public boolean isMixVersionable() {
        return this.isMixVersionable;
    }

    public void setBaseVersionIdentifier(String baseVersionIdentifier) {
        this.baseVersionIdentifier = baseVersionIdentifier;
    }

    public void setContainsVersionhistory(boolean isContainsVersionhistory) {
        this.isContainsVersionhistory = isContainsVersionhistory;
    }

    public void setMixReferenceable(boolean isMixReferenceable) {
        this.isMixReferenceable = isMixReferenceable;
    }

    public void setMixVersionable(boolean isMixVersionable) {
        this.isMixVersionable = isMixVersionable;
    }

    @Override
    public void setParentIdentifer(String identifer) {
        this.parentIdentifier = identifer;
    }

    public void setPrimaryTypeName(InternalQName name) {
        this.primaryTypeName = name;
    }

    @Override
    public void setQPath(QPath path) {
        this.qpath = path;
    }

    public void setVersionHistoryIdentifier(String versionHistoryIdentifier) {
        this.versionHistoryIdentifier = versionHistoryIdentifier;
    }

    public static ImportNodeData createCopy(TransientNodeData source) {
        return new ImportNodeData(source.getQPath(), source.getIdentifier(), source.getPersistedVersion(), source.getPrimaryTypeName(), source.getMixinTypeNames(), source.getOrderNumber(), source.getParentIdentifier(), source.getACL());
    }
}

