/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.Property;
import org.exoplatform.services.rest.Connector;
import org.exoplatform.services.rest.ContextParam;
import org.exoplatform.services.rest.HeaderParam;
import org.exoplatform.services.rest.MultivaluedMetadata;
import org.exoplatform.services.rest.QueryParam;
import org.exoplatform.services.rest.Request;
import org.exoplatform.services.rest.ResourceBinder;
import org.exoplatform.services.rest.ResourceIdentifier;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.container.InvalidResourceDescriptorException;
import org.exoplatform.services.rest.container.ResourceDescriptor;
import org.exoplatform.services.rest.data.MimeTypes;
import org.exoplatform.services.rest.transformer.EntityTransformerFactory;
import org.exoplatform.services.rest.transformer.GenericEntityTransformer;
import org.exoplatform.services.rest.transformer.InputEntityTransformer;
import org.exoplatform.services.rest.transformer.OutputEntityTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDispatcher
implements Connector {
    public static final String CONTEXT_PARAM_HOST = "host";
    public static final String CONTEXT_PARAM_BASE_URI = "baseURI";
    public static final String CONTEXT_PARAM_REL_URI = "relURI";
    public static final String CONTEXT_PARAM_ABSLOCATION = "absLocation";
    private List<ResourceDescriptor> resourceDescriptors_;
    private ThreadLocal<Context> contextHolder_ = new ThreadLocal();
    private final Map<String, String> contextParams_ = new HashMap<String, String>();
    private EntityTransformerFactory factory_;

    public ResourceDispatcher(InitParams params, ResourceBinder binder, EntityTransformerFactory factory) throws Exception {
        PropertiesParam contextParam;
        if (params != null && (contextParam = params.getPropertiesParam("context-params")) != null) {
            Iterator iterator = contextParam.getPropertyIterator();
            while (iterator.hasNext()) {
                Property property = (Property)iterator.next();
                this.contextParams_.put(property.getName(), property.getValue());
            }
        }
        this.resourceDescriptors_ = binder.getAllDescriptors();
        this.factory_ = factory;
    }

    public Response dispatch(Request request) throws Exception {
        String requestedURI = request.getResourceIdentifier().getURI();
        String methodName = request.getMethodName();
        String acceptedMimeTypes = request.getHeaderParams().get("accept") != null ? request.getHeaderParams().get("accept") : "*/*";
        MimeTypes requestedMimeTypes = new MimeTypes(acceptedMimeTypes);
        ResourceDescriptor resource = null;
        for (ResourceDescriptor r : this.resourceDescriptors_) {
            MimeTypes producedMimeTypes = new MimeTypes(r.getProducedMimeTypes());
            MultivaluedMetadata annotatedQueryParams = r.getQueryPattern();
            if (!r.getAcceptableMethod().equalsIgnoreCase(methodName) || !r.getURIPattern().matches(requestedURI) || !this.compareMimeTypes(requestedMimeTypes.getMimeTypes(), producedMimeTypes.getMimeTypes()) || !this.isQueryParamsMatches(request.getQueryParams(), annotatedQueryParams)) continue;
            if (resource == null) {
                resource = r;
                continue;
            }
            if (r.getURIPattern().matches(resource.getURIPattern()) || r.getURIPattern().getTotalTokensLength() <= resource.getURIPattern().getTotalTokensLength()) continue;
            resource = r;
        }
        if (resource != null) {
            GenericEntityTransformer transformer;
            ResourceIdentifier identifier = request.getResourceIdentifier();
            identifier.initParameters(resource.getURIPattern());
            this.contextHolder_.set(new Context(this.contextParams_, identifier));
            Annotation[] methodParametersAnnotations = resource.getMethodParameterAnnotations();
            Class<?>[] methodParameters = resource.getMethodParameters();
            Object[] params = new Object[methodParameters.length];
            for (int i = 0; i < methodParametersAnnotations.length; ++i) {
                if (methodParametersAnnotations[i] == null) {
                    transformer = (InputEntityTransformer)this.factory_.newTransformer(resource.getInputTransformerType());
                    ((InputEntityTransformer)transformer).setType(methodParameters[i]);
                    params[i] = ((InputEntityTransformer)transformer).readFrom(request.getEntityStream());
                    continue;
                }
                Constructor<?> constructor = methodParameters[i].getConstructor(String.class);
                String constructorParam = null;
                Annotation a = methodParametersAnnotations[i];
                if (a.annotationType().isAssignableFrom(URIParam.class)) {
                    URIParam u = (URIParam)a;
                    constructorParam = request.getResourceIdentifier().getParameters().get(u.value());
                } else if (a.annotationType().isAssignableFrom(HeaderParam.class)) {
                    HeaderParam h = (HeaderParam)a;
                    constructorParam = request.getHeaderParams().get(h.value());
                } else if (a.annotationType().isAssignableFrom(QueryParam.class)) {
                    QueryParam q = (QueryParam)a;
                    constructorParam = request.getQueryParams().get(q.value());
                } else if (a.annotationType().isAssignableFrom(ContextParam.class)) {
                    ContextParam c = (ContextParam)a;
                    constructorParam = this.contextHolder_.get().get(c.value());
                }
                params[i] = methodParameters[i].isAssignableFrom(String.class) ? constructorParam : (constructorParam != null ? constructor.newInstance(constructorParam) : null);
            }
            Response response = (Response)resource.getServer().invoke((Object)resource.getResourceContainer(), params);
            if (!response.isTransformerInitialized() && response.isEntityInitialized()) {
                response.setTransformer(this.getTransformer(resource, response.getTransformerParameters()));
            } else {
                transformer = response.getTransformer();
                if (transformer != null) {
                    ((OutputEntityTransformer)transformer).addTransformerParameters(response.getTransformerParameters());
                }
            }
            return response;
        }
        throw new NoSuchMethodException("No method found for " + methodName + " " + requestedURI + " " + acceptedMimeTypes);
    }

    @Deprecated
    public Context getRuntimeContext() {
        return this.contextHolder_.get();
    }

    public void addContextParameter(String key, String value) {
        this.contextHolder_.get().set(key, value);
    }

    private OutputEntityTransformer getTransformer(ResourceDescriptor resource, Map<String, String> transformerParameters) throws InvalidResourceDescriptorException {
        try {
            OutputEntityTransformer transformer = (OutputEntityTransformer)this.factory_.newTransformer(resource.getOutputTransformerType());
            transformer.addTransformerParameters(transformerParameters);
            return transformer;
        }
        catch (Exception e) {
            throw new InvalidResourceDescriptorException("Could not get EntityTransformer from Response or annotation to ResourceDescriptor. Exception: " + e);
        }
    }

    private boolean isQueryParamsMatches(MultivaluedMetadata fromRequest, MultivaluedMetadata queryPattern) {
        if (queryPattern.keys().size() == 0) {
            return true;
        }
        if (!fromRequest.keys().containsAll(queryPattern.keys())) {
            return false;
        }
        Set<String> keys = queryPattern.keys();
        for (String key : keys) {
            List<String> p;
            List<String> r = fromRequest.getList(key);
            if (r.containsAll(p = queryPattern.getList(key))) continue;
            return false;
        }
        return true;
    }

    private boolean compareMimeTypes(String[] requested, String[] produced) {
        for (String r : requested) {
            for (String p : produced) {
                if ("*/*".equals(p)) {
                    return true;
                }
                if (p.equals(r)) {
                    return true;
                }
                String[] rsubtype = r.split("/");
                String[] psubtype = p.split("/");
                if (!psubtype[0].equals(rsubtype[0]) || !"*".equals(psubtype[1])) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Context {
        private final Map<String, String> params_;

        private Context(Map<String, String> params, ResourceIdentifier identifier) {
            this.params_ = params;
            this.params_.put(ResourceDispatcher.CONTEXT_PARAM_HOST, identifier.getHost());
            this.params_.put(ResourceDispatcher.CONTEXT_PARAM_BASE_URI, identifier.getBaseURI());
            this.params_.put(ResourceDispatcher.CONTEXT_PARAM_REL_URI, identifier.getURI());
            this.params_.put(ResourceDispatcher.CONTEXT_PARAM_ABSLOCATION, identifier.getBaseURI() + identifier.getURI());
        }

        @Deprecated
        public String getServerName() {
            return this.params_.get(ResourceDispatcher.CONTEXT_PARAM_HOST);
        }

        @Deprecated
        public String getContextHref() {
            return this.params_.get(ResourceDispatcher.CONTEXT_PARAM_BASE_URI);
        }

        @Deprecated
        public String getAbsLocation() {
            return this.params_.get(ResourceDispatcher.CONTEXT_PARAM_BASE_URI) + this.params_.get(ResourceDispatcher.CONTEXT_PARAM_REL_URI);
        }

        @Deprecated
        public String createAbsLocation(String additionalPath) {
            return this.getAbsLocation() + additionalPath;
        }

        private String get(String key) {
            return this.params_.get(key);
        }

        private void set(String key, String value) {
            this.params_.put(key, value);
        }
    }
}

