/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest;

import java.util.Map;
import org.exoplatform.services.rest.URIPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceIdentifier {
    private Map<String, String> parameters = null;
    private String host = "localhost";
    private String uri;
    private String baseURI;

    public ResourceIdentifier(String host, String baseURI, String relURI) {
        this(baseURI, relURI);
        this.host = host;
    }

    public ResourceIdentifier(String baseURI, String relURI) {
        this.uri = relURI.endsWith("/") ? relURI : relURI + "/";
        this.baseURI = baseURI;
    }

    public ResourceIdentifier(String relURI) {
        this("", relURI);
    }

    public String getHost() {
        return this.host;
    }

    public String getURI() {
        return this.uri;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void initParameters(URIPattern pattern) {
        this.parameters = pattern.parse(this.uri);
    }

    public Map<String, String> getParameters() throws IllegalStateException {
        if (this.parameters == null) {
            throw new IllegalStateException("Prarameters are not initialized. Call initParameters(pattern) first");
        }
        return this.parameters;
    }
}

