/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.rest.CacheControl;
import org.exoplatform.services.rest.EntityMetadata;
import org.exoplatform.services.rest.MultivaluedMetadata;
import org.exoplatform.services.rest.transformer.OutputEntityTransformer;
import org.exoplatform.services.rest.transformer.StringOutputTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Response {
    private int status_;
    private EntityMetadata metadata_;
    private Object entity_;
    private OutputEntityTransformer transformer_;
    private Map<String, String> transformerParameters_;
    private MultivaluedMetadata responseHeaders_;

    protected Response(int status, MultivaluedMetadata responseHeaders, Object entity, OutputEntityTransformer transformer, Map<String, String> transformerParameters) {
        this.status_ = status;
        this.entity_ = entity;
        this.transformer_ = transformer;
        this.transformerParameters_ = transformerParameters;
        this.responseHeaders_ = responseHeaders;
        this.metadata_ = new EntityMetadata(responseHeaders);
    }

    public int getStatus() {
        return this.status_;
    }

    public MultivaluedMetadata getResponseHeaders() {
        return this.responseHeaders_;
    }

    public Object getEntity() {
        return this.entity_;
    }

    public EntityMetadata getEntityMetadata() {
        return this.metadata_;
    }

    public boolean isTransformerInitialized() {
        return this.transformer_ != null;
    }

    public boolean isEntityInitialized() {
        return this.entity_ != null;
    }

    public Map<String, String> getTransformerParameters() {
        return this.transformerParameters_;
    }

    public void setTransformer(OutputEntityTransformer transformer) {
        this.transformer_ = transformer;
    }

    public void writeEntity(OutputStream outputEntityStream) throws IOException {
        if (this.transformer_ != null) {
            this.transformer_.writeTo(this.entity_, outputEntityStream);
        }
    }

    public OutputEntityTransformer getTransformer() {
        return this.transformer_;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        int status = -1;
        Object entity;
        MultivaluedMetadata responseHeaders = new MultivaluedMetadata();
        OutputEntityTransformer transformer;
        Map<String, String> transformerParameters;

        protected Builder() {
        }

        protected static synchronized Builder newInstance() {
            return new Builder();
        }

        public Response build() {
            return new Response(this.status, this.responseHeaders, this.entity, this.transformer, this.transformerParameters);
        }

        public static Builder withStatus(int st) {
            Builder b = Builder.newInstance();
            b.status(st);
            return b;
        }

        public static Builder representation(Object e) {
            Builder b = Builder.newInstance();
            b.status(200);
            b.entity(e);
            return b;
        }

        public static Builder representation(Object e, String type) {
            Builder b = Builder.representation(e);
            b.mediaType(type);
            return b;
        }

        public static Builder ok() {
            Builder b = Builder.newInstance();
            b.status(200);
            return b;
        }

        public static Builder ok(Object e) {
            Builder b = Builder.ok();
            b.entity(e);
            return b;
        }

        public static Builder ok(Object e, String mediaType) {
            Builder b = Builder.ok(e).mediaType(mediaType);
            return b;
        }

        public static Builder created(String location) {
            Builder b = Builder.newInstance();
            b.status(201);
            b.responseHeaders.putSingle("Location", location);
            return b;
        }

        public static Builder created(Object e, String location) {
            Builder b = Builder.created(location);
            b.entity(e);
            return b;
        }

        public static Builder accepted() {
            Builder b = Builder.newInstance();
            b.status(202);
            return b;
        }

        public static Builder noContent() {
            Builder b = Builder.newInstance();
            b.status(204);
            return b;
        }

        public static Builder temporaryRedirect(String location) {
            Builder b = Builder.newInstance();
            b.status(307);
            b.locations(location);
            return b;
        }

        public static Builder notModified() {
            Builder b = Builder.newInstance();
            b.status(304);
            return b;
        }

        public static Builder notModified(String tag) {
            Builder b = Builder.notModified();
            b.tag(tag);
            return b;
        }

        public static Builder forbidden() {
            Builder b = Builder.newInstance();
            b.status(403);
            return b;
        }

        public static Builder notFound() {
            Builder b = Builder.newInstance();
            b.status(404);
            return b;
        }

        public static Builder badRequest() {
            Builder b = Builder.newInstance();
            b.status(400);
            return b;
        }

        public static Builder serverError() {
            Builder b = Builder.newInstance();
            b.status(500);
            return b;
        }

        public Builder status(int st) {
            this.status = st;
            return this;
        }

        public Builder entity(Object e) {
            this.entity = e;
            return this;
        }

        public Builder entity(Object e, String mediaType) {
            this.entity = e;
            this.responseHeaders.putSingle("Content-Type", mediaType);
            return this;
        }

        public Builder mediaType(String mediaType) {
            this.responseHeaders.putSingle("Content-Type", mediaType);
            return this;
        }

        public Builder languages(List<String> languages) {
            this.responseHeaders.put("Content-Language", languages);
            return this;
        }

        public Builder encodings(List<String> encodings) {
            this.responseHeaders.put("Content-Encoding", encodings);
            return this;
        }

        public Builder locations(String location) {
            this.responseHeaders.putSingle("Location", location);
            return this;
        }

        public Builder lastModified(Date lastModified) {
            this.responseHeaders.putSingle("Last-Modified", DateFormat.getInstance().format(lastModified));
            return this;
        }

        public Builder contentLenght(long length) {
            this.responseHeaders.putSingle("Content-Length", length + "");
            return this;
        }

        public Builder tag(String tag) {
            this.responseHeaders.putSingle("ETag", tag);
            return this;
        }

        public Builder transformer(OutputEntityTransformer trf) {
            this.transformer = trf;
            return this;
        }

        public Builder setTransformerParameters(Map<String, String> trfParams) {
            this.transformerParameters = trfParams;
            return this;
        }

        public Builder header(String key, String value) {
            this.responseHeaders.putSingle(key, value);
            return this;
        }

        public Builder headers(MultivaluedMetadata headers) {
            this.responseHeaders = headers;
            return this;
        }

        public Builder cacheControl(CacheControl c) {
            this.responseHeaders.putSingle("Cache-Control", c.getAsString());
            return this;
        }

        public Builder errorMessage(String message) {
            this.entity = message;
            this.transformer = new StringOutputTransformer();
            return this;
        }
    }
}

