/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.data;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HeaderUtils {
    private static final Pattern SPACE_PATTERN = Pattern.compile("(\\s+)");

    private HeaderUtils() {
    }

    public static String[] parse(String s) {
        if (s != null && s.length() != 0) {
            s = HeaderUtils.normalizeAccepString(s);
            String[] ss = s.split(",");
            HeaderUtils.sortByQvalue(ss, 0, ss.length - 1);
            return HeaderUtils.removeQvalues(ss);
        }
        return null;
    }

    public static String normalizeAccepString(String s) {
        Matcher m = SPACE_PATTERN.matcher(s);
        return m.replaceAll("");
    }

    private static float parseQuality(String s) {
        float q = Float.valueOf(s).floatValue();
        if (q >= 0.0f && q <= 1.0f) {
            return q;
        }
        throw new IllegalArgumentException("Invalid quality value " + q + ", must be between 0 and 1");
    }

    private static String[] sortByQvalue(String[] s, int i0, int k0) {
        int i = i0;
        int k = k0;
        if (k0 > i0) {
            float middleQvalue = HeaderUtils.getQvalue(s[(i0 + k0) / 2]).floatValue();
            while (i <= k) {
                while (i < k0 && HeaderUtils.getQvalue(s[i]).floatValue() > middleQvalue) {
                    ++i;
                }
                while (k > i0 && HeaderUtils.getQvalue(s[k]).floatValue() < middleQvalue) {
                    --k;
                }
                if (i > k) continue;
                HeaderUtils.swap(s, i, k);
                ++i;
                --k;
            }
            if (i0 < k) {
                HeaderUtils.sortByQvalue(s, i0, k);
            }
            if (i < k0) {
                HeaderUtils.sortByQvalue(s, i, k0);
            }
        }
        return s;
    }

    private static Float getQvalue(String s) {
        String[] temp;
        float q = 1.0f;
        for (String t : temp = s.split(";")) {
            if (!t.startsWith("q=")) continue;
            String[] qq = t.split("=");
            q = HeaderUtils.parseQuality(qq[1]);
        }
        return Float.valueOf(q);
    }

    private static String[] removeQvalues(String[] s) {
        for (int i = 0; i < s.length; ++i) {
            s[i] = s[i].split(";q=")[0];
        }
        return s;
    }

    private static void swap(String[] s, int i, int j) {
        String t = s[i];
        s[i] = s[j];
        s[j] = t;
    }
}

