/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.server;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.Property;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.servlet.RestServlet;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.plus.jaas.JAASUserRealm;
import org.mortbay.jetty.plus.jaas.RoleCheckPolicy;
import org.mortbay.jetty.plus.jaas.callback.DefaultCallbackHandler;
import org.mortbay.jetty.security.Constraint;
import org.mortbay.jetty.security.ConstraintMapping;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.picocontainer.Startable;

public class StandaloneRestServer
implements Startable {
    private static final Log LOGGER = ExoLogger.getLogger((String)"StandaloneRestServer");
    private static final String[] DUMMY_ROLES = new String[]{"user"};
    private static final String REALM = "exo-realm";
    private static final String CONFIG_FILTER_NAME_PREFIX = "filter-class";
    private static final String CONFIG_FILTER_MAPPING_PREFIX = "filter-mapping";
    private static final String CONFIG_SERVER_PORT = "server-port";
    private static final String CONFIG_CONTEXT_PATH = "context-path";
    private static final String CONFIG_SERVLET_MAPPING = "servlet-mapping";
    private static final String CONFIG_AUTHENTICATION = "authentication";
    private static final String CONFIG_LOGIN_MODULE_NAME = "login-module-name";
    private static final String CONFIG_SECURITY_CONSTRAINT_MAPPING = "security-constraint-mapping";
    private final int port;
    private final String authentication;
    private final String loginModuleName;
    private final String servletContextPath;
    private final String servletURIPattern;
    private final String securityConstraintURIPattern;
    private final List<String> filterURIPatterns;
    private final List<String> filters;
    private Server server;

    public StandaloneRestServer(InitParams initParams) {
        PropertiesParam params = initParams.getPropertiesParam("standalone-rest-server.properties");
        Iterator iterator = params.getPropertyIterator();
        this.filters = new ArrayList<String>();
        this.filterURIPatterns = new ArrayList<String>();
        int i = 0;
        while (iterator.hasNext()) {
            Property f = (Property)iterator.next();
            String pname = f.getName();
            if (pname.startsWith(CONFIG_FILTER_NAME_PREFIX)) {
                this.filters.add(f.getValue());
                LOGGER.info((Object)("Filter: " + f.getValue()));
                String fmap = params.getProperty(CONFIG_FILTER_MAPPING_PREFIX + pname.substring(CONFIG_FILTER_NAME_PREFIX.length()));
                this.filterURIPatterns.add(fmap != null ? fmap : "/*");
                LOGGER.info((Object)("Filter mapping: " + fmap));
            }
            ++i;
        }
        this.port = params.getProperty(CONFIG_SERVER_PORT) != null ? Integer.valueOf(params.getProperty(CONFIG_SERVER_PORT)) : 8080;
        LOGGER.debug((Object)("port: " + this.port));
        this.servletContextPath = params.getProperty(CONFIG_CONTEXT_PATH);
        if (this.servletContextPath == null) {
            throw new NullPointerException("ContextPath is null");
        }
        LOGGER.debug((Object)("RestServlet ContextPath: " + this.servletContextPath));
        this.servletURIPattern = params.getProperty(CONFIG_SERVLET_MAPPING) != null ? params.getProperty(CONFIG_SERVLET_MAPPING) : "/*";
        LOGGER.debug((Object)("RestServlet URI pattern: " + this.servletURIPattern));
        this.authentication = params.getProperty(CONFIG_AUTHENTICATION) != null ? params.getProperty(CONFIG_AUTHENTICATION) : "BASIC";
        LOGGER.debug((Object)("Authentication: " + this.authentication));
        this.loginModuleName = params.getProperty(CONFIG_LOGIN_MODULE_NAME) != null ? params.getProperty(CONFIG_LOGIN_MODULE_NAME) : "exo-domain";
        LOGGER.debug((Object)("Login module: " + this.loginModuleName));
        this.securityConstraintURIPattern = params.getProperty(CONFIG_SECURITY_CONSTRAINT_MAPPING) != null ? params.getProperty(CONFIG_SECURITY_CONSTRAINT_MAPPING) : "/*";
        LOGGER.debug((Object)("Security constraint URI pattern: " + this.securityConstraintURIPattern));
    }

    public void start() {
        this.server = this.createServer();
        try {
            this.server.start();
            LOGGER.info((Object)"StandaloneRestServer started.");
        }
        catch (Exception e) {
            LOGGER.error((Object)"Start StandaloneRestServer failed!");
            e.printStackTrace();
        }
    }

    public void stop() {
        try {
            this.server.stop();
            LOGGER.info((Object)"StandaloneRestServer stoped.");
        }
        catch (Exception e) {
            LOGGER.error((Object)"Stop StandaloneRestServer failed!");
        }
    }

    public Server getServer() {
        return this.server;
    }

    private Server createServer() {
        Server server_ = new Server(this.port);
        Context context = new Context((HandlerContainer)server_, this.servletContextPath, 1);
        context.setSecurityHandler(this.createSecurityHandler());
        ServletHolder holder = new ServletHolder((Servlet)new RestServlet());
        context.addServlet(holder, this.servletURIPattern);
        int i = 0;
        for (String filter : this.filters) {
            context.addFilter(filter, this.filterURIPatterns.get(i++), 1);
        }
        return server_;
    }

    private SecurityHandler createSecurityHandler() {
        Constraint constraint = new Constraint();
        constraint.setName(this.authentication);
        constraint.setRoles(DUMMY_ROLES);
        constraint.setAuthenticate(true);
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setPathSpec(this.securityConstraintURIPattern);
        mapping.setConstraint(constraint);
        JAASUserRealm jaasUserRealm = new JAASUserRealm(REALM);
        jaasUserRealm.setLoginModuleName(this.loginModuleName);
        jaasUserRealm.setCallbackHandlerClass(DefaultCallbackHandler.class.getName());
        jaasUserRealm.setRoleCheckPolicy((RoleCheckPolicy)new DummyRoleCheckPolicy());
        SecurityHandler securityHandler = new SecurityHandler();
        securityHandler.setUserRealm((UserRealm)jaasUserRealm);
        securityHandler.setConstraintMappings(new ConstraintMapping[]{mapping});
        return securityHandler;
    }

    static class DummyRoleCheckPolicy
    implements RoleCheckPolicy {
        DummyRoleCheckPolicy() {
        }

        public boolean checkRole(String role, Principal userPrincipal, Group group) {
            return true;
        }
    }
}

