/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.Connector;
import org.exoplatform.services.rest.MultivaluedMetadata;
import org.exoplatform.services.rest.ResourceDispatcher;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.servlet.RequestFactory;

public class RestServlet
extends HttpServlet
implements Connector {
    private static final Log LOGGER = ExoLogger.getLogger((String)"RestServlet");

    public void service(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        LOGGER.debug((Object)("Current Container: " + container));
        ResourceDispatcher dispatcher = (ResourceDispatcher)container.getComponentInstanceOfType(ResourceDispatcher.class);
        LOGGER.debug((Object)("ResourceDispatcher: " + dispatcher));
        if (dispatcher == null) {
            throw new ServletException("ResourceDispatcher is null.");
        }
        try {
            Response response = dispatcher.dispatch(RequestFactory.createRequest(httpRequest));
            httpResponse.setStatus(response.getStatus());
            this.tuneResponse(httpResponse, response.getResponseHeaders());
            ServletOutputStream out = httpResponse.getOutputStream();
            response.writeEntity((OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            LOGGER.error((Object)"dispatch method error!");
            e.printStackTrace();
            httpResponse.sendError(500, "This request can't be serve by service.\nCheck request parameters and try again.");
        }
    }

    private void tuneResponse(HttpServletResponse httpResponse, MultivaluedMetadata responseHeaders) {
        if (responseHeaders != null) {
            HashMap<String, String> headers = responseHeaders.getAll();
            Set<String> keys = headers.keySet();
            for (String key : keys) {
                httpResponse.setHeader(key, headers.get(key));
            }
        }
    }
}

