/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v1.util.ClosableResource;
import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.impl.C3P0PooledConnection;
import com.mchange.v2.c3p0.impl.SetManagedDatabaseMetaData;
import com.mchange.v2.c3p0.impl.SetManagedResultSet;
import com.mchange.v2.c3p0.stmt.GooGooStatementCache;
import com.mchange.v2.c3p0.util.ConnectionEventSupport;
import com.mchange.v2.sql.SqlUtils;
import com.mchange.v2.sql.filter.FilterCallableStatement;
import com.mchange.v2.sql.filter.FilterPreparedStatement;
import com.mchange.v2.sql.filter.FilterStatement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public final class C3P0PooledConnection
implements PooledConnection,
ClosableResource {
    static final ClassLoader CL = (class$com$mchange$v2$c3p0$impl$C3P0PooledConnection == null ? (class$com$mchange$v2$c3p0$impl$C3P0PooledConnection = C3P0PooledConnection.class$("com.mchange.v2.c3p0.impl.C3P0PooledConnection")) : class$com$mchange$v2$c3p0$impl$C3P0PooledConnection).getClassLoader();
    static final Class[] PROXY_CTOR_ARGS = new Class[]{class$java$lang$reflect$InvocationHandler == null ? (class$java$lang$reflect$InvocationHandler = C3P0PooledConnection.class$("java.lang.reflect.InvocationHandler")) : class$java$lang$reflect$InvocationHandler};
    static final Constructor CON_PROXY_CTOR;
    static final Method RS_CLOSE_METHOD;
    static final Method STMT_CLOSE_METHOD;
    static final Object[] CLOSE_ARGS;
    static final Set OBJECT_METHODS;
    final ConnectionTester connectionTester;
    final boolean autoCommitOnClose;
    final boolean forceIgnoreUnresolvedTransactions;
    final ConnectionEventSupport ces = new ConnectionEventSupport(this);
    volatile Connection physicalConnection;
    volatile Exception invalidatingException = null;
    ProxyConnection exposedProxy;
    int connection_status = 0;
    final Set uncachedActiveStatements = Collections.synchronizedSet(new HashSet());
    volatile GooGooStatementCache scache;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$C3P0PooledConnection;
    static /* synthetic */ Class class$java$lang$reflect$InvocationHandler;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$C3P0PooledConnection$ProxyConnection;
    static /* synthetic */ Class class$java$sql$ResultSet;
    static /* synthetic */ Class class$java$sql$Statement;
    static /* synthetic */ Class class$java$lang$Object;

    private static Constructor createProxyConstructor(Class intfc) throws NoSuchMethodException {
        Class[] proxyInterfaces = new Class[]{intfc};
        Class<?> proxyCl = Proxy.getProxyClass(CL, proxyInterfaces);
        return proxyCl.getConstructor(PROXY_CTOR_ARGS);
    }

    public C3P0PooledConnection(Connection con, ConnectionTester connectionTester, boolean autoCommitOnClose, boolean forceIgnoreUnresolvedTransactions) {
        this.physicalConnection = con;
        this.connectionTester = connectionTester;
        this.autoCommitOnClose = autoCommitOnClose;
        this.forceIgnoreUnresolvedTransactions = forceIgnoreUnresolvedTransactions;
    }

    Connection getPhysicalConnection() {
        return this.physicalConnection;
    }

    boolean isClosed() throws SQLException {
        return this.physicalConnection == null;
    }

    void initStatementCache(GooGooStatementCache scache) {
        this.scache = scache;
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.exposedProxy != null) {
            System.err.println("c3p0 -- Uh oh... getConnection() was called on a PooledConnection when it had already provided a client with a Connection that has not yet been closed. This probably indicates a bug in the connection pool!!!");
            return this.exposedProxy;
        }
        return this.getCreateNewConnection();
    }

    private Connection getCreateNewConnection() throws SQLException {
        try {
            this.ensureOkay();
            this.exposedProxy = this.createProxyConnection();
            return this.exposedProxy;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SQLException("Failed to acquire connection!");
        }
    }

    public void closeAll() throws SQLException {
        if (this.scache != null) {
            this.scache.closeAll(this.physicalConnection);
        }
    }

    public void close() throws SQLException {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void close(boolean known_invalid) throws SQLException {
        block22: {
            if (this.physicalConnection != null) {
                try {
                    Exception exc;
                    StringBuffer debugOnlyLog = null;
                    if (known_invalid) {
                        debugOnlyLog = new StringBuffer();
                        debugOnlyLog.append("[ exceptions: ");
                    }
                    if ((exc = this.cleanupUncachedActiveStatements()) != null) {
                        if (known_invalid) {
                            debugOnlyLog.append(exc.toString() + ' ');
                        } else {
                            exc.printStackTrace();
                        }
                    }
                    try {
                        if (this.exposedProxy != null) {
                            this.exposedProxy.silentClose(known_invalid);
                        }
                    }
                    catch (Exception e) {
                        if (known_invalid) {
                            debugOnlyLog.append(e.toString() + ' ');
                        } else {
                            e.printStackTrace();
                        }
                        exc = e;
                    }
                    try {
                        this.closeAll();
                    }
                    catch (Exception e) {
                        if (known_invalid) {
                            debugOnlyLog.append(e.toString() + ' ');
                        } else {
                            e.printStackTrace();
                        }
                        exc = e;
                    }
                    try {
                        this.physicalConnection.close();
                    }
                    catch (Exception e) {
                        if (known_invalid) {
                            debugOnlyLog.append(e.toString() + ' ');
                        } else {
                            e.printStackTrace();
                        }
                        exc = e;
                    }
                    if (exc == null) break block22;
                    if (known_invalid) {
                        debugOnlyLog.append(" ]");
                        System.err.print("[DEBUG]" + this + ": while closing a PooledConnection known to be invalid, ");
                        System.err.println("  some exceptions occurred. This is probably not a problem:");
                        System.err.println(debugOnlyLog.toString());
                        break block22;
                    }
                    throw new SQLException("At least one error occurred while attempting to close() the PooledConnection: " + exc);
                }
                finally {
                    this.physicalConnection = null;
                }
            }
        }
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.ces.addConnectionEventListener(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.ces.removeConnectionEventListener(listener);
    }

    private void reset() throws SQLException {
        this.ensureOkay();
        if (!this.forceIgnoreUnresolvedTransactions && !this.physicalConnection.getAutoCommit()) {
            if (this.autoCommitOnClose) {
                this.physicalConnection.commit();
            } else {
                this.physicalConnection.rollback();
            }
            this.physicalConnection.setAutoCommit(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean closeAndRemoveResultSets(Set rsSet) {
        boolean okay = true;
        Set set = rsSet;
        synchronized (set) {
            Iterator ii = rsSet.iterator();
            while (ii.hasNext()) {
                ResultSet rs = (ResultSet)ii.next();
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    okay = false;
                }
                finally {
                    ii.remove();
                }
            }
        }
        return okay;
    }

    void ensureOkay() throws SQLException {
        if (this.physicalConnection == null) {
            throw new SQLException(this.invalidatingException == null ? "Connection is closed or broken." : "Connection is broken. Invalidating Exception: " + this.invalidatingException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean closeAndRemoveResourcesInSet(Set s, Method closeMethod) {
        HashSet temp;
        boolean okay = true;
        Set set = s;
        synchronized (set) {
            temp = new HashSet(s);
        }
        Iterator ii = temp.iterator();
        while (ii.hasNext()) {
            Object rsrc = ii.next();
            try {
                closeMethod.invoke(rsrc, CLOSE_ARGS);
            }
            catch (Exception e) {
                Throwable t = e;
                if (t instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)e).getTargetException();
                }
                t.printStackTrace();
                okay = false;
            }
            finally {
                s.remove(rsrc);
            }
        }
        return okay;
    }

    private SQLException cleanupUncachedActiveStatements() {
        boolean okay = this.closeAndRemoveResourcesInSet(this.uncachedActiveStatements, STMT_CLOSE_METHOD);
        if (okay) {
            return null;
        }
        return new SQLException("An exception occurred while trying to clean up orphaned resources.");
    }

    ProxyConnection createProxyConnection() throws Exception {
        ProxyConnectionInvocationHandler handler = new ProxyConnectionInvocationHandler();
        return (ProxyConnection)CON_PROXY_CTOR.newInstance(handler);
    }

    Statement createProxyStatement(Statement innerStmt) throws Exception {
        return this.createProxyStatement(false, innerStmt);
    }

    Statement createProxyStatement(final boolean inner_is_cached, final Statement innerStmt) throws Exception {
        final Set activeResultSets = Collections.synchronizedSet(new HashSet());
        final ProxyConnection parentConnection = this.exposedProxy;
        if (parentConnection == null) {
            System.err.print("PROBABLE C3P0 BUG -- ");
            System.err.println(this + ": created a proxy Statement when there is no active, exposed proxy Connection???");
        }
        final StatementProxyingSetManagedResultSet mainResultSet = new StatementProxyingSetManagedResultSet(activeResultSets);
        if (innerStmt instanceof CallableStatement) {
            return new FilterCallableStatement((CallableStatement)innerStmt){
                1WrapperStatementHelper wsh;
                {
                    class 1WrapperStatementHelper {
                        Statement wrappedStmt;
                        private final /* synthetic */ boolean val$inner_is_cached;
                        private final /* synthetic */ Set val$activeResultSets;
                        private final /* synthetic */ StatementProxyingSetManagedResultSet val$mainResultSet;
                        private final /* synthetic */ Statement val$innerStmt;
                        private final /* synthetic */ C3P0PooledConnection this$0;

                        public 1WrapperStatementHelper(C3P0PooledConnection this$0, Statement wrappedStmt, boolean val$inner_is_cached, Set val$activeResultSets, StatementProxyingSetManagedResultSet val$mainResultSet, Statement val$innerStmt) {
                            this.this$0 = this$0;
                            this.val$inner_is_cached = val$inner_is_cached;
                            this.val$activeResultSets = val$activeResultSets;
                            this.val$mainResultSet = val$mainResultSet;
                            this.val$innerStmt = val$innerStmt;
                            this.wrappedStmt = wrappedStmt;
                            if (!this.val$inner_is_cached) {
                                this$0.uncachedActiveStatements.add(wrappedStmt);
                            }
                        }

                        private boolean closeAndRemoveActiveResultSets() {
                            return this.this$0.closeAndRemoveResultSets(this.val$activeResultSets);
                        }

                        public ResultSet wrap(ResultSet rs) {
                            if (this.val$mainResultSet.getInner() == null) {
                                this.val$mainResultSet.setInner(rs);
                                this.val$mainResultSet.setProxyStatement(this.wrappedStmt);
                                return this.val$mainResultSet;
                            }
                            StatementProxyingSetManagedResultSet out = new StatementProxyingSetManagedResultSet(this.val$activeResultSets);
                            out.setInner(rs);
                            out.setProxyStatement(this.wrappedStmt);
                            return out;
                        }

                        public void doClose() throws SQLException {
                            boolean okay = this.closeAndRemoveActiveResultSets();
                            if (this.val$inner_is_cached) {
                                this.this$0.scache.checkinStatement(this.val$innerStmt);
                            } else {
                                this.val$innerStmt.close();
                                this.this$0.uncachedActiveStatements.remove(this.wrappedStmt);
                            }
                            if (!okay) {
                                throw new SQLException("Failed to close an orphaned ResultSet properly.");
                            }
                        }
                    }
                    this.wsh = new 1WrapperStatementHelper(C3P0PooledConnection.this, this, inner_is_cached, activeResultSets, mainResultSet, innerStmt);
                }

                public Connection getConnection() {
                    return parentConnection;
                }

                public ResultSet getResultSet() throws SQLException {
                    return this.wsh.wrap(super.getResultSet());
                }

                public ResultSet getGeneratedKeys() throws SQLException {
                    return this.wsh.wrap(super.getGeneratedKeys());
                }

                public ResultSet executeQuery(String sql) throws SQLException {
                    return this.wsh.wrap(super.executeQuery(sql));
                }

                public ResultSet executeQuery() throws SQLException {
                    return this.wsh.wrap(super.executeQuery());
                }

                public void close() throws SQLException {
                    this.wsh.doClose();
                }
            };
        }
        if (innerStmt instanceof PreparedStatement) {
            return new FilterPreparedStatement((PreparedStatement)innerStmt){
                1WrapperStatementHelper wsh;
                {
                    this.wsh = new 1WrapperStatementHelper(C3P0PooledConnection.this, this, inner_is_cached, activeResultSets, mainResultSet, innerStmt);
                }

                public Connection getConnection() {
                    return parentConnection;
                }

                public ResultSet getResultSet() throws SQLException {
                    return this.wsh.wrap(super.getResultSet());
                }

                public ResultSet getGeneratedKeys() throws SQLException {
                    return this.wsh.wrap(super.getGeneratedKeys());
                }

                public ResultSet executeQuery(String sql) throws SQLException {
                    return this.wsh.wrap(super.executeQuery(sql));
                }

                public ResultSet executeQuery() throws SQLException {
                    return this.wsh.wrap(super.executeQuery());
                }

                public void close() throws SQLException {
                    this.wsh.doClose();
                }
            };
        }
        return new FilterStatement(innerStmt){
            1WrapperStatementHelper wsh;
            {
                this.wsh = new 1WrapperStatementHelper(C3P0PooledConnection.this, this, inner_is_cached, activeResultSets, mainResultSet, innerStmt);
            }

            public Connection getConnection() {
                return parentConnection;
            }

            public ResultSet getResultSet() throws SQLException {
                return this.wsh.wrap(super.getResultSet());
            }

            public ResultSet getGeneratedKeys() throws SQLException {
                return this.wsh.wrap(super.getGeneratedKeys());
            }

            public ResultSet executeQuery(String sql) throws SQLException {
                return this.wsh.wrap(super.executeQuery(sql));
            }

            public void close() throws SQLException {
                this.wsh.doClose();
            }
        };
    }

    public synchronized int getConnectionStatus() {
        return this.connection_status;
    }

    private synchronized void updateConnectionStatus(int status) {
        switch (this.connection_status) {
            case -8: {
                break;
            }
            case -1: {
                if (status != -8) break;
                this.doBadUpdate(status);
                break;
            }
            case 0: {
                if (status == 0) break;
                this.doBadUpdate(status);
                break;
            }
            default: {
                throw new InternalError(this + " -- Illegal Connection Status: " + this.connection_status);
            }
        }
    }

    private void doBadUpdate(int new_status) {
        this.connection_status = new_status;
        try {
            this.close(true);
        }
        catch (SQLException e) {
            System.err.print("Broken Connection Close Error: ");
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            CON_PROXY_CTOR = C3P0PooledConnection.createProxyConstructor(class$com$mchange$v2$c3p0$impl$C3P0PooledConnection$ProxyConnection == null ? (class$com$mchange$v2$c3p0$impl$C3P0PooledConnection$ProxyConnection = C3P0PooledConnection.class$("com.mchange.v2.c3p0.impl.C3P0PooledConnection$ProxyConnection")) : class$com$mchange$v2$c3p0$impl$C3P0PooledConnection$ProxyConnection);
            Class[] argClasses = new Class[]{};
            RS_CLOSE_METHOD = (class$java$sql$ResultSet == null ? (class$java$sql$ResultSet = C3P0PooledConnection.class$("java.sql.ResultSet")) : class$java$sql$ResultSet).getMethod("close", argClasses);
            STMT_CLOSE_METHOD = (class$java$sql$Statement == null ? (class$java$sql$Statement = C3P0PooledConnection.class$("java.sql.Statement")) : class$java$sql$Statement).getMethod("close", argClasses);
            CLOSE_ARGS = new Object[0];
            OBJECT_METHODS = Collections.unmodifiableSet(new HashSet<Method>(Arrays.asList((class$java$lang$Object == null ? (class$java$lang$Object = C3P0PooledConnection.class$("java.lang.Object")) : class$java$lang$Object).getMethods())));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InternalError("Something is very wrong, or this is a pre 1.3 JVM.We cannot set up dynamic proxies and/or methods!");
        }
    }

    static interface ProxyConnection
    extends Connection {
        public void silentClose(boolean var1) throws SQLException;
    }

    final class ProxyConnectionInvocationHandler
    implements InvocationHandler {
        Connection activeConnection;
        DatabaseMetaData metaData;
        boolean connection_error_signaled;
        final Set activeMetaDataResultSets;

        ProxyConnectionInvocationHandler() {
            this.activeConnection = C3P0PooledConnection.this.physicalConnection;
            this.metaData = null;
            this.connection_error_signaled = false;
            this.activeMetaDataResultSets = new HashSet();
        }

        public String toString() {
            return "C3P0ProxyConnection [Invocation Handler: " + super.toString() + ']';
        }

        public synchronized Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
            if (OBJECT_METHODS.contains(m)) {
                return m.invoke((Object)this, args);
            }
            try {
                String mname = m.getName();
                if (this.activeConnection != null) {
                    if (mname.equals("createStatement")) {
                        C3P0PooledConnection.this.ensureOkay();
                        Object stmt = m.invoke((Object)this.activeConnection, args);
                        return C3P0PooledConnection.this.createProxyStatement((Statement)stmt);
                    }
                    if (mname.equals("prepareStatement")) {
                        C3P0PooledConnection.this.ensureOkay();
                        if (C3P0PooledConnection.this.scache == null) {
                            Object pstmt = m.invoke((Object)this.activeConnection, args);
                            return C3P0PooledConnection.this.createProxyStatement((Statement)pstmt);
                        }
                        Object pstmt = C3P0PooledConnection.this.scache.checkoutStatement(C3P0PooledConnection.this.physicalConnection, m, args);
                        return C3P0PooledConnection.this.createProxyStatement(true, (Statement)pstmt);
                    }
                    if (mname.equals("prepareCall")) {
                        C3P0PooledConnection.this.ensureOkay();
                        if (C3P0PooledConnection.this.scache == null) {
                            Object cstmt = m.invoke((Object)this.activeConnection, args);
                            return C3P0PooledConnection.this.createProxyStatement((Statement)cstmt);
                        }
                        Object cstmt = C3P0PooledConnection.this.scache.checkoutStatement(C3P0PooledConnection.this.physicalConnection, m, args);
                        return C3P0PooledConnection.this.createProxyStatement(true, (Statement)cstmt);
                    }
                    if (mname.equals("getMetaData")) {
                        C3P0PooledConnection.this.ensureOkay();
                        DatabaseMetaData innerMd = this.activeConnection.getMetaData();
                        if (this.metaData == null) {
                            this.metaData = new SetManagedDatabaseMetaData(innerMd, this.activeMetaDataResultSets);
                        }
                        return this.metaData;
                    }
                    if (mname.equals("silentClose")) {
                        this.doSilentClose(proxy, (Boolean)args[0]);
                        return null;
                    }
                    if (mname.equals("close")) {
                        Exception e = this.doSilentClose(proxy, false);
                        if (!this.connection_error_signaled) {
                            C3P0PooledConnection.this.ces.fireConnectionClosed();
                        }
                        if (e != null) {
                            throw e;
                        }
                        return null;
                    }
                    C3P0PooledConnection.this.ensureOkay();
                    return m.invoke((Object)this.activeConnection, args);
                }
                if (mname.equals("close") || mname.equals("silentClose")) {
                    return null;
                }
                if (mname.equals("isClosed")) {
                    return new Boolean(true);
                }
                throw new SQLException("You can't operate on a closed connection!!!");
            }
            catch (InvocationTargetException e) {
                Throwable convertMe = e.getTargetException();
                SQLException sqle = this.handleMaybeFatalToPooledConnection(convertMe, proxy, false);
                sqle.fillInStackTrace();
                throw sqle;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Exception doSilentClose(Object proxyConnection, boolean pooled_connection_is_dead) {
            if (this.activeConnection != null) {
                C3P0PooledConnection c3P0PooledConnection = C3P0PooledConnection.this;
                synchronized (c3P0PooledConnection) {
                    if (C3P0PooledConnection.this.exposedProxy == proxyConnection) {
                        C3P0PooledConnection.this.exposedProxy = null;
                    }
                }
                Exception out = null;
                Exception exc1 = null;
                SQLException exc2 = null;
                SQLException exc3 = null;
                Exception exc4 = null;
                try {
                    if (!pooled_connection_is_dead) {
                        C3P0PooledConnection.this.reset();
                    }
                }
                catch (Exception e) {
                    exc1 = e;
                }
                exc2 = C3P0PooledConnection.this.cleanupUncachedActiveStatements();
                if (!C3P0PooledConnection.this.closeAndRemoveResultSets(this.activeMetaDataResultSets)) {
                    exc3 = new SQLException("Failed to close some DatabaseMetaData Result Sets.");
                }
                if (C3P0PooledConnection.this.scache != null) {
                    try {
                        C3P0PooledConnection.this.scache.checkinAll(C3P0PooledConnection.this.physicalConnection);
                    }
                    catch (Exception e) {
                        exc4 = e;
                    }
                }
                if (exc1 != null) {
                    this.handleMaybeFatalToPooledConnection(exc1, proxyConnection, true);
                    out = exc1;
                } else if (exc2 != null) {
                    this.handleMaybeFatalToPooledConnection(exc2, proxyConnection, true);
                    out = exc2;
                } else if (exc3 != null) {
                    this.handleMaybeFatalToPooledConnection(exc3, proxyConnection, true);
                    out = exc3;
                } else if (exc4 != null) {
                    this.handleMaybeFatalToPooledConnection(exc4, proxyConnection, true);
                    out = exc4;
                }
                this.activeConnection = null;
                return out;
            }
            return null;
        }

        private SQLException handleMaybeFatalToPooledConnection(Throwable t, Object proxyConnection, boolean already_closed) {
            SQLException sqle = SqlUtils.toSQLException(t);
            int status = C3P0PooledConnection.this.connectionTester.statusOnException(C3P0PooledConnection.this.physicalConnection, sqle);
            C3P0PooledConnection.this.updateConnectionStatus(status);
            if (status != 0) {
                System.err.print(C3P0PooledConnection.this + " invalidated by Exception: ");
                t.printStackTrace();
                C3P0PooledConnection.this.invalidatingException = sqle;
                if (!already_closed) {
                    this.doSilentClose(proxyConnection, true);
                }
                if (!this.connection_error_signaled) {
                    C3P0PooledConnection.this.ces.fireConnectionErrorOccurred(sqle);
                    this.connection_error_signaled = true;
                }
            }
            return sqle;
        }
    }

    private static class StatementProxyingSetManagedResultSet
    extends SetManagedResultSet {
        private Statement proxyStatement;

        StatementProxyingSetManagedResultSet(Set activeResultSets) {
            super(activeResultSets);
        }

        public void setProxyStatement(Statement proxyStatement) {
            this.proxyStatement = proxyStatement;
        }

        public Statement getStatement() throws SQLException {
            return this.proxyStatement == null ? super.getStatement() : this.proxyStatement;
        }
    }
}

