/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime;

import java.lang.reflect.Array;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import org.jibx.runtime.IListItemDeserializer;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

public abstract class Utility {
    public static final int MINIMUM_GROWN_ARRAY_SIZE = 16;
    private static final int MSPERMINUTE = 60000;
    private static final int MSPERHOUR = 3600000;
    private static final int MSPERDAY = 86400000;
    private static final long LMSPERDAY = 86400000L;
    private static final long MSPERYEAR = 31536000000L;
    private static final long MSPERAVGYEAR = 31557600000L;
    private static final long MSPERCENTURY = 3155695200000L;
    private static final long TIME_BASE = 62135596800000L;
    private static final int[] MONTHS_NONLEAP;
    private static final int[] MONTHS_LEAP;
    private static final long[] BIAS_MONTHMS;
    private static java.util.Date BEGINNING_OF_TIME;
    private static final char PAD_CHAR = '=';
    private static final char[] s_base64Chars;
    private static final byte[] s_base64Values;

    private static int parseDigits(String text, int offset, int length) throws JiBXException {
        int value = 0;
        if (length > 9) {
            try {
                value = Integer.parseInt(text.substring(offset, offset + length));
            }
            catch (NumberFormatException ex) {
                throw new JiBXException(ex.getMessage());
            }
        } else {
            int limit = offset + length;
            while (offset < limit) {
                char chr;
                if ((chr = text.charAt(offset++)) >= '0' && chr <= '9') {
                    value = value * 10 + (chr - 48);
                    continue;
                }
                throw new JiBXException("Non-digit in number value");
            }
        }
        return value;
    }

    public static int parseInt(String text) throws JiBXException {
        text = text.trim();
        int offset = 0;
        int limit = text.length();
        if (limit == 0) {
            throw new JiBXException("Empty number value");
        }
        boolean negate = false;
        char chr = text.charAt(0);
        if (chr == '-') {
            if (limit > 9) {
                try {
                    return Integer.parseInt(text);
                }
                catch (NumberFormatException ex) {
                    throw new JiBXException(ex.getMessage());
                }
            }
            negate = true;
            ++offset;
        } else if (chr == '+') {
            ++offset;
        }
        if (offset >= limit) {
            throw new JiBXException("Invalid number format");
        }
        int value = Utility.parseDigits(text, offset, limit - offset);
        if (negate) {
            return -value;
        }
        return value;
    }

    public static String serializeInt(int value) {
        return Integer.toString(value);
    }

    public static long parseLong(String text) throws JiBXException {
        text = text.trim();
        int offset = 0;
        int limit = text.length();
        if (limit == 0) {
            throw new JiBXException("Empty number value");
        }
        boolean negate = false;
        char chr = text.charAt(0);
        if (chr == '-') {
            negate = true;
            ++offset;
        } else if (chr == '+') {
            ++offset;
        }
        if (offset >= limit) {
            throw new JiBXException("Invalid number format");
        }
        long value = 0L;
        if (limit - offset > 18) {
            if (chr == '+') {
                text = text.substring(1);
            }
            try {
                value = Long.parseLong(text);
            }
            catch (NumberFormatException ex) {
                throw new JiBXException(ex.getMessage());
            }
        } else {
            while (offset < limit) {
                if ((chr = text.charAt(offset++)) >= '0' && chr <= '9') {
                    value = value * 10L + (long)(chr - 48);
                    continue;
                }
                throw new JiBXException("Non-digit in number value");
            }
            if (negate) {
                value = -value;
            }
        }
        return value;
    }

    public static String serializeLong(long value) {
        return Long.toString(value);
    }

    public static long parseYear(String text) throws JiBXException {
        text = text.trim();
        boolean valid = true;
        int minc = 4;
        char chr = text.charAt(0);
        if (chr == '-') {
            minc = 5;
        } else if (chr == '+') {
            valid = false;
        }
        if (text.length() < minc) {
            valid = false;
        }
        if (!valid) {
            throw new JiBXException("Invalid year format");
        }
        int year = Utility.parseInt(text);
        if (year == 0) {
            throw new JiBXException("Year value 0 is not allowed");
        }
        if (year > 0) {
            --year;
        }
        long day = (long)year * 365L + (long)(year / 4) - (long)(year / 100) + (long)(year / 400);
        return day * 86400000L - 62135596800000L;
    }

    public static short parseShort(String text) throws JiBXException {
        int value = Utility.parseInt(text);
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new JiBXException("Value out of range");
        }
        return (short)value;
    }

    public static String serializeShort(short value) {
        return Short.toString(value);
    }

    public static byte parseByte(String text) throws JiBXException {
        int value = Utility.parseInt(text);
        if (value < -128 || value > 127) {
            throw new JiBXException("Value out of range");
        }
        return (byte)value;
    }

    public static String serializeByte(byte value) {
        return Byte.toString(value);
    }

    public static boolean parseBoolean(String text) throws JiBXException {
        if ("true".equals(text = text.trim()) || "1".equals(text)) {
            return true;
        }
        if ("false".equals(text) || "0".equals(text)) {
            return false;
        }
        throw new JiBXException("Invalid boolean value");
    }

    public static String serializeBoolean(boolean value) {
        return value ? "true" : "false";
    }

    public static char parseChar(String text) throws JiBXException {
        int value = Utility.parseInt(text);
        if (value < 0 || value > 65535) {
            throw new JiBXException("Value out of range");
        }
        return (char)value;
    }

    public static String serializeChar(char value) {
        return Integer.toString(value);
    }

    public static char parseCharString(String text) throws JiBXException {
        if (text.length() == 1) {
            return text.charAt(0);
        }
        throw new JiBXException("Input must be a single character");
    }

    public static char deserializeCharString(String text) throws JiBXException {
        if (text == null) {
            return '\u0000';
        }
        return Utility.parseCharString(text);
    }

    public static String serializeCharString(char value) {
        return String.valueOf(value);
    }

    public static float parseFloat(String text) throws JiBXException {
        if ("-INF".equals(text = text.trim())) {
            return Float.NEGATIVE_INFINITY;
        }
        if ("INF".equals(text)) {
            return Float.POSITIVE_INFINITY;
        }
        try {
            return Float.parseFloat(text);
        }
        catch (NumberFormatException ex) {
            throw new JiBXException(ex.getMessage());
        }
    }

    public static String serializeFloat(float value) {
        if (Float.isInfinite(value)) {
            return value < 0.0f ? "-INF" : "INF";
        }
        return Float.toString(value);
    }

    public static double parseDouble(String text) throws JiBXException {
        if ("-INF".equals(text = text.trim())) {
            return Double.NEGATIVE_INFINITY;
        }
        if ("INF".equals(text)) {
            return Double.POSITIVE_INFINITY;
        }
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException ex) {
            throw new JiBXException(ex.getMessage());
        }
    }

    public static String serializeDouble(double value) {
        if (Double.isInfinite(value)) {
            return value < 0.0 ? "-INF" : "INF";
        }
        return Double.toString(value);
    }

    public static long parseYearMonth(String text) throws JiBXException {
        boolean leap;
        text = text.trim();
        boolean valid = true;
        int minc = 7;
        char chr = text.charAt(0);
        if (chr == '-') {
            minc = 8;
        } else if (chr == '+') {
            valid = false;
        }
        int split = text.length() - 3;
        if (text.length() < minc) {
            valid = false;
        } else if (text.charAt(split) != '-') {
            valid = false;
        }
        if (!valid) {
            throw new JiBXException("Invalid date format");
        }
        int year = Utility.parseInt(text.substring(0, split));
        if (year == 0) {
            throw new JiBXException("Year value 0 is not allowed");
        }
        int month = Utility.parseDigits(text, split + 1, 2) - 1;
        if (month < 0 || month > 11) {
            throw new JiBXException("Month value out of range");
        }
        boolean bl = leap = year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
        if (year > 0) {
            --year;
        }
        long day = (long)year * 365L + (long)(year / 4) - (long)(year / 100) + (long)(year / 400) + (long)(leap ? MONTHS_LEAP : MONTHS_NONLEAP)[month];
        return day * 86400000L - 62135596800000L;
    }

    public static long parseDate(String text) throws JiBXException {
        int[] starts;
        int split = Utility.validateDate(text);
        int year = Utility.parseInt(text.substring(0, split));
        if (year == 0) {
            throw new JiBXException("Year value 0 is not allowed");
        }
        int month = Utility.parseDigits(text, split + 1, 2) - 1;
        if (month < 0 || month > 11) {
            throw new JiBXException("Month value out of range");
        }
        long day = Utility.parseDigits(text, split + 4, 2) - 1;
        boolean leap = year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
        int[] nArray = starts = leap ? MONTHS_LEAP : MONTHS_NONLEAP;
        if (day < 0L || day >= (long)(starts[month + 1] - starts[month])) {
            throw new JiBXException("Day value out of range");
        }
        if (year > 0) {
            --year;
        }
        return (day += (long)year * 365L + (long)(year / 4) - (long)(year / 100) + (long)(year / 400) + (long)starts[month]) * 86400000L - 62135596800000L;
    }

    public static java.util.Date deserializeDate(String text) throws JiBXException {
        if (text == null) {
            return null;
        }
        return new java.util.Date(Utility.parseDate(text));
    }

    private static int validateDate(String text) throws JiBXException {
        boolean valid = true;
        int minc = 10;
        char chr = text.charAt(0);
        if (chr == '-') {
            minc = 11;
        } else if (chr == '+') {
            valid = false;
        }
        int split = text.length() - 6;
        if (text.length() < minc) {
            valid = false;
        } else if (text.charAt(split) != '-' || text.charAt(split + 3) != '-') {
            valid = false;
        }
        if (!valid) {
            throw new JiBXException("Invalid date format");
        }
        return split;
    }

    public static Date deserializeSqlDate(String text) throws JiBXException {
        GregorianCalendar cal;
        int[] starts;
        if (text == null) {
            return null;
        }
        int split = Utility.validateDate(text);
        int year = Utility.parseInt(text.substring(0, split));
        if (year == 0) {
            throw new JiBXException("Year value 0 is not allowed");
        }
        int month = Utility.parseDigits(text, split + 1, 2) - 1;
        if (month < 0 || month > 11) {
            throw new JiBXException("Month value out of range");
        }
        int day = Utility.parseDigits(text, split + 4, 2) - 1;
        boolean leap = year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
        int[] nArray = starts = leap ? MONTHS_LEAP : MONTHS_NONLEAP;
        if (day < 0 || day >= starts[month + 1] - starts[month]) {
            throw new JiBXException("Day value out of range");
        }
        if (year < 0) {
            ++year;
        }
        if (year < 1800) {
            cal = new GregorianCalendar();
            cal.setGregorianChange(BEGINNING_OF_TIME);
            cal.clear();
            cal.set(year, month, day + 1);
        } else {
            cal = new GregorianCalendar(year, month, day + 1);
        }
        return new Date(cal.getTime().getTime());
    }

    public static long parseTime(String text, int start, int length) throws JiBXException {
        boolean valid;
        long milli = 0L;
        boolean bl = valid = length > start + 7 && text.charAt(start + 2) == ':' && text.charAt(start + 5) == ':';
        if (valid) {
            int hour = Utility.parseDigits(text, start, 2);
            int minute = Utility.parseDigits(text, start + 3, 2);
            int second = Utility.parseDigits(text, start + 6, 2);
            if (hour > 23 || minute > 59 || second > 60) {
                valid = false;
            } else {
                milli = ((hour * 60 + minute) * 60 + second) * 1000;
                if (length > (start += 8)) {
                    if (text.charAt(length - 1) == 'Z') {
                        --length;
                    } else {
                        char chr = text.charAt(length - 6);
                        if (chr == '-' || chr == '+') {
                            hour = Utility.parseDigits(text, length - 5, 2);
                            minute = Utility.parseDigits(text, length - 2, 2);
                            if (hour > 23 || minute > 59) {
                                valid = false;
                            } else {
                                int offset = (hour * 60 + minute) * 60 * 1000;
                                milli = chr == '-' ? (milli += (long)offset) : (milli -= (long)offset);
                            }
                            length -= 6;
                        }
                    }
                    if (text.charAt(start) == '.') {
                        double fraction = Double.parseDouble(text.substring(start, length));
                        milli = (long)((double)milli + fraction * 1000.0);
                    } else if (length > start) {
                        valid = false;
                    }
                }
            }
        }
        if (valid) {
            return milli;
        }
        throw new JiBXException("Invalid dateTime format");
    }

    public static long parseDateTime(String text) throws JiBXException {
        int split = text.indexOf(84);
        if (split < 0) {
            throw new JiBXException("Missing 'T' separator in dateTime");
        }
        return Utility.parseDate(text.substring(0, split)) + Utility.parseTime(text, split + 1, text.length());
    }

    public static java.util.Date deserializeDateTime(String text) throws JiBXException {
        if (text == null) {
            return null;
        }
        return new java.util.Date(Utility.parseDateTime(text));
    }

    public static Timestamp deserializeTimestamp(String text) throws JiBXException {
        if (text == null) {
            return null;
        }
        int split = text.indexOf(46);
        int nano = 0;
        if (split > 0) {
            char chr;
            if (text.indexOf(46, split + 1) > 0) {
                throw new JiBXException("Not a valid timestamp value");
            }
            int limit = text.length();
            int scan = split;
            while (++scan < limit && (chr = text.charAt(scan)) >= '0' && chr <= '9') {
            }
            int length = scan - split - 1;
            if (length > 9) {
                length = 9;
            }
            nano = Utility.parseDigits(text, split + 1, length);
            while (length < 9) {
                nano *= 10;
                ++length;
            }
            text = scan < limit ? text.substring(0, split) + text.substring(scan) : text.substring(0, split);
        }
        Timestamp stamp = new Timestamp(Utility.parseDateTime(text));
        stamp.setNanos(nano);
        return stamp;
    }

    public static Time deserializeSqlTime(String text) throws JiBXException {
        if (text == null) {
            return null;
        }
        return new Time(Utility.parseTime(text, 0, text.length()));
    }

    protected static void formatYearNumber(long year, StringBuffer buff) {
        if (year <= 0L) {
            buff.append('-');
            year = -(year - 1L);
        }
        if (year < 1000L) {
            buff.append('0');
            if (year < 100L) {
                buff.append('0');
                if (year < 10L) {
                    buff.append('0');
                }
            }
        }
        buff.append(year);
    }

    protected static void formatTwoDigits(int value, StringBuffer buff) {
        if (value < 10) {
            buff.append('0');
        }
        buff.append(value);
    }

    protected static void formatYear(long value, StringBuffer buff) {
        long yms;
        int yday;
        int month;
        long time = value + 26438400000L + 64800000L;
        long century = time / 3155695200000L;
        long adjusted = time + (century - century / 4L) * 86400000L;
        int year = (int)(adjusted / 31557600000L);
        if (adjusted < 0L) {
            --year;
        }
        if ((month = (5 * (yday = (int)((yms = adjusted + 21600000L - (long)(year * 365 + year / 4) * 86400000L) / 86400000L)) + 456) / 153) > 12) {
            ++year;
        }
        Utility.formatYearNumber(year, buff);
    }

    protected static long formatYearMonth(long value, StringBuffer buff) {
        long yms;
        int yday;
        long time = value + 26438400000L + 64800000L;
        long century = time / 3155695200000L;
        long adjusted = time + (century - century / 4L) * 86400000L;
        int year = (int)(adjusted / 31557600000L);
        if (adjusted < 0L) {
            --year;
        }
        if ((yday = (int)((yms = adjusted + 21600000L - (long)(year * 365 + year / 4) * 86400000L) / 86400000L)) == 0) {
            int dcnt;
            boolean bce;
            boolean bl = bce = year < 0;
            if (bce) {
                --year;
            }
            int n = dcnt = year % 4 == 0 ? 366 : 365;
            if (!bce) {
                --year;
            }
            yms += (long)dcnt * 86400000L;
            yday += dcnt;
        }
        int month = (5 * yday + 456) / 153;
        long rem = yms - BIAS_MONTHMS[month] - 86400000L;
        if (month > 12) {
            ++year;
            month -= 12;
        }
        Utility.formatYearNumber(year, buff);
        buff.append('-');
        Utility.formatTwoDigits(month, buff);
        return rem;
    }

    protected static int formatYearMonthDay(long value, StringBuffer buff) {
        long extra = Utility.formatYearMonth(value, buff);
        int day = (int)(extra / 86400000L) + 1;
        buff.append('-');
        Utility.formatTwoDigits(day, buff);
        return (int)(extra % 86400000L);
    }

    public static String serializeYear(long time) {
        StringBuffer buff = new StringBuffer(6);
        Utility.formatYear(time + 62135596800000L, buff);
        return buff.toString();
    }

    public static String serializeYear(java.util.Date date) {
        return Utility.serializeYear(date.getTime());
    }

    public static String serializeYearMonth(long time) {
        StringBuffer buff = new StringBuffer(12);
        Utility.formatYearMonth(time + 62135596800000L, buff);
        return buff.toString();
    }

    public static String serializeYearMonth(java.util.Date date) {
        return Utility.serializeYearMonth(date.getTime());
    }

    public static String serializeDate(long time) {
        StringBuffer buff = new StringBuffer(12);
        Utility.formatYearMonthDay(time + 62135596800000L, buff);
        return buff.toString();
    }

    public static String serializeDate(java.util.Date date) {
        return Utility.serializeDate(date.getTime());
    }

    public static String serializeSqlDate(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setGregorianChange(BEGINNING_OF_TIME);
        cal.setTime(date);
        StringBuffer buff = new StringBuffer(12);
        int year = cal.get(1);
        if (date.getTime() < 0L && cal.get(0) == 0) {
            year = -year + 1;
        }
        Utility.formatYearNumber(year, buff);
        buff.append('-');
        Utility.formatTwoDigits(cal.get(2) + 1, buff);
        buff.append('-');
        Utility.formatTwoDigits(cal.get(5), buff);
        return buff.toString();
    }

    public static void serializeTime(int time, StringBuffer buff) {
        Utility.formatTwoDigits(time / 3600000, buff);
        buff.append(':');
        Utility.formatTwoDigits((time %= 3600000) / 60000, buff);
        buff.append(':');
        Utility.formatTwoDigits((time %= 60000) / 1000, buff);
        if ((time %= 1000) > 0) {
            buff.append('.');
            buff.append(time / 100);
            if ((time %= 100) > 0) {
                buff.append(time / 10);
                if ((time %= 10) > 0) {
                    buff.append(time);
                }
            }
        }
    }

    public static String serializeDateTime(long time, boolean zone) {
        StringBuffer buff = new StringBuffer(25);
        int extra = Utility.formatYearMonthDay(time + 62135596800000L, buff);
        buff.append('T');
        Utility.serializeTime(extra, buff);
        if (zone) {
            buff.append('Z');
        }
        return buff.toString();
    }

    public static String serializeDateTime(long time) {
        return Utility.serializeDateTime(time, false);
    }

    public static String serializeDateTime(java.util.Date date) {
        return Utility.serializeDateTime(date.getTime(), true);
    }

    public static String serializeTimestamp(Timestamp stamp) {
        int nano = stamp.getNanos();
        if (nano > 0) {
            String value = Utility.serializeInt(nano);
            StringBuffer digits = new StringBuffer(9);
            if (value.length() < 9) {
                int lead = 9 - value.length();
                for (int i = 0; i < lead; ++i) {
                    digits.append('0');
                }
            }
            digits.append(value);
            int last = 9;
            while (--last >= 0 && digits.charAt(last) == '0') {
            }
            digits.setLength(last + 1);
            long time = stamp.getTime();
            return Utility.serializeDateTime(time - time % 1000L, false) + '.' + digits + 'Z';
        }
        return Utility.serializeDateTime(stamp.getTime(), true);
    }

    public static String serializeSqlTime(Time time) {
        StringBuffer buff = new StringBuffer(12);
        Utility.serializeTime((int)time.getTime(), buff);
        return buff.toString();
    }

    public static boolean isEqual(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public static int enumValue(String target, String[] enums, int[] vals) throws JiBXException {
        int base = 0;
        int limit = enums.length - 1;
        while (base <= limit) {
            int cur = base + limit >> 1;
            int diff = target.compareTo(enums[cur]);
            if (diff < 0) {
                limit = cur - 1;
                continue;
            }
            if (diff > 0) {
                base = cur + 1;
                continue;
            }
            if (vals != null) {
                return vals[cur];
            }
            return cur;
        }
        throw new JiBXException("Target value \"" + target + "\" not found in enumeration");
    }

    private static int decodeChunk(int base, char[] chrs, int fill, byte[] byts) {
        int length = 3;
        if (chrs[base + 3] == '=') {
            length = 2;
            if (chrs[base + 2] == '=') {
                length = 1;
            }
        }
        byte v0 = s_base64Values[chrs[base + 0]];
        byte v1 = s_base64Values[chrs[base + 1]];
        byte v2 = s_base64Values[chrs[base + 2]];
        byte v3 = s_base64Values[chrs[base + 3]];
        switch (length) {
            case 3: {
                byts[fill + 2] = (byte)(v2 << 6 | v3);
            }
            case 2: {
                byts[fill + 1] = (byte)(v1 << 4 | v2 >> 2);
            }
            case 1: {
                byts[fill] = (byte)(v0 << 2 | v1 >> 4);
            }
        }
        return length;
    }

    public static byte[] parseBase64(String text) throws JiBXException {
        char[] chrs = new char[text.length()];
        int length = 0;
        for (int i = 0; i < text.length(); ++i) {
            char chr = text.charAt(i);
            if (chr >= '\u0080' || s_base64Values[chr] < 0) continue;
            chrs[length++] = chr;
        }
        if (length % 4 != 0) {
            throw new JiBXException("Text length for base64 must be a multiple of 4");
        }
        if (length == 0) {
            return new byte[0];
        }
        int blength = length / 4 * 3;
        if (chrs[length - 1] == '=') {
            --blength;
            if (chrs[length - 2] == '=') {
                --blength;
            }
        }
        byte[] byts = new byte[blength];
        int fill = 0;
        for (int i = 0; i < length; i += 4) {
            fill += Utility.decodeChunk(i, chrs, fill, byts);
        }
        if (fill != blength) {
            throw new JiBXException("Embedded padding characters in byte64 text");
        }
        return byts;
    }

    public static byte[] deserializeBase64(String text) throws JiBXException {
        if (text == null) {
            return null;
        }
        return Utility.parseBase64(text);
    }

    public static void encodeChunk(int base, byte[] byts, StringBuffer buff) {
        int length = 3;
        if (base + length > byts.length) {
            length = byts.length - base;
        }
        byte b0 = byts[base];
        int value = b0 >> 2 & 0x3F;
        buff.append(s_base64Chars[value]);
        if (length > 1) {
            byte b1 = byts[base + 1];
            value = ((b0 & 3) << 4) + (b1 >> 4 & 0xF);
            buff.append(s_base64Chars[value]);
            if (length > 2) {
                byte b2 = byts[base + 2];
                value = ((b1 & 0xF) << 2) + (b2 >> 6 & 3);
                buff.append(s_base64Chars[value]);
                value = b2 & 0x3F;
                buff.append(s_base64Chars[value]);
            } else {
                value = (b1 & 0xF) << 2;
                buff.append(s_base64Chars[value]);
                buff.append('=');
            }
        } else {
            value = (b0 & 3) << 4;
            buff.append(s_base64Chars[value]);
            buff.append('=');
            buff.append('=');
        }
    }

    public static String serializeBase64(byte[] byts) {
        StringBuffer buff = new StringBuffer((byts.length + 2) / 3 * 4);
        for (int i = 0; i < byts.length; i += 3) {
            Utility.encodeChunk(i, byts, buff);
            if (i <= 0 || i % 57 != 0 || i + 3 >= byts.length) continue;
            buff.append("\r\n");
        }
        return buff.toString();
    }

    public static Object resizeArray(int size, Object base) {
        int prior = Array.getLength(base);
        if (size == prior) {
            return base;
        }
        Class<?> type = base.getClass().getComponentType();
        Object copy = Array.newInstance(type, size);
        int count = Math.min(size, prior);
        System.arraycopy(base, 0, copy, 0, count);
        return copy;
    }

    public static Object growArray(Object base) {
        int length = Array.getLength(base);
        Class<?> type = base.getClass().getComponentType();
        int newlen = Math.max(length * 2, 16);
        Object copy = Array.newInstance(type, newlen);
        System.arraycopy(base, 0, copy, 0, length);
        return copy;
    }

    public static List arrayListFactory() {
        return new ArrayList();
    }

    public static ArrayList deserializeList(String text, IListItemDeserializer ideser) throws JiBXException {
        if (text == null) {
            return null;
        }
        ArrayList<Object> items = new ArrayList<Object>();
        int length = text.length();
        int base = 0;
        boolean space = true;
        block3: for (int i = 0; i < length; ++i) {
            char chr = text.charAt(i);
            switch (chr) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (!space) {
                        String itext = text.substring(base, i);
                        items.add(ideser.deserialize(itext));
                        space = true;
                    }
                    base = i + 1;
                    continue block3;
                }
                default: {
                    space = false;
                }
            }
        }
        if (base < length) {
            String itext = text.substring(base);
            items.add(ideser.deserialize(itext));
        }
        if (items.size() > 0) {
            return items;
        }
        return null;
    }

    public static String[] deserializeTokenList(String text, IUnmarshallingContext ictx) throws JiBXException {
        IListItemDeserializer ldser = new IListItemDeserializer(){

            public Object deserialize(String text) throws JiBXException {
                return text;
            }
        };
        ArrayList list = Utility.deserializeList(text, ldser);
        if (list == null) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public static String serializeTokenList(String[] tokens, IMarshallingContext ictx) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < tokens.length; ++i) {
            if (buff.length() > 0) {
                buff.append(' ');
            }
            buff.append(tokens[i]);
        }
        return buff.toString();
    }

    static {
        int i;
        MONTHS_NONLEAP = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
        MONTHS_LEAP = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366};
        BIAS_MONTHMS = new long[]{0L, 0L, 0L, 0L, 2678400000L, 5270400000L, 7948800000L, 10540800000L, 13219200000L, 15897600000L, 18489600000L, 21168000000L, 23760000000L, 26438400000L, 29116800000L};
        BEGINNING_OF_TIME = new java.util.Date(Long.MIN_VALUE);
        s_base64Chars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        s_base64Values = new byte[128];
        for (i = 0; i < s_base64Values.length; ++i) {
            Utility.s_base64Values[i] = -1;
        }
        Utility.s_base64Values[61] = 0;
        for (i = 0; i < s_base64Chars.length; ++i) {
            Utility.s_base64Values[Utility.s_base64Chars[i]] = (byte)i;
        }
    }
}

