/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application.jcr;

import org.apache.commons.logging.Log;
import org.exoplatform.portal.application.PortletPreferences;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.services.log.LogService;
import org.exoplatform.services.portletcontainer.pci.ExoWindowID;
import org.exoplatform.services.portletcontainer.pci.WindowID;
import org.exoplatform.services.portletcontainer.pci.model.ExoPortletPreferences;
import org.exoplatform.services.portletcontainer.persistence.PortletPreferencesPersister;

public class PortletPreferencesPersisterImpl
implements PortletPreferencesPersister {
    private transient Log log_;
    private DataStorage dataStorage_;

    public PortletPreferencesPersisterImpl(DataStorage dataStorage, LogService lservice) {
        this.log_ = lservice.getLog(this.getClass());
        this.dataStorage_ = dataStorage;
    }

    public ExoPortletPreferences getPortletPreferences(WindowID windowID) throws Exception {
        PortletPreferences portletPreferences = this.dataStorage_.getPortletPreferences(windowID);
        return portletPreferences == null ? null : portletPreferences.toExoPortletPreferences();
    }

    public void savePortletPreferences(WindowID windowID, ExoPortletPreferences exoPref) throws Exception {
        PortletPreferences portletPreferences = new PortletPreferences(exoPref);
        ExoWindowID exoWindowID = (ExoWindowID)windowID;
        portletPreferences.setWindowId(exoWindowID.getPersistenceId());
        String owner = windowID.getOwner();
        String[] components = owner.split("#");
        if (components.length < 2) {
            throw new Exception("WindowId is invalid " + windowID);
        }
        portletPreferences.setOwnerType(components[0]);
        portletPreferences.setOwnerId(components[1]);
        this.dataStorage_.save(portletPreferences);
    }
}

