/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.auth;

import java.security.Principal;
import java.util.Collection;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.auth.ExoLoginJAASLoginModule;
import org.exoplatform.services.organization.auth.RolePrincipal;

public class TomcatLoginModule
extends ExoLoginJAASLoginModule {
    protected void populateRolePrincipals(OrganizationService service, String username, Subject subject) throws Exception {
        Set<Principal> principals = subject.getPrincipals();
        Collection groups = service.getGroupHandler().findGroupsOfUser(username);
        for (Group group : groups) {
            String groupId = group.getId();
            String[] splittedGroupName = StringUtils.split((String)groupId, (String)"/");
            principals.add(new RolePrincipal(splittedGroupName[0]));
        }
    }
}

