/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.dataflow.ChangesLogIterator;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.ext.backup.BackupChain;
import org.exoplatform.services.jcr.ext.backup.BackupChainLog;
import org.exoplatform.services.jcr.ext.backup.BackupConfig;
import org.exoplatform.services.jcr.ext.backup.BackupConfigurationException;
import org.exoplatform.services.jcr.ext.backup.BackupJob;
import org.exoplatform.services.jcr.ext.backup.BackupJobListener;
import org.exoplatform.services.jcr.ext.backup.BackupManager;
import org.exoplatform.services.jcr.ext.backup.BackupOperationException;
import org.exoplatform.services.jcr.ext.backup.JobEntryInfo;
import org.exoplatform.services.jcr.ext.backup.impl.BackupChainImpl;
import org.exoplatform.services.jcr.ext.backup.impl.BackupMessage;
import org.exoplatform.services.jcr.ext.backup.impl.BackupMessagesLog;
import org.exoplatform.services.jcr.ext.backup.impl.BackupScheduler;
import org.exoplatform.services.jcr.ext.backup.impl.BackupSchedulerException;
import org.exoplatform.services.jcr.ext.replication.FixupStream;
import org.exoplatform.services.jcr.ext.replication.PendingChangesLog;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.jcr.impl.storage.JCRInvalidItemStateException;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.log.ExoLogger;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackupManagerImpl
implements BackupManager,
Startable {
    protected static Log log = ExoLogger.getLogger((String)"ext.BackupManagerImpl");
    private final HashSet<BackupChain> currentBackups;
    private final File logsDirectory;
    private final RepositoryService repoService;
    private FileCleaner fileCleaner;
    private BackupScheduler scheduler;
    private static final int MESSAGES_MAXSIZE = 5;
    private final BackupMessagesLog messages;
    private final MessagesListener messagesListener = new MessagesListener();

    public BackupManagerImpl(RepositoryService repoService, InitParams params) throws RepositoryConfigurationException {
        this.repoService = repoService;
        PropertiesParam pps = params.getPropertiesParam("backup-properties");
        String pathBackupDir = pps.getProperty("backup-dir");
        if (pathBackupDir == null) {
            throw new RepositoryConfigurationException("backup-dir not specified");
        }
        this.logsDirectory = new File(pathBackupDir);
        if (!this.logsDirectory.exists()) {
            this.logsDirectory.mkdirs();
        }
        this.currentBackups = new HashSet();
        this.fileCleaner = new FileCleaner(10000L);
        this.messages = new BackupMessagesLog(5);
        this.scheduler = new BackupScheduler(this, this.messages);
    }

    @Override
    public Set<BackupChain> getCurrentBackups() {
        return this.currentBackups;
    }

    @Override
    public BackupMessage[] getMessages() {
        return this.messages.getMessages();
    }

    @Override
    public BackupChainLog[] getBackupsLogs() {
        File[] cfs = this.logsDirectory.listFiles(new LogsFilter());
        ArrayList<BackupChainLog> logs = new ArrayList<BackupChainLog>();
        for (int i = 0; i < cfs.length; ++i) {
            File cf = cfs[i];
            try {
                logs.add(new BackupChainLog(cf));
                continue;
            }
            catch (BackupOperationException e) {
                log.warn((Object)("Log file " + cf.getAbsolutePath() + " is bussy or corrupted. Skipped. " + e), (Throwable)e);
            }
        }
        BackupChainLog[] ls = new BackupChainLog[logs.size()];
        logs.toArray(ls);
        return ls;
    }

    @Override
    public void restore(BackupChainLog log, RepositoryEntry repository, WorkspaceEntry workspaceEntry) throws BackupOperationException, RepositoryException, RepositoryConfigurationException, BackupConfigurationException {
        String workspaseName;
        List<JobEntryInfo> list = log.getJobEntryInfos();
        BackupConfig config = log.getBackupConfig();
        String reposytoryName = repository == null ? config.getRepository() : repository.getName();
        if (!this.workspaceAlreadyExist(reposytoryName, workspaseName = workspaceEntry.getName())) {
            for (int i = 0; i < list.size(); ++i) {
                if (i == 0) {
                    try {
                        this.fullRestore(list.get(i).getURL().getPath(), reposytoryName, workspaseName, workspaceEntry);
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        throw new BackupOperationException("Restore of full backup file error " + e, e);
                    }
                    catch (IOException e) {
                        throw new BackupOperationException("Restore of full backup file I/O error " + e, e);
                    }
                }
                try {
                    this.incrementalRestore(list.get(i).getURL().getPath(), reposytoryName, workspaseName);
                    continue;
                }
                catch (FileNotFoundException e) {
                    throw new BackupOperationException("Restore of incremental backup file error " + e, e);
                }
                catch (IOException e) {
                    throw new BackupOperationException("Restore of incremental backup file I/O error " + e, e);
                }
                catch (ClassNotFoundException e) {
                    throw new BackupOperationException("Restore of incremental backup error " + e, e);
                }
            }
        } else {
            throw new BackupConfigurationException("Workspace should exists " + workspaseName);
        }
    }

    private boolean workspaceAlreadyExist(String repository, String workspace) throws RepositoryException, RepositoryConfigurationException {
        String[] ws = this.repoService.getRepository(repository).getWorkspaceNames();
        for (int i = 0; i < ws.length; ++i) {
            if (!ws[i].equals(workspace)) continue;
            return true;
        }
        return false;
    }

    @Override
    public BackupChain startBackup(BackupConfig config) throws BackupOperationException, BackupConfigurationException, RepositoryException, RepositoryConfigurationException {
        return this.startBackup(config, null);
    }

    BackupChain startBackup(BackupConfig config, BackupJobListener jobListener) throws BackupOperationException, BackupConfigurationException, RepositoryException, RepositoryConfigurationException {
        BackupChainImpl bchain = new BackupChainImpl(config, this.logsDirectory, this.repoService.getRepository(config.getRepository()));
        bchain.addListener(this.messagesListener);
        bchain.addListener(jobListener);
        this.currentBackups.add(bchain);
        bchain.startBackup();
        return bchain;
    }

    @Override
    public void stopBackup(BackupChain backup) {
        backup.stopBackup();
        this.currentBackups.remove(backup);
    }

    @Override
    public void start() {
        File[] tasks;
        for (File task : tasks = this.logsDirectory.listFiles(new TaskFilter())) {
            try {
                this.scheduler.restore(task);
            }
            catch (BackupSchedulerException e) {
                log.error((Object)("Can't restore backup scheduler task from file " + task.getAbsolutePath()), (Throwable)e);
            }
            catch (BackupOperationException e) {
                log.error((Object)("Can't restore backup scheduler task from file " + task.getAbsolutePath()), (Throwable)e);
            }
            catch (BackupConfigurationException e) {
                log.error((Object)("Can't restore backup scheduler task from file " + task.getAbsolutePath()), (Throwable)e);
            }
            catch (RepositoryException e) {
                log.error((Object)("Can't restore backup scheduler task from file " + task.getAbsolutePath()), (Throwable)e);
            }
            catch (RepositoryConfigurationException e) {
                log.error((Object)("Can't restore backup scheduler task from file " + task.getAbsolutePath()), (Throwable)e);
            }
        }
    }

    @Override
    public void stop() {
    }

    private void fullRestore(String pathBackupFile, String repositoryName, String workspaceName, WorkspaceEntry workspaceEntry) throws FileNotFoundException, IOException, RepositoryException, RepositoryConfigurationException {
        RepositoryImpl defRep = (RepositoryImpl)this.repoService.getRepository(repositoryName);
        defRep.importWorkspace(workspaceEntry.getName(), (InputStream)new FileInputStream(pathBackupFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementalRestore(String pathBackupFile, String repositoryName, String workspaceName) throws RepositoryException, RepositoryConfigurationException, BackupOperationException, FileNotFoundException, IOException, ClassNotFoundException {
        SessionImpl sesion = (SessionImpl)this.repoService.getRepository(repositoryName).getSystemSession(workspaceName);
        WorkspacePersistentDataManager dataManager = (WorkspacePersistentDataManager)sesion.getContainer().getComponentInstanceOfType(WorkspacePersistentDataManager.class);
        ObjectInputStream ois = null;
        File backupFile = null;
        try {
            try {
                backupFile = new File(pathBackupFile);
                ois = new ObjectInputStream(new FileInputStream(backupFile));
                while (true) {
                    TransactionChangesLog changesLog = this.readExternal(ois);
                    ChangesLogIterator cli = changesLog.getLogIterator();
                    while (cli.hasNextLog()) {
                        if (cli.nextLog().getEventType() != 0x400000) continue;
                        cli.removeLog();
                    }
                    this.saveChangesLog(dataManager, changesLog);
                }
            }
            catch (EOFException ioe) {
                if (sesion != null) {
                    sesion.logout();
                }
            }
        }
        catch (Throwable throwable) {
            if (sesion != null) {
                sesion.logout();
            }
            throw throwable;
        }
    }

    private void saveChangesLog(WorkspacePersistentDataManager dataManager, TransactionChangesLog changesLog) throws RepositoryException, BackupOperationException {
        try {
            dataManager.save((ItemStateChangesLog)changesLog);
        }
        catch (JCRInvalidItemStateException e) {
            TransactionChangesLog normalizeChangesLog = this.getNormalizedChangesLog(e.getIdentifier(), e.getState(), changesLog);
            if (normalizeChangesLog != null) {
                this.saveChangesLog(dataManager, normalizeChangesLog);
            }
            throw new BackupOperationException("Collisions found during save of restore changes log, but caused item is not found by ID " + e.getIdentifier() + ". " + (Object)((Object)e), e);
        }
    }

    private TransactionChangesLog getNormalizedChangesLog(String collisionID, int state, TransactionChangesLog changesLog) {
        ItemState citem = changesLog.getItemState(collisionID);
        if (citem != null) {
            TransactionChangesLog result = new TransactionChangesLog();
            result.setSystemId(changesLog.getSystemId());
            ChangesLogIterator cli = changesLog.getLogIterator();
            while (cli.hasNextLog()) {
                ArrayList<ItemState> normalized = new ArrayList<ItemState>();
                PlainChangesLog next = cli.nextLog();
                for (ItemState change : next.getAllStates()) {
                    if (state == change.getState()) {
                        ItemData item = change.getData();
                        if (citem.isNode()) {
                            if (item.getIdentifier().equals(collisionID) || item.getQPath().isDescendantOf(citem.getData().getQPath(), false)) continue;
                            normalized.add(change);
                            continue;
                        }
                        if (item.getIdentifier().equals(collisionID)) continue;
                        normalized.add(change);
                        continue;
                    }
                    normalized.add(change);
                }
                PlainChangesLogImpl plog = new PlainChangesLogImpl(normalized, next.getSessionId(), next.getEventType());
                result.addLog((PlainChangesLog)plog);
            }
            return result;
        }
        return null;
    }

    private TransactionChangesLog readExternal(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int changesLogType = in.readInt();
        TransactionChangesLog transactionChangesLog = null;
        if (changesLogType == 2) {
            transactionChangesLog = (TransactionChangesLog)in.readObject();
            int iFixupStream = in.readInt();
            ArrayList<FixupStream> listFixupStreams = new ArrayList<FixupStream>();
            for (int i = 0; i < iFixupStream; ++i) {
                listFixupStreams.add((FixupStream)in.readObject());
            }
            int iStreamCount = in.readInt();
            ArrayList<File> listFiles = new ArrayList<File>();
            for (int i = 0; i < iStreamCount; ++i) {
                long fileSize = in.readLong();
                File contentFile = this.getAsFile(in, fileSize);
                listFiles.add(contentFile);
            }
            PendingChangesLog pendingChangesLog = new PendingChangesLog(transactionChangesLog, listFixupStreams, listFiles, this.fileCleaner);
            pendingChangesLog.restore();
            TransactionChangesLog log = pendingChangesLog.getItemDataChangesLog();
        } else if (changesLogType == 1) {
            transactionChangesLog = (TransactionChangesLog)in.readObject();
        }
        return transactionChangesLog;
    }

    private File getAsFile(ObjectInputStream ois, long fileSize) throws IOException {
        int bufferSize = 8192;
        byte[] buf = new byte[bufferSize];
        File tempFile = File.createTempFile("" + System.currentTimeMillis(), "" + System.nanoTime());
        FileOutputStream fos = new FileOutputStream(tempFile);
        for (long readBytes = fileSize; readBytes > 0L; readBytes -= (long)bufferSize) {
            if (readBytes >= (long)bufferSize) {
                ois.readFully(buf);
                fos.write(buf);
                continue;
            }
            if (readBytes >= (long)bufferSize) continue;
            ois.readFully(buf, 0, (int)readBytes);
            fos.write(buf, 0, (int)readBytes);
        }
        fos.flush();
        fos.close();
        return tempFile;
    }

    @Override
    public BackupChain findBackup(String repository, String workspace) {
        for (BackupChain chain : this.currentBackups) {
            if (!repository.equals(chain.getBackupConfig().getRepository()) || !workspace.equals(chain.getBackupConfig().getWorkspace())) continue;
            return chain;
        }
        return null;
    }

    @Override
    public BackupScheduler getScheduler() {
        return this.scheduler;
    }

    File getLogsDirectory() {
        return this.logsDirectory;
    }

    class TaskFilter
    implements FileFilter {
        TaskFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".task");
        }
    }

    class LogsFilter
    implements FileFilter {
        LogsFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".xml");
        }
    }

    class MessagesListener
    implements BackupJobListener {
        MessagesListener() {
        }

        public void onError(BackupJob job, String message, Throwable error) {
            BackupManagerImpl.this.messages.addError(this.makeJobInfo(job, error) + message, error);
            log.error((Object)(this.makeJobInfo(job, error) + message), error);
        }

        public void onStateChanged(BackupJob job) {
            BackupManagerImpl.this.messages.addMessage(this.makeJobInfo(job, null));
            if (log.isDebugEnabled()) {
                log.debug((Object)this.makeJobInfo(job, null));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String makeJobInfo(BackupJob job, Throwable error) {
            String jobInfo = "";
            if (job != null) {
                switch (job.getType()) {
                    case 1: {
                        jobInfo = jobInfo + "FULL BACKUP";
                        break;
                    }
                    case 2: {
                        jobInfo = jobInfo + "INCREMENTAL BACKUP";
                    }
                }
                jobInfo = jobInfo + " [";
                switch (job.getState()) {
                    case 4: {
                        jobInfo = jobInfo + "FINISHED";
                        break;
                    }
                    case 0: {
                        jobInfo = jobInfo + "STARTING";
                        break;
                    }
                    case 1: {
                        jobInfo = jobInfo + "WAITING";
                        break;
                    }
                    case 2: {
                        jobInfo = jobInfo + "WORKING";
                    }
                }
                jobInfo = jobInfo + "]";
                if (error != null) {
                    jobInfo = jobInfo + " Error: " + error.getMessage();
                }
                try {
                    jobInfo = jobInfo + " log: " + job.getStorageURL().getPath();
                }
                catch (BackupOperationException e) {
                }
                finally {
                    jobInfo = jobInfo + " ";
                }
            }
            return jobInfo;
        }

        public String printStackTrace(Throwable error) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(out);
            error.printStackTrace(writer);
            return new String(out.toByteArray());
        }
    }
}

