/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequestDispatcher;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.log.LogUtil;
import org.exoplatform.services.portletcontainer.ExoPortletContext;
import org.exoplatform.services.portletcontainer.pci.model.Portlet;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortletRequestDispatcherImp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletContextImpl
implements PortletContext,
ExoPortletContext {
    private final ServletContext servletContext;
    private final Log log = LogUtil.getLog((String)"org.exoplatform.services.portletcontainer");
    private ExoContainer cont;
    private final Portlet portlet;

    public PortletContextImpl(ExoContainer cont, ServletContext scontext, Portlet portlet) {
        this.servletContext = scontext;
        this.cont = cont;
        this.portlet = portlet;
    }

    public final ExoContainer getContainer() {
        return this.cont;
    }

    public final String getServerInfo() {
        return this.servletContext.getServerInfo();
    }

    public final PortletRequestDispatcher getRequestDispatcher(String path) {
        if (path == null || !path.startsWith("/")) {
            return null;
        }
        RequestDispatcher rD = null;
        try {
            rD = this.servletContext.getRequestDispatcher(path);
            if (rD == null) {
                return null;
            }
        }
        catch (IllegalArgumentException e) {
            this.log.error((Object)"Can not lookup request dispatcher", (Throwable)e);
            return null;
        }
        return new PortletRequestDispatcherImp(this.cont, rD, path);
    }

    public final PortletRequestDispatcher getNamedDispatcher(String name) {
        RequestDispatcher rD = null;
        try {
            rD = this.servletContext.getNamedDispatcher(name);
            if (rD == null) {
                return null;
            }
        }
        catch (IllegalArgumentException e) {
            this.log.error((Object)"Can not lookup request dispatcher", (Throwable)e);
            return null;
        }
        return new PortletRequestDispatcherImp(this.cont, rD, name);
    }

    public final InputStream getResourceAsStream(String path) {
        return this.servletContext.getResourceAsStream(path);
    }

    public final int getMajorVersion() {
        if (this.portlet.getApplication().getVer2()) {
            return 2;
        }
        return 1;
    }

    public final int getMinorVersion() {
        return 0;
    }

    public final String getMimeType(String file) {
        return this.servletContext.getMimeType(file);
    }

    public final String getRealPath(String path) {
        return this.servletContext.getRealPath(path);
    }

    public final Set getResourcePaths(String path) {
        return this.servletContext.getResourcePaths(path);
    }

    public final URL getResource(String path) throws MalformedURLException {
        if (!path.startsWith("/")) {
            throw new MalformedURLException("path must start with /");
        }
        return this.servletContext.getResource(path);
    }

    public final Object getAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The attribute name cannot be null");
        }
        return this.servletContext.getAttribute(name);
    }

    public final void removeAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The attribute name cannot be null");
        }
        this.servletContext.removeAttribute(name);
    }

    public final void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("The attribute name cannot be null");
        }
        if (value == null) {
            this.servletContext.removeAttribute(name);
        } else {
            this.servletContext.setAttribute(name, value);
        }
    }

    public final Enumeration getAttributeNames() {
        return this.servletContext.getAttributeNames();
    }

    public final String getInitParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("argument must not be null");
        }
        return this.servletContext.getInitParameter(name);
    }

    public final Enumeration getInitParameterNames() {
        return this.servletContext.getInitParameterNames();
    }

    public final String getPortletContextName() {
        return this.servletContext.getServletContextName();
    }

    public final ServletContext getWrappedServletContext() {
        return this.servletContext;
    }

    public final void log(String msg) {
        this.servletContext.log(msg);
    }

    public final void log(String message, Throwable throwable) {
        this.servletContext.log(message, throwable);
    }

    public final Enumeration<String> getContainerRuntimeOptions() {
        Map a = this.portlet.getContainerRuntimeOption();
        Map b = this.portlet.getApplication().getContainerRuntimeOption();
        b.putAll(a);
        return Collections.enumeration(b.keySet());
    }

    public final Portlet getPortlet() {
        return this.portlet;
    }
}

