/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.application;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Widgets;
import org.exoplatform.portal.webui.application.UIWidgetContainerForm;
import org.exoplatform.portal.webui.application.UIWidgets;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.workspace.UIControlWorkspace;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/portal/webui/application/UIWidgetContainerManagement.gtmpl", events={@EventConfig(listeners={AddContainerActionListener.class}), @EventConfig(listeners={EditContainerActionListener.class}), @EventConfig(listeners={DeleteContainerActionListener.class}, confirm="UIWidgetContainerManagement.confirm.DeleteContainer"), @EventConfig(listeners={ChangeContainerActionListener.class}), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={UIMaskWorkspace.CloseActionListener.class})})
public class UIWidgetContainerManagement
extends org.exoplatform.webui.core.UIContainer {
    private List<Container> containers_;
    private Container selectedContainer_ = null;

    public UIWidgetContainerManagement() throws Exception {
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, "WidgetContainerPopup");
        UIWidgetContainerForm uiForm = (UIWidgetContainerForm)this.createUIComponent(UIWidgetContainerForm.class, null, null);
        uiPopup.setUIComponent((UIComponent)uiForm);
        uiPopup.setWindowSize(400, 0);
        uiPopup.setShowMask(true);
        this.loadContainer();
    }

    private void loadContainer() throws Exception {
        WebuiRequestContext rcontext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        UIPortalApplication uiPortalApp = (UIPortalApplication)rcontext.getUIApplication();
        UIControlWorkspace uiControl = (UIControlWorkspace)uiPortalApp.getChildById("UIControlWorkspace");
        UIWidgets uiWidgets = (UIWidgets)uiControl.findFirstComponentOfType(UIWidgets.class);
        List uiChildren = uiWidgets.getChildren();
        if (uiChildren == null) {
            return;
        }
        this.containers_ = new ArrayList<Container>();
        for (UIComponent ele : uiChildren) {
            this.containers_.add(PortalDataMapper.toContainer((UIContainer)ele));
        }
        this.loadSelectedContainer();
    }

    public void loadSelectedContainer() {
        if (this.containers_ == null || this.containers_.size() < 1) {
            this.setSelectedContainer(null);
        } else {
            this.setSelectedContainer(this.containers_.get(0));
        }
    }

    public List<Container> getContainers() {
        if (this.containers_ == null) {
            this.containers_ = new ArrayList<Container>();
        }
        return this.containers_;
    }

    public Container getSelectedContainer() {
        return this.selectedContainer_;
    }

    public void setSelectedContainer(Container selectedContainer) {
        this.selectedContainer_ = selectedContainer;
    }

    public void addContainer(Container container) {
        this.getContainers().add(container);
    }

    public void deletedContainer(Container container) {
        if (this.containers_ == null || this.containers_.size() < 1) {
            return;
        }
        this.containers_.remove(container);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIWidgetContainerManagement> {
        public void execute(Event<UIWidgetContainerManagement> event) throws Exception {
            UIWidgetContainerManagement uiManagement = (UIWidgetContainerManagement)((Object)event.getSource());
            WebuiRequestContext rcontext = event.getRequestContext();
            List<Container> containers = uiManagement.getContainers();
            UserPortalConfigService configService = (UserPortalConfigService)uiManagement.getApplicationComponent(UserPortalConfigService.class);
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiManagement.getAncestorOfType(UIPortalApplication.class);
            Widgets widgets = uiPortalApp.getUserPortalConfig().getWidgets();
            widgets.setChildren((ArrayList)containers);
            configService.update(widgets);
            UIControlWorkspace uiControl = (UIControlWorkspace)uiPortalApp.getChildById("UIControlWorkspace");
            UIWidgets uiWidgets = (UIWidgets)uiControl.findFirstComponentOfType(UIWidgets.class);
            PortalDataMapper.toUIWidgets(uiWidgets, widgets);
            rcontext.addUIComponentToUpdateByAjax((UIComponent)uiControl);
            UIMaskWorkspace uiMaskWorkspace = (UIMaskWorkspace)uiManagement.getParent();
            uiMaskWorkspace.createEvent("Close", Event.Phase.PROCESS, rcontext).broadcast();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeContainerActionListener
    extends EventListener<UIWidgetContainerManagement> {
        public void execute(Event<UIWidgetContainerManagement> event) throws Exception {
            WebuiRequestContext rcontext = event.getRequestContext();
            String containerId = rcontext.getRequestParameter("objectId");
            UIWidgetContainerManagement uiManagement = (UIWidgetContainerManagement)((Object)event.getSource());
            for (Container ele : uiManagement.getContainers()) {
                if (!ele.getId().equals(containerId)) continue;
                uiManagement.setSelectedContainer(ele);
                break;
            }
            rcontext.addUIComponentToUpdateByAjax((UIComponent)uiManagement);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteContainerActionListener
    extends EventListener<UIWidgetContainerManagement> {
        public void execute(Event<UIWidgetContainerManagement> event) throws Exception {
            UIWidgetContainerManagement uiManagement = (UIWidgetContainerManagement)((Object)event.getSource());
            Container selectedContainer = uiManagement.getSelectedContainer();
            if (selectedContainer == null) {
                return;
            }
            uiManagement.deletedContainer(selectedContainer);
            uiManagement.loadSelectedContainer();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManagement);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditContainerActionListener
    extends EventListener<UIWidgetContainerManagement> {
        public void execute(Event<UIWidgetContainerManagement> event) throws Exception {
            UIWidgetContainerManagement uiManagement = (UIWidgetContainerManagement)((Object)event.getSource());
            UIPopupWindow uiPopup = (UIPopupWindow)uiManagement.getChild(UIPopupWindow.class);
            Container selectedContainer = uiManagement.getSelectedContainer();
            if (selectedContainer == null) {
                return;
            }
            UIWidgetContainerForm uiForm = (UIWidgetContainerForm)uiPopup.getUIComponent();
            uiForm.setValue(selectedContainer);
            uiPopup.setShow(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddContainerActionListener
    extends EventListener<UIWidgetContainerManagement> {
        public void execute(Event<UIWidgetContainerManagement> event) throws Exception {
            UIWidgetContainerManagement uiManagement = (UIWidgetContainerManagement)((Object)event.getSource());
            UIPopupWindow uiPopup = (UIPopupWindow)uiManagement.getChild(UIPopupWindow.class);
            UIWidgetContainerForm uiForm = (UIWidgetContainerForm)uiPopup.getUIComponent();
            uiForm.setValue(null);
            uiPopup.setShow(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }
}

