/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.navigation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.navigation.UIPageNavigationActionListener;
import org.exoplatform.portal.webui.navigation.UIPageNavigationControlBar;
import org.exoplatform.portal.webui.navigation.UIPageNodeActionListener;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.page.UIPageEditBar;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIControlWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIPortalToolPanel;
import org.exoplatform.portal.webui.workspace.UIWorkspace;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIDropDownControl;
import org.exoplatform.webui.core.UIRightClickPopupMenu;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(template="app:/groovy/portal/webui/navigation/UIPageNodeSelector.gtmpl", events={@EventConfig(listeners={ChangeNodeActionListener.class}), @EventConfig(listeners={UIPageNavigationActionListener.CreateNavigationActionListener.class})}), @ComponentConfig(id="PageNodePopupMenu", type=UIRightClickPopupMenu.class, template="system:/groovy/webui/core/UIRightClickPopupMenu.gtmpl", events={@EventConfig(listeners={UIPageNodeActionListener.AddNodeActionListener.class}), @EventConfig(listeners={UIPageNodeActionListener.EditPageNodeActionListener.class}), @EventConfig(listeners={UIPageNodeActionListener.EditSelectedNodeActionListener.class}), @EventConfig(listeners={UIPageNodeActionListener.CopyNodeActionListener.class}), @EventConfig(listeners={UIPageNodeActionListener.CutNodeActionListener.class}), @EventConfig(listeners={UIPageNodeActionListener.PasteNodeActionListener.class}), @EventConfig(listeners={UIPageNodeActionListener.MoveUpActionListener.class}), @EventConfig(listeners={UIPageNodeActionListener.MoveDownActionListener.class}), @EventConfig(listeners={UIPageNodeActionListener.DeleteNodeActionListener.class}, confirm="UIPageNodeSelector.deleteNavigation")}), @ComponentConfig(id="UIPageNodeSelectorPopupMenu", type=UIRightClickPopupMenu.class, template="system:/groovy/webui/core/UIRightClickPopupMenu.gtmpl", events={@EventConfig(listeners={UIPageNodeActionListener.AddNodeActionListener.class}), @EventConfig(listeners={UIPageNodeActionListener.PasteNodeActionListener.class}), @EventConfig(listeners={UIPageNavigationActionListener.SaveNavigationActionListener.class}), @EventConfig(listeners={UIPageNavigationActionListener.EditNavigationActionListener.class}), @EventConfig(listeners={UIPageNavigationActionListener.DeleteNavigationActionListener.class}, confirm="UIPageNodeSelector.deleteNode")}), @ComponentConfig(type=UIDropDownControl.class, id="UIDropDown", template="system:/groovy/webui/core/UIDropDownControl.gtmpl", events={@EventConfig(listeners={SelectNavigationActionListener.class})})})
public class UIPageNodeSelector
extends UIContainer {
    private List<PageNavigation> navigations;
    private SelectedNode selectedNode;
    private SelectedNode copyNode;
    private List<PageNavigation> deleteNavigations = new ArrayList<PageNavigation>();

    public UIPageNodeSelector() throws Exception {
        ((UIRightClickPopupMenu)this.addChild(UIRightClickPopupMenu.class, "UIPageNodeSelectorPopupMenu", null)).setRendered(false);
        UIDropDownControl uiDopDownControl = (UIDropDownControl)this.addChild(UIDropDownControl.class, "UIDropDown", "UIDropDown");
        uiDopDownControl.setParent((UIComponent)this);
        UITree uiTree = (UITree)this.addChild(UITree.class, null, "TreePageSelector");
        uiTree.setIcon("DefaultPageIcon");
        uiTree.setSelectedIcon("DefaultPageIcon");
        uiTree.setBeanIdField("uri");
        uiTree.setBeanLabelField("resolvedLabel");
        uiTree.setBeanIconField("icon");
        UIRightClickPopupMenu uiPopupMenu = (UIRightClickPopupMenu)this.createUIComponent(UIRightClickPopupMenu.class, "PageNodePopupMenu", null);
        uiPopupMenu.setActions(new String[]{"AddNode", "EditPageNode", "EditSelectedNode", "CopyNode", "CutNode", "DeleteNode", "MoveUp", "MoveDown"});
        uiTree.setUIRightClickPopupMenu(uiPopupMenu);
        this.loadNavigations();
    }

    public void loadNavigations() throws Exception {
        String remoteUser = Util.getPortalRequestContext().getRemoteUser();
        this.navigations = new ArrayList<PageNavigation>();
        List<PageNavigation> pnavigations = this.getExistedNavigation(Util.getUIPortal().getNavigations());
        UserACL userACL = (UserACL)this.getApplicationComponent(UserACL.class);
        for (PageNavigation nav : pnavigations) {
            if ("portal".equals(nav.getOwnerType())) {
                if (!userACL.hasPermission(remoteUser, Util.getUIPortal().getEditPermission())) continue;
                this.navigations.add(nav.clone());
                continue;
            }
            if (!userACL.hasEditPermission(nav, remoteUser)) continue;
            this.navigations.add(nav);
        }
        this.updateUI();
        PageNavigation portalSelectedNav = Util.getUIPortal().getSelectedNavigation();
        if (this.getPageNavigation(portalSelectedNav.getId()) != null) {
            this.selectNavigation(portalSelectedNav.getId());
            PageNode portalSelectedNode = Util.getUIPortal().getSelectedNode();
            this.selectPageNodeByUri(portalSelectedNode.getUri());
            return;
        }
        this.selectNavigation();
    }

    private void updateUI() {
        if (this.navigations == null || this.navigations.size() < 1) {
            ((UIDropDownControl)this.getChild(UIDropDownControl.class)).setOptions(null);
            ((UITree)this.getChild(UITree.class)).setSibbling(null);
            return;
        }
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        for (PageNavigation navigation : this.navigations) {
            String label = navigation.getOwnerId() + "'s Nav";
            options.add(new SelectItemOption(navigation.getOwnerType() + ":" + label, (Object)navigation.getId()));
        }
        UIDropDownControl uiNavigationSelector = (UIDropDownControl)this.getChild(UIDropDownControl.class);
        uiNavigationSelector.setOptions(options);
        if (options.size() > 0) {
            uiNavigationSelector.setValue(0);
        }
    }

    private void selectNavigation() {
        if (this.navigations == null || this.navigations.size() < 1) {
            return;
        }
        if (this.selectedNode == null) {
            PageNavigation navigation = this.navigations.get(0);
            this.selectedNode = new SelectedNode(navigation, null, null);
            if (navigation.getNodes().size() > 0) {
                this.selectedNode.setNode((PageNode)navigation.getNodes().get(0));
            }
        }
        this.selectNavigation(this.selectedNode.getPageNavigation().getId());
        if (this.selectedNode.getNode() != null) {
            this.selectPageNodeByUri(this.selectedNode.getNode().getUri());
        }
    }

    public void selectNavigation(String id) {
        for (int i = 0; i < this.navigations.size(); ++i) {
            if (!this.navigations.get(i).getId().equals(id)) continue;
            this.selectedNode = new SelectedNode(this.navigations.get(i), null, null);
            this.selectPageNodeByUri(null);
            UITree uiTree = (UITree)this.getChild(UITree.class);
            uiTree.setSibbling((List)this.navigations.get(i).getNodes());
            UIDropDownControl uiDropDownSelector = (UIDropDownControl)this.getChild(UIDropDownControl.class);
            uiDropDownSelector.setValue(i);
        }
    }

    public void selectPageNodeByUri(String uri) {
        if (this.selectedNode == null) {
            return;
        }
        UITree tree = (UITree)this.getChild(UITree.class);
        List sibbling = tree.getSibbling();
        tree.setSibbling(null);
        tree.setParentSelected(null);
        this.selectedNode.setNode(this.searchPageNodeByUri(this.selectedNode.getPageNavigation(), uri));
        if (this.selectedNode.getNode() != null) {
            tree.setSelected((Object)this.selectedNode.getNode());
            tree.setChildren(this.selectedNode.getNode().getChildren());
            return;
        }
        tree.setSelected(null);
        tree.setChildren(null);
        tree.setSibbling(sibbling);
    }

    public PageNode searchPageNodeByUri(PageNavigation pageNav, String uri) {
        if (pageNav == null || uri == null) {
            return null;
        }
        ArrayList pageNodes = pageNav.getNodes();
        UITree uiTree = (UITree)this.getChild(UITree.class);
        for (PageNode ele : pageNodes) {
            PageNode returnPageNode = this.searchPageNodeByUri(ele, uri, uiTree);
            if (returnPageNode == null) continue;
            if (uiTree.getSibbling() == null) {
                uiTree.setSibbling((List)pageNodes);
            }
            return returnPageNode;
        }
        return null;
    }

    private PageNode searchPageNodeByUri(PageNode pageNode, String uri, UITree tree) {
        if (pageNode.getUri().equals(uri)) {
            return pageNode;
        }
        List children = pageNode.getChildren();
        if (children == null) {
            return null;
        }
        for (PageNode ele : children) {
            PageNode returnPageNode = this.searchPageNodeByUri(ele, uri, tree);
            if (returnPageNode == null) continue;
            if (tree.getSibbling() == null) {
                tree.setSibbling(children);
            }
            if (tree.getParentSelected() == null) {
                tree.setParentSelected((Object)pageNode);
            }
            this.selectedNode.setParentNode(pageNode);
            return returnPageNode;
        }
        return null;
    }

    public List<PageNavigation> getPageNavigations() {
        if (this.navigations == null) {
            this.navigations = new ArrayList<PageNavigation>();
        }
        return this.navigations;
    }

    public void addPageNavigation(PageNavigation navigation) {
        if (this.navigations == null) {
            this.navigations = new ArrayList<PageNavigation>();
        }
        this.navigations.add(navigation);
        this.updateUI();
    }

    public void deletePageNavigation(PageNavigation navigation) {
        if (this.navigations == null || this.navigations.size() < 1) {
            return;
        }
        this.navigations.remove(navigation);
        this.deleteNavigations.add(navigation);
        this.selectedNode = null;
        this.selectNavigation();
        this.updateUI();
    }

    public PageNavigation getPageNavigation(String id) {
        for (PageNavigation ele : this.getPageNavigations()) {
            if (!ele.getId().equals(id)) continue;
            return ele;
        }
        return null;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        UIRightClickPopupMenu uiPopupMenu = (UIRightClickPopupMenu)this.getChild(UIRightClickPopupMenu.class);
        if (uiPopupMenu != null) {
            if (this.navigations == null || this.navigations.size() < 1) {
                uiPopupMenu.setRendered(false);
            } else {
                uiPopupMenu.setRendered(true);
            }
        }
        super.processRender(context);
    }

    public SelectedNode getCopyNode() {
        return this.copyNode;
    }

    public void setCopyNode(SelectedNode copyNode) {
        this.copyNode = copyNode;
    }

    private List<PageNavigation> getExistedNavigation(List<PageNavigation> navis) throws Exception {
        Iterator<PageNavigation> itr = navis.iterator();
        UserPortalConfigService configService = (UserPortalConfigService)this.getApplicationComponent(UserPortalConfigService.class);
        while (itr.hasNext()) {
            PageNavigation navi = itr.next();
            if (configService.getPageNavigation(navi.getId()) != null) continue;
            itr.remove();
        }
        return navis;
    }

    public SelectedNode getSelectedNode() {
        return this.selectedNode;
    }

    public PageNavigation getSelectedNavigation() {
        return this.selectedNode == null ? null : this.selectedNode.getPageNavigation();
    }

    public PageNode getSelectedPageNode() {
        return this.selectedNode == null ? null : this.selectedNode.getNode();
    }

    public String getUpLevelUri() {
        return this.selectedNode.getParentNode().getUri();
    }

    public List<PageNavigation> getDeleteNavigations() {
        return this.deleteNavigations;
    }

    public static class SelectedNode {
        private PageNavigation nav;
        private PageNode parentNode;
        private PageNode node;
        private boolean deleteNode = false;

        public SelectedNode(PageNavigation nav, PageNode parentNode, PageNode node) {
            this.nav = nav;
            this.parentNode = parentNode;
            this.node = node;
        }

        public PageNavigation getPageNavigation() {
            return this.nav;
        }

        public void setPageNavigation(PageNavigation nav) {
            this.nav = nav;
        }

        public PageNode getParentNode() {
            return this.parentNode;
        }

        public void setParentNode(PageNode parentNode) {
            this.parentNode = parentNode;
        }

        public PageNode getNode() {
            return this.node;
        }

        public void setNode(PageNode node) {
            this.node = node;
        }

        public boolean isDeleteNode() {
            return this.deleteNode;
        }

        public void setDeleteNode(boolean deleteNode) {
            this.deleteNode = deleteNode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectNavigationActionListener
    extends EventListener<UIDropDownControl> {
        public void execute(Event<UIDropDownControl> event) throws Exception {
            String id = event.getRequestContext().getRequestParameter("objectId");
            UIDropDownControl uiDropDownControl = (UIDropDownControl)event.getSource();
            UIPageNodeSelector uiPageNodeSelector = (UIPageNodeSelector)uiDropDownControl.getParent();
            event.getRequestContext().addUIComponentToUpdateByAjax(uiPageNodeSelector.getParent());
            if (id != null) {
                uiPageNodeSelector.selectNavigation(id);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeNodeActionListener
    extends EventListener<UITree> {
        public void execute(Event<UITree> event) throws Exception {
            UIPageBody uiPageBody;
            String uri = event.getRequestContext().getRequestParameter("objectId");
            UIPageNodeSelector uiPageNodeSelector = (UIPageNodeSelector)((UITree)event.getSource()).getParent();
            uiPageNodeSelector.selectPageNodeByUri(uri);
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiPageNodeSelector.getAncestorOfType(UIPortalApplication.class);
            UIControlWorkspace uiControl = (UIControlWorkspace)uiPortalApp.getChildById("UIControlWorkspace");
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiControl);
            UIPortalToolPanel uiToolPanel = Util.getUIPortalToolPanel();
            uiToolPanel.setRenderSibbling(UIPortalToolPanel.class);
            uiToolPanel.setShowMaskLayer(true);
            UIWorkspace uiWorkingWS = (UIWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            pcontext.setFullRender(true);
            UIContainer uiParent = (UIContainer)uiPageNodeSelector.getParent();
            UIPageEditBar uiEditBar = (UIPageEditBar)uiParent.getChild(UIPageEditBar.class);
            PageNode node = null;
            node = uiPageNodeSelector.getSelectedNode() == null ? Util.getUIPortal().getSelectedNode() : uiPageNodeSelector.getSelectedNode().getNode();
            if (node == null) {
                uiPageNodeSelector.selectNavigation(uiPageNodeSelector.getSelectedNavigation().getId());
                uiToolPanel.setUIComponent(null);
                return;
            }
            UserPortalConfigService configService = (UserPortalConfigService)uiParent.getApplicationComponent(UserPortalConfigService.class);
            Page page = configService.getPage(node.getPageReference(), event.getRequestContext().getRemoteUser());
            if (page == null) {
                Class[] childrenToRender = new Class[]{UIPageNodeSelector.class, UIPageNavigationControlBar.class};
                uiParent.setRenderedChildrenOfTypes(childrenToRender);
                uiToolPanel.setUIComponent(null);
                return;
            }
            UIPage uiPage = uiEditBar.getUIPage();
            if (uiPage == null || !uiPage.getPageId().equals(page.getPageId())) {
                uiPage = Util.toUIPage(node, (UIComponent)uiToolPanel);
            }
            if ((uiPageBody = (UIPageBody)uiPortalApp.findFirstComponentOfType(UIPageBody.class)).getUIComponent() != null) {
                uiPageBody.setUIComponent(null);
            }
            uiToolPanel.setUIComponent((UIComponent)uiPage);
            if (!page.isModifiable()) {
                Class[] childrenToRender = new Class[]{UIPageNodeSelector.class, UIPageNavigationControlBar.class};
                uiParent.setRenderedChildrenOfTypes(childrenToRender);
                return;
            }
            uiEditBar.setRendered(true);
            if ("Desktop".equals(uiPage.getFactoryId())) {
                Class[] childrenToRender = new Class[]{UIPageNodeSelector.class, UIPageNavigationControlBar.class};
                uiParent.setRenderedChildrenOfTypes(childrenToRender);
                return;
            }
            uiEditBar.setUIPage(uiPage);
            Class[] childrenToRender = new Class[]{UIPageEditBar.class, UIPageNodeSelector.class, UIPageNavigationControlBar.class};
            uiParent.setRenderedChildrenOfTypes(childrenToRender);
        }
    }
}

