/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.application.portlet;

import java.io.Writer;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;
import org.exoplatform.web.application.URLBuilder;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletURLBuilder;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.lifecycle.HtmlValidator;

public class PortletRequestContext
extends WebuiRequestContext {
    public static int VIEW_MODE = 0;
    public static int EDIT_MODE = 1;
    public static int HELP_MODE = 2;
    public static int CONFIG_MODE = 3;
    private int applicationMode_;
    private String windowId_;
    private PortletRequest request_;
    private PortletResponse response_;
    private Writer writer_;
    private boolean hasProcessAction_ = false;

    public PortletRequestContext(WebuiApplication app, Writer writer, PortletRequest req, PortletResponse res) {
        super(app);
        this.init(writer, req, res);
        this.setSessionId(req.getPortletSession(true).getId());
        this.urlBuilder = new PortletURLBuilder();
    }

    public void init(Writer writer, PortletRequest req, PortletResponse res) {
        this.request_ = req;
        this.response_ = res;
        this.writer_ = new HtmlValidator(writer);
        this.windowId_ = req.getWindowID();
        PortletMode mode = req.getPortletMode();
        this.applicationMode_ = mode.equals((Object)PortletMode.VIEW) ? VIEW_MODE : (mode.equals((Object)PortletMode.EDIT) ? EDIT_MODE : (mode.equals((Object)PortletMode.HELP) ? HELP_MODE : VIEW_MODE));
    }

    public void setUIApplication(UIApplication uiApplication) throws Exception {
        this.uiApplication_ = uiApplication;
        this.appRes_ = this.getApplication().getResourceBundle(this.getParentAppRequestContext().getLocale());
    }

    public final String getRequestParameter(String name) {
        return this.request_.getParameter(name);
    }

    public final String[] getRequestParameterValues(String name) {
        return this.request_.getParameterValues(name);
    }

    public String getRequestContextPath() {
        return this.request_.getContextPath();
    }

    public PortletRequest getRequest() {
        return this.request_;
    }

    public PortletResponse getResponse() {
        return this.response_;
    }

    public String getRemoteUser() {
        return this.parentAppRequestContext_.getRemoteUser();
    }

    public final boolean isUserInRole(String roleUser) {
        return this.request_.isUserInRole(roleUser);
    }

    public int getApplicationMode() {
        return this.applicationMode_;
    }

    public void setApplicationMode(int mode) {
        this.applicationMode_ = mode;
    }

    public Writer getWriter() throws Exception {
        return this.writer_;
    }

    public final boolean useAjax() {
        return this.getParentAppRequestContext().useAjax();
    }

    public boolean hasProcessAction() {
        return this.hasProcessAction_;
    }

    public void setProcessAction(boolean b) {
        this.hasProcessAction_ = b;
    }

    public URLBuilder getURLBuilder() {
        RenderResponse renderRes = (RenderResponse)this.response_;
        this.urlBuilder.setBaseURL(renderRes.createActionURL().toString());
        return this.urlBuilder;
    }

    public String getWindowId() {
        return this.windowId_;
    }
}

