/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.Version;
import org.jgroups.View;
import org.jgroups.protocols.TpHeader;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Buffer;
import org.jgroups.util.DirectExecutor;
import org.jgroups.util.ExposedByteArrayInputStream;
import org.jgroups.util.ExposedByteArrayOutputStream;
import org.jgroups.util.ExposedDataOutputStream;
import org.jgroups.util.Queue;
import org.jgroups.util.QueueClosedException;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TP
extends Protocol {
    protected Address local_addr = null;
    protected String channel_name = null;
    protected InetAddress bind_addr = null;
    boolean use_local_host = false;
    boolean receive_on_all_interfaces = false;
    List<NetworkInterface> receive_interfaces = null;
    boolean send_on_all_interfaces = false;
    List<NetworkInterface> send_interfaces = null;
    int bind_port = 0;
    int port_range = 1;
    protected final Vector<Address> members = new Vector(11);
    protected View view = null;
    final ExposedByteArrayInputStream in_stream = new ExposedByteArrayInputStream(new byte[]{48});
    final DataInputStream dis = new DataInputStream(this.in_stream);
    boolean loopback = false;
    protected boolean discard_incompatible_packets = false;
    boolean use_incoming_packet_handler = true;
    Queue incoming_packet_queue = null;
    IncomingPacketHandler incoming_packet_handler = null;
    Queue incoming_msg_queue = null;
    IncomingMessageHandler incoming_msg_handler;
    boolean use_concurrent_stack = true;
    ThreadGroup pool_thread_group = new ThreadGroup(Util.getGlobalThreadGroup(), "Thread Pools");
    protected ThreadNamingPattern thread_naming_pattern = new ThreadNamingPattern("cl");
    Executor oob_thread_pool;
    boolean oob_thread_pool_enabled = true;
    int oob_thread_pool_min_threads = 2;
    int oob_thread_pool_max_threads = 10;
    long oob_thread_pool_keep_alive_time = 30000L;
    long num_oob_msgs_received = 0L;
    BlockingQueue<Runnable> oob_thread_pool_queue = null;
    boolean oob_thread_pool_queue_enabled = true;
    int oob_thread_pool_queue_max_size = 500;
    String oob_thread_pool_rejection_policy = "Run";
    Executor thread_pool;
    boolean thread_pool_enabled = true;
    int thread_pool_min_threads = 2;
    int thread_pool_max_threads = 10;
    long thread_pool_keep_alive_time = 30000L;
    long num_incoming_msgs_received = 0L;
    BlockingQueue<Runnable> thread_pool_queue = null;
    boolean thread_pool_queue_enabled = true;
    int thread_pool_queue_max_size = 500;
    String thread_pool_rejection_policy = "Run";
    byte[] additional_data = null;
    int max_bundle_size = 65535;
    long max_bundle_timeout = 20L;
    boolean enable_bundling = false;
    private Bundler bundler = null;
    protected TimeScheduler timer = null;
    private DiagnosticsHandler diag_handler = null;
    boolean enable_diagnostics = true;
    String diagnostics_addr = "224.0.0.75";
    int diagnostics_port = 7500;
    TpHeader header;
    final String name = this.getName();
    static final byte LIST = 1;
    static final byte MULTICAST = 2;
    static final byte OOB = 4;
    long num_msgs_sent = 0L;
    long num_msgs_received = 0L;
    long num_bytes_sent = 0L;
    long num_bytes_received = 0L;
    static NumberFormat f = NumberFormat.getNumberInstance();
    private static final int INITIAL_BUFSIZE = 1024;

    protected TP() {
    }

    public String toString() {
        return this.name + "(local address: " + this.local_addr + ')';
    }

    @Override
    public void resetStats() {
        this.num_bytes_received = 0L;
        this.num_bytes_sent = 0L;
        this.num_msgs_received = 0L;
        this.num_msgs_sent = 0L;
        this.num_incoming_msgs_received = 0L;
        this.num_oob_msgs_received = 0L;
    }

    public long getNumMessagesSent() {
        return this.num_msgs_sent;
    }

    public long getNumMessagesReceived() {
        return this.num_msgs_received;
    }

    public long getNumBytesSent() {
        return this.num_bytes_sent;
    }

    public long getNumBytesReceived() {
        return this.num_bytes_received;
    }

    public String getBindAddress() {
        return this.bind_addr != null ? this.bind_addr.toString() : "null";
    }

    public void setBindAddress(String bind_addr) throws UnknownHostException {
        this.bind_addr = InetAddress.getByName(bind_addr);
    }

    public boolean getBindToAllInterfaces() {
        return this.receive_on_all_interfaces;
    }

    public void setBindToAllInterfaces(boolean flag) {
        this.receive_on_all_interfaces = flag;
    }

    public boolean isReceiveOnAllInterfaces() {
        return this.receive_on_all_interfaces;
    }

    public List getReceiveInterfaces() {
        return this.receive_interfaces;
    }

    public boolean isSendOnAllInterfaces() {
        return this.send_on_all_interfaces;
    }

    public List getSendInterfaces() {
        return this.send_interfaces;
    }

    public boolean isDiscardIncompatiblePackets() {
        return this.discard_incompatible_packets;
    }

    public void setDiscardIncompatiblePackets(boolean flag) {
        this.discard_incompatible_packets = flag;
    }

    public boolean isEnableBundling() {
        return this.enable_bundling;
    }

    public void setEnableBundling(boolean flag) {
        this.enable_bundling = flag;
    }

    public int getMaxBundleSize() {
        return this.max_bundle_size;
    }

    public void setMaxBundleSize(int size) {
        this.max_bundle_size = size;
    }

    public long getMaxBundleTimeout() {
        return this.max_bundle_timeout;
    }

    public void setMaxBundleTimeout(long timeout) {
        this.max_bundle_timeout = timeout;
    }

    public Address getLocalAddress() {
        return this.local_addr;
    }

    public String getChannelName() {
        return this.channel_name;
    }

    public boolean isLoopback() {
        return this.loopback;
    }

    public void setLoopback(boolean b) {
        this.loopback = b;
    }

    public boolean isUseIncomingPacketHandler() {
        return this.use_incoming_packet_handler;
    }

    public int getOOBMinPoolSize() {
        return this.oob_thread_pool instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.oob_thread_pool).getCorePoolSize() : 0;
    }

    public void setOOBMinPoolSize(int size) {
        if (this.oob_thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.oob_thread_pool).setCorePoolSize(size);
        }
    }

    public int getOOBMaxPoolSize() {
        return this.oob_thread_pool instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.oob_thread_pool).getMaximumPoolSize() : 0;
    }

    public void setOOBMaxPoolSize(int size) {
        if (this.oob_thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.oob_thread_pool).setMaximumPoolSize(size);
        }
    }

    public int getOOBPoolSize() {
        return this.oob_thread_pool instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.oob_thread_pool).getPoolSize() : 0;
    }

    public long getOOBKeepAliveTime() {
        return this.oob_thread_pool instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.oob_thread_pool).getKeepAliveTime(TimeUnit.MILLISECONDS) : 0L;
    }

    public void setOOBKeepAliveTime(long time) {
        if (this.oob_thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.oob_thread_pool).setKeepAliveTime(time, TimeUnit.MILLISECONDS);
        }
    }

    public long getOOBMessages() {
        return this.num_oob_msgs_received;
    }

    public int getOOBQueueSize() {
        return this.oob_thread_pool_queue.size();
    }

    public int getOOBMaxQueueSize() {
        return this.oob_thread_pool_queue_max_size;
    }

    public int getIncomingMinPoolSize() {
        return this.thread_pool instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.thread_pool).getCorePoolSize() : 0;
    }

    public void setIncomingMinPoolSize(int size) {
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setCorePoolSize(size);
        }
    }

    public int getIncomingMaxPoolSize() {
        return this.thread_pool instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.thread_pool).getMaximumPoolSize() : 0;
    }

    public void setIncomingMaxPoolSize(int size) {
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setMaximumPoolSize(size);
        }
    }

    public int getIncomingPoolSize() {
        return this.thread_pool instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.thread_pool).getPoolSize() : 0;
    }

    public long getIncomingKeepAliveTime() {
        return this.thread_pool instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.thread_pool).getKeepAliveTime(TimeUnit.MILLISECONDS) : 0L;
    }

    public void setIncomingKeepAliveTime(long time) {
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setKeepAliveTime(time, TimeUnit.MILLISECONDS);
        }
    }

    public long getIncomingMessages() {
        return this.num_incoming_msgs_received;
    }

    public int getIncomingQueueSize() {
        return this.thread_pool_queue.size();
    }

    public int getIncomingMaxQueueSize() {
        return this.thread_pool_queue_max_size;
    }

    @Override
    public Map<String, Object> dumpStats() {
        Map<String, Object> retval = super.dumpStats();
        if (retval == null) {
            retval = new HashMap<String, Object>();
        }
        retval.put("num_msgs_sent", new Long(this.num_msgs_sent));
        retval.put("num_msgs_received", new Long(this.num_msgs_received));
        retval.put("num_bytes_sent", new Long(this.num_bytes_sent));
        retval.put("num_bytes_received", new Long(this.num_bytes_received));
        return retval;
    }

    public abstract void sendToAllMembers(byte[] var1, int var2, int var3) throws Exception;

    public abstract void sendToSingleMember(Address var1, byte[] var2, int var3, int var4) throws Exception;

    public abstract String getInfo();

    public abstract void postUnmarshalling(Message var1, Address var2, Address var3, boolean var4);

    public abstract void postUnmarshallingList(Message var1, Address var2, boolean var3);

    private StringBuffer _getInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.local_addr).append(" (").append(this.channel_name).append(") ").append("\n");
        sb.append("local_addr=").append(this.local_addr).append("\n");
        sb.append("group_name=").append(this.channel_name).append("\n");
        sb.append("version=").append("2.5.0").append(", cvs=\"").append("$Id: Version.java,v 1.54 2007/07/02 14:39:09 belaban Exp $").append("\"\n");
        sb.append("view: ").append(this.view).append('\n');
        sb.append(this.getInfo());
        return sb;
    }

    private void handleDiagnosticProbe(SocketAddress sender, DatagramSocket sock, String request) {
        block8: {
            try {
                StringTokenizer tok = new StringTokenizer(request);
                String req = tok.nextToken();
                StringBuffer info = new StringBuffer("n/a");
                if (req.trim().toLowerCase().startsWith("query")) {
                    Channel ch;
                    ArrayList<String> l = new ArrayList<String>(tok.countTokens());
                    while (tok.hasMoreTokens()) {
                        l.add(tok.nextToken().trim().toLowerCase());
                    }
                    info = this._getInfo();
                    if (l.contains("jmx") && (ch = this.stack.getChannel()) != null) {
                        Map m = ch.dumpStats();
                        StringBuffer sb = new StringBuffer();
                        sb.append("stats:\n");
                        Iterator it = m.entrySet().iterator();
                        while (it.hasNext()) {
                            sb.append(it.next()).append("\n");
                        }
                        info.append(sb);
                    }
                    if (l.contains("props")) {
                        String p = this.stack.printProtocolSpecAsXML();
                        info.append("\nprops:\n").append(p);
                    }
                }
                byte[] diag_rsp = info.toString().getBytes();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("sending diag response to " + sender));
                }
                TP.sendResponse(sock, sender, diag_rsp);
            }
            catch (Throwable t) {
                if (!this.log.isErrorEnabled()) break block8;
                this.log.error((Object)("failed sending diag rsp to " + sender), t);
            }
        }
    }

    private static void sendResponse(DatagramSocket sock, SocketAddress sender, byte[] buf) throws IOException {
        DatagramPacket p = new DatagramPacket(buf, 0, buf.length, sender);
        sock.send(p);
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.bind_addr != null) {
            HashMap<String, InetAddress> m = new HashMap<String, InetAddress>(1);
            m.put("bind_addr", this.bind_addr);
            this.up_prot.up(new Event(56, m));
        }
    }

    @Override
    public void start() throws Exception {
        this.timer = this.stack.timer;
        if (this.timer == null) {
            throw new Exception("timer is null");
        }
        if (this.enable_diagnostics) {
            this.diag_handler = new DiagnosticsHandler();
            this.diag_handler.start();
        }
        if (this.use_incoming_packet_handler && !this.use_concurrent_stack) {
            this.incoming_packet_queue = new Queue();
            this.incoming_packet_handler = new IncomingPacketHandler();
            this.incoming_packet_handler.start();
        }
        if (this.oob_thread_pool_enabled) {
            this.oob_thread_pool_queue = this.oob_thread_pool_queue_enabled ? new LinkedBlockingQueue<Runnable>(this.oob_thread_pool_queue_max_size) : new SynchronousQueue<Runnable>();
            this.oob_thread_pool = this.createThreadPool(this.oob_thread_pool_min_threads, this.oob_thread_pool_max_threads, this.oob_thread_pool_keep_alive_time, this.oob_thread_pool_rejection_policy, this.oob_thread_pool_queue, "OOB", "OOB Thread");
        } else {
            this.oob_thread_pool = new DirectExecutor();
        }
        if (this.thread_pool_enabled) {
            this.thread_pool_queue = this.thread_pool_queue_enabled ? new LinkedBlockingQueue<Runnable>(this.thread_pool_queue_max_size) : new SynchronousQueue<Runnable>();
            this.thread_pool = this.createThreadPool(this.thread_pool_min_threads, this.thread_pool_max_threads, this.thread_pool_keep_alive_time, this.thread_pool_rejection_policy, this.thread_pool_queue, "Incoming", "Incoming Thread");
        } else {
            this.thread_pool = new DirectExecutor();
        }
        if (this.loopback && !this.use_concurrent_stack) {
            this.incoming_msg_queue = new Queue();
            this.incoming_msg_handler = new IncomingMessageHandler();
            this.incoming_msg_handler.start();
        }
        if (this.enable_bundling) {
            this.bundler = new Bundler();
        }
        this.up_prot.up(new Event(8, this.local_addr));
    }

    @Override
    public void stop() {
        if (this.diag_handler != null) {
            this.diag_handler.stop();
            this.diag_handler = null;
        }
        if (this.incoming_packet_handler != null) {
            this.incoming_packet_handler.stop();
        }
        if (this.incoming_msg_handler != null) {
            this.incoming_msg_handler.stop();
        }
        if (this.oob_thread_pool instanceof ThreadPoolExecutor) {
            TP.shutdownThreadPool((ThreadPoolExecutor)this.oob_thread_pool);
        }
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            TP.shutdownThreadPool((ThreadPoolExecutor)this.thread_pool);
        }
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        boolean ignore_systemprops = Util.isBindAddressPropertyIgnored();
        String str = Util.getProperty(new String[]{"jgroups.bind_addr", "bind.address"}, props, "bind_addr", ignore_systemprops, null);
        if (str != null) {
            try {
                this.bind_addr = InetAddress.getByName(str);
            }
            catch (UnknownHostException unknown) {
                if (this.log.isFatalEnabled()) {
                    this.log.fatal((Object)("(bind_addr): host " + str + " not known"));
                }
                return false;
            }
            props.remove("bind_addr");
        }
        if ((str = props.getProperty("use_local_host")) != null) {
            this.use_local_host = Boolean.parseBoolean(str);
            props.remove("use_local_host");
        }
        if ((str = props.getProperty("bind_to_all_interfaces")) != null) {
            this.receive_on_all_interfaces = Boolean.parseBoolean(str);
            props.remove("bind_to_all_interfaces");
            this.log.warn((Object)"bind_to_all_interfaces has been deprecated; use receive_on_all_interfaces instead");
        }
        if ((str = props.getProperty("receive_on_all_interfaces")) != null) {
            this.receive_on_all_interfaces = Boolean.parseBoolean(str);
            props.remove("receive_on_all_interfaces");
        }
        if ((str = props.getProperty("receive_interfaces")) != null) {
            try {
                this.receive_interfaces = Util.parseInterfaceList(str);
                props.remove("receive_interfaces");
            }
            catch (Exception e) {
                this.log.error((Object)("error determining interfaces (" + str + ")"), (Throwable)e);
                return false;
            }
        }
        if ((str = props.getProperty("send_on_all_interfaces")) != null) {
            this.send_on_all_interfaces = Boolean.parseBoolean(str);
            props.remove("send_on_all_interfaces");
        }
        if ((str = props.getProperty("send_interfaces")) != null) {
            try {
                this.send_interfaces = Util.parseInterfaceList(str);
                props.remove("send_interfaces");
            }
            catch (Exception e) {
                this.log.error((Object)("error determining interfaces (" + str + ")"), (Throwable)e);
                return false;
            }
        }
        if ((str = props.getProperty("bind_port")) != null) {
            this.bind_port = Integer.parseInt(str);
            props.remove("bind_port");
        }
        if ((str = props.getProperty("port_range")) != null) {
            this.port_range = Integer.parseInt(str);
            props.remove("port_range");
        }
        if ((str = props.getProperty("loopback")) != null) {
            this.loopback = Boolean.valueOf(str);
            props.remove("loopback");
        }
        if ((str = props.getProperty("discard_incompatible_packets")) != null) {
            this.discard_incompatible_packets = Boolean.valueOf(str);
            props.remove("discard_incompatible_packets");
        }
        if ((str = props.getProperty("use_packet_handler")) != null) {
            this.use_incoming_packet_handler = Boolean.valueOf(str);
            props.remove("use_packet_handler");
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)"'use_packet_handler' is deprecated; use 'use_incoming_packet_handler' instead");
            }
        }
        if ((str = props.getProperty("use_incoming_packet_handler")) != null) {
            this.use_incoming_packet_handler = Boolean.valueOf(str);
            props.remove("use_incoming_packet_handler");
        }
        if ((str = props.getProperty("use_concurrent_stack")) != null) {
            this.use_concurrent_stack = Boolean.valueOf(str);
            props.remove("use_concurrent_stack");
        }
        if ((str = props.getProperty("thread_naming_pattern")) != null) {
            this.thread_naming_pattern = new ThreadNamingPattern(str);
            props.remove("thread_naming_pattern");
        }
        if ((str = props.getProperty("oob_thread_pool.enabled")) != null) {
            this.oob_thread_pool_enabled = Boolean.valueOf(str);
            props.remove("oob_thread_pool.enabled");
        }
        if ((str = props.getProperty("oob_thread_pool.min_threads")) != null) {
            this.oob_thread_pool_min_threads = Integer.valueOf(str);
            props.remove("oob_thread_pool.min_threads");
        }
        if ((str = props.getProperty("oob_thread_pool.max_threads")) != null) {
            this.oob_thread_pool_max_threads = Integer.valueOf(str);
            props.remove("oob_thread_pool.max_threads");
        }
        if ((str = props.getProperty("oob_thread_pool.keep_alive_time")) != null) {
            this.oob_thread_pool_keep_alive_time = Long.valueOf(str);
            props.remove("oob_thread_pool.keep_alive_time");
        }
        if ((str = props.getProperty("oob_thread_pool.queue_enabled")) != null) {
            this.oob_thread_pool_queue_enabled = Boolean.valueOf(str);
            props.remove("oob_thread_pool.queue_enabled");
        }
        if ((str = props.getProperty("oob_thread_pool.queue_max_size")) != null) {
            this.oob_thread_pool_queue_max_size = Integer.valueOf(str);
            props.remove("oob_thread_pool.queue_max_size");
        }
        if ((str = props.getProperty("oob_thread_pool.rejection_policy")) != null) {
            this.oob_thread_pool_rejection_policy = str = str.toLowerCase().trim();
            if (!(str.equals("run") || str.equals("abort") || str.equals("discard") || str.equals("discardoldest"))) {
                this.log.error((Object)("rejection policy of " + str + " is unknown"));
                return false;
            }
            props.remove("oob_thread_pool.rejection_policy");
        }
        if ((str = props.getProperty("thread_pool.enabled")) != null) {
            this.thread_pool_enabled = Boolean.valueOf(str);
            props.remove("thread_pool.enabled");
        }
        if ((str = props.getProperty("thread_pool.min_threads")) != null) {
            this.thread_pool_min_threads = Integer.valueOf(str);
            props.remove("thread_pool.min_threads");
        }
        if ((str = props.getProperty("thread_pool.max_threads")) != null) {
            this.thread_pool_max_threads = Integer.valueOf(str);
            props.remove("thread_pool.max_threads");
        }
        if ((str = props.getProperty("thread_pool.keep_alive_time")) != null) {
            this.thread_pool_keep_alive_time = Long.valueOf(str);
            props.remove("thread_pool.keep_alive_time");
        }
        if ((str = props.getProperty("thread_pool.queue_enabled")) != null) {
            this.thread_pool_queue_enabled = Boolean.valueOf(str);
            props.remove("thread_pool.queue_enabled");
        }
        if ((str = props.getProperty("thread_pool.queue_max_size")) != null) {
            this.thread_pool_queue_max_size = Integer.valueOf(str);
            props.remove("thread_pool.queue_max_size");
        }
        if ((str = props.getProperty("thread_pool.rejection_policy")) != null) {
            this.thread_pool_rejection_policy = str = str.toLowerCase().trim();
            if (!(str.equals("run") || str.equals("abort") || str.equals("discard") || str.equals("discardoldest"))) {
                this.log.error((Object)("rejection policy of " + str + " is unknown"));
                return false;
            }
            props.remove("thread_pool.rejection_policy");
        }
        if ((str = props.getProperty("use_outgoing_packet_handler")) != null) {
            this.log.warn((Object)"Attribute \"use_outgoing_packet_handler\" has been deprecated and is ignored");
            props.remove("use_outgoing_packet_handler");
        }
        if ((str = props.getProperty("outgoing_queue_max_size")) != null) {
            this.log.warn((Object)"Attribute \"use_outgoing_queue_max_size\" has been deprecated and is ignored");
            props.remove("outgoing_queue_max_size");
        }
        if ((str = props.getProperty("max_bundle_size")) != null) {
            int bundle_size = Integer.parseInt(str);
            if (bundle_size > this.max_bundle_size) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("max_bundle_size (" + bundle_size + ") is greater than largest TP fragmentation size (" + this.max_bundle_size + ')'));
                }
                return false;
            }
            if (bundle_size <= 0) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("max_bundle_size (" + bundle_size + ") is <= 0"));
                }
                return false;
            }
            this.max_bundle_size = bundle_size;
            props.remove("max_bundle_size");
        }
        if ((str = props.getProperty("max_bundle_timeout")) != null) {
            this.max_bundle_timeout = Long.parseLong(str);
            if (this.max_bundle_timeout <= 0L) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("max_bundle_timeout of " + this.max_bundle_timeout + " is invalid"));
                }
                return false;
            }
            props.remove("max_bundle_timeout");
        }
        if ((str = props.getProperty("enable_bundling")) != null) {
            this.enable_bundling = Boolean.valueOf(str);
            props.remove("enable_bundling");
        }
        if ((str = props.getProperty("enable_diagnostics")) != null) {
            this.enable_diagnostics = Boolean.valueOf(str);
            props.remove("enable_diagnostics");
        }
        if ((str = props.getProperty("diagnostics_addr")) != null) {
            this.diagnostics_addr = str;
            props.remove("diagnostics_addr");
        }
        if ((str = props.getProperty("diagnostics_port")) != null) {
            this.diagnostics_port = Integer.parseInt(str);
            props.remove("diagnostics_port");
        }
        return true;
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 56: {
                this.up_prot.up(evt);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("received CONFIG event: " + evt.getArg()));
                }
                this.handleConfigEvent((HashMap)evt.getArg());
                return null;
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object down(Event evt) {
        block9: {
            Address dest;
            boolean multicast;
            if (evt.getType() != 1) {
                return this.handleDownEvent(evt);
            }
            Message msg = (Message)evt.getArg();
            if (this.header != null) {
                msg.putHeader(this.name, this.header);
            }
            this.setSourceAddress(msg);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("sending msg to " + msg.getDest() + ", src=" + msg.getSrc() + ", headers are " + msg.printHeaders()));
            }
            boolean bl = multicast = (dest = msg.getDest()) == null || dest.isMulticastAddress();
            if (this.loopback && (multicast || dest.equals(this.local_addr))) {
                final Message copy = msg.copy();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)new StringBuffer("looping back message ").append(copy));
                }
                Executor pool = msg.isFlagSet((byte)1) ? this.oob_thread_pool : this.thread_pool;
                pool.execute(new Runnable(){

                    public void run() {
                        TP.this.up_prot.up(new Event(1, copy));
                    }
                });
                if (!multicast) {
                    return null;
                }
            }
            try {
                this.send(msg, dest, multicast);
            }
            catch (InterruptedException interruptedEx) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable e) {
                if (!this.log.isErrorEnabled()) break block9;
                String dst = msg.getDest() == null ? "null" : msg.getDest().toString();
                this.log.error((Object)("failed sending message to " + dst + " (" + msg.size() + " bytes)"), e);
            }
        }
        return null;
    }

    private void setSourceAddress(Message msg) {
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
    }

    protected final void receive(Address dest, Address sender, byte[] data, int offset, int length) {
        block11: {
            if (data == null) {
                return;
            }
            if (this.log.isTraceEnabled()) {
                boolean mcast = dest == null || dest.isMulticastAddress();
                StringBuilder sb = new StringBuilder("received (");
                sb.append(mcast ? "mcast) " : "ucast) ").append(length).append(" bytes from ").append(sender);
                this.log.trace((Object)sb.toString());
            }
            try {
                boolean oob = false;
                byte oob_flag = data[2];
                if ((oob_flag & 4) == 4) {
                    oob = true;
                }
                if (this.use_concurrent_stack) {
                    if (oob) {
                        ++this.num_oob_msgs_received;
                        this.dispatchToThreadPool(this.oob_thread_pool, dest, sender, data, offset, length);
                    } else {
                        ++this.num_incoming_msgs_received;
                        this.dispatchToThreadPool(this.thread_pool, dest, sender, data, offset, length);
                    }
                } else if (this.use_incoming_packet_handler) {
                    byte[] tmp = new byte[length];
                    System.arraycopy(data, offset, tmp, 0, length);
                    this.incoming_packet_queue.add(new IncomingPacket(dest, sender, tmp, 0, length));
                } else {
                    this.handleIncomingPacket(dest, sender, data, offset, length);
                }
            }
            catch (Throwable t) {
                if (!this.log.isErrorEnabled()) break block11;
                this.log.error((Object)new StringBuffer("failed handling data from ").append(sender), t);
            }
        }
    }

    private void dispatchToThreadPool(Executor pool, Address dest, Address sender, byte[] data, int offset, int length) {
        if (pool instanceof DirectExecutor) {
            pool.execute(new IncomingPacket(dest, sender, data, offset, length));
        } else {
            byte[] tmp = new byte[length];
            System.arraycopy(data, offset, tmp, 0, length);
            pool.execute(new IncomingPacket(dest, sender, tmp, 0, length));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIncomingPacket(Address dest, Address sender, byte[] data, int offset, int length) {
        block18: {
            Message msg = null;
            short version = 0;
            try {
                List<Message> msgs;
                boolean multicast;
                ExposedByteArrayInputStream exposedByteArrayInputStream = this.in_stream;
                synchronized (exposedByteArrayInputStream) {
                    byte flags;
                    this.in_stream.setData(data, offset, length);
                    try {
                        version = this.dis.readShort();
                    }
                    catch (IOException ex) {
                        if (this.discard_incompatible_packets) {
                            return;
                        }
                        throw ex;
                    }
                    if (!Version.isBinaryCompatible(version)) {
                        if (this.log.isWarnEnabled()) {
                            StringBuffer sb = new StringBuffer();
                            sb.append("packet from ").append(sender).append(" has different version (").append(Version.print(version));
                            sb.append(") from ours (").append(Version.printVersion()).append("). ");
                            if (this.discard_incompatible_packets) {
                                sb.append("Packet is discarded");
                            } else {
                                sb.append("This may cause problems");
                            }
                            this.log.warn((Object)sb);
                        }
                        if (this.discard_incompatible_packets) {
                            return;
                        }
                    }
                    boolean is_message_list = ((flags = this.dis.readByte()) & 1) == 1;
                    boolean bl = multicast = (flags & 2) == 2;
                    if (is_message_list) {
                        msgs = this.readMessageList(this.dis, dest, multicast);
                    } else {
                        msg = this.readMessage(this.dis, dest, sender, multicast);
                        msgs = new LinkedList<Message>();
                        msgs.add(msg);
                    }
                }
                Iterator<Message> it = msgs.iterator();
                while (it.hasNext()) {
                    msg = it.next();
                    Address src = msg.getSrc();
                    if (this.loopback) {
                        if (!multicast || src == null || !this.local_addr.equals(src)) continue;
                        it.remove();
                        continue;
                    }
                    this.handleIncomingMessage(msg);
                }
                if (this.incoming_msg_queue != null && !msgs.isEmpty()) {
                    this.incoming_msg_queue.addAll(msgs);
                }
            }
            catch (Throwable t) {
                if (!this.log.isErrorEnabled()) break block18;
                this.log.error((Object)"failed unmarshalling message", t);
            }
        }
    }

    private void handleIncomingMessage(Message msg) {
        TpHeader hdr;
        if (this.stats) {
            ++this.num_msgs_received;
            this.num_bytes_received += (long)msg.getLength();
        }
        Event evt = new Event(1, msg);
        if (this.log.isTraceEnabled()) {
            StringBuffer sb = new StringBuffer("message is ").append(msg).append(", headers are ").append(msg.printHeaders());
            this.log.trace((Object)sb);
        }
        if ((hdr = (TpHeader)msg.getHeader(this.name)) != null) {
            String ch_name = hdr.channel_name;
            if (this.channel_name != null && !this.channel_name.equals(ch_name)) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)new StringBuffer("discarded message from different group \"").append(ch_name).append("\" (our group is \"").append(this.channel_name).append("\"). Sender was ").append(msg.getSrc()));
                }
                return;
            }
        } else {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)new StringBuffer("message does not have a transport header, msg is ").append(msg).append(", headers are ").append(msg.printHeaders()).append(", will be discarded"));
            }
            return;
        }
        this.up_prot.up(evt);
    }

    private void send(Message msg, Address dest, boolean multicast) throws Exception {
        if (this.enable_bundling && !msg.isFlagSet((byte)1)) {
            this.bundler.send(msg, dest);
            return;
        }
        ExposedByteArrayOutputStream out_stream = null;
        ExposedDataOutputStream dos = null;
        out_stream = new ExposedByteArrayOutputStream(1024);
        dos = new ExposedDataOutputStream(out_stream);
        TP.writeMessage(msg, dos, multicast);
        Buffer buf = new Buffer(out_stream.getRawBuffer(), 0, out_stream.size());
        this.doSend(buf, dest, multicast);
    }

    private void doSend(Buffer buf, Address dest, boolean multicast) throws Exception {
        if (this.stats) {
            ++this.num_msgs_sent;
            this.num_bytes_sent += (long)buf.getLength();
        }
        if (multicast) {
            this.sendToAllMembers(buf.getBuf(), buf.getOffset(), buf.getLength());
        } else {
            this.sendToSingleMember(dest, buf.getBuf(), buf.getOffset(), buf.getLength());
        }
    }

    private static void writeMessage(Message msg, DataOutputStream dos, boolean multicast) throws Exception {
        int flags = 0;
        dos.writeShort(Version.version);
        if (multicast) {
            flags = (byte)(flags + 2);
        }
        if (msg.isFlagSet((byte)1)) {
            flags = (byte)(flags + 4);
        }
        dos.writeByte(flags);
        msg.writeTo(dos);
    }

    private Message readMessage(DataInputStream instream, Address dest, Address sender, boolean multicast) throws Exception {
        Message msg = new Message(false);
        msg.readFrom(instream);
        this.postUnmarshalling(msg, dest, sender, multicast);
        return msg;
    }

    private static void writeMessageList(List<Message> msgs, DataOutputStream dos, boolean multicast) throws Exception {
        int flags = 0;
        int len = msgs != null ? msgs.size() : 0;
        boolean src_written = false;
        dos.writeShort(Version.version);
        flags = (byte)(flags + 1);
        if (multicast) {
            flags = (byte)(flags + 2);
        }
        dos.writeByte(flags);
        dos.writeInt(len);
        if (msgs != null) {
            for (Message msg : msgs) {
                Address src = msg.getSrc();
                if (!src_written) {
                    Util.writeAddress(src, dos);
                    src_written = true;
                }
                msg.writeTo(dos);
            }
        }
    }

    private List<Message> readMessageList(DataInputStream instream, Address dest, boolean multicast) throws Exception {
        LinkedList<Message> list = new LinkedList<Message>();
        int len = instream.readInt();
        Address src = Util.readAddress(instream);
        for (int i = 0; i < len; ++i) {
            Message msg = new Message(false);
            msg.readFrom(instream);
            this.postUnmarshallingList(msg, dest, multicast);
            msg.setSrc(src);
            list.add(msg);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object handleDownEvent(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 15: {
                Vector<Address> vector = this.members;
                synchronized (vector) {
                    this.view = (View)evt.getArg();
                    this.members.clear();
                    Vector<Address> tmpvec = this.view.getMembers();
                    this.members.addAll(tmpvec);
                    break;
                }
            }
            case 2: {
                this.channel_name = (String)evt.getArg();
                this.header = new TpHeader(this.channel_name);
                this.setThreadNames();
                return null;
            }
            case 4: {
                this.unsetThreadNames();
                break;
            }
            case 56: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("received CONFIG event: " + evt.getArg()));
                }
                this.handleConfigEvent((HashMap)evt.getArg());
            }
        }
        return null;
    }

    protected void setThreadNames() {
        if (this.thread_naming_pattern != null) {
            if (this.incoming_packet_handler != null) {
                this.thread_naming_pattern.renameThread("IncomingPacketHandler", this.incoming_packet_handler.getThread());
            }
            if (this.incoming_msg_handler != null) {
                this.thread_naming_pattern.renameThread("IncomingMessageHandler", this.incoming_msg_handler.getThread());
            }
            if (this.diag_handler != null) {
                this.thread_naming_pattern.renameThread("DiagnosticsHandler", this.diag_handler.getThread());
            }
        }
    }

    protected void unsetThreadNames() {
        if (this.incoming_packet_handler != null && this.incoming_packet_handler.getThread() != null) {
            this.incoming_packet_handler.getThread().setName("IncomingPacketHandler");
        }
        if (this.incoming_msg_handler != null && this.incoming_msg_handler.getThread() != null) {
            this.incoming_msg_handler.getThread().setName("IncomingMessageHandler");
        }
        if (this.diag_handler != null && this.diag_handler.getThread() != null) {
            this.diag_handler.getThread().setName("DiagnosticsHandler");
        }
    }

    protected void handleConfigEvent(HashMap map) {
        if (map == null) {
            return;
        }
        if (map.containsKey("additional_data")) {
            this.additional_data = (byte[])map.get("additional_data");
            if (this.local_addr instanceof IpAddress) {
                ((IpAddress)this.local_addr).setAdditionalData(this.additional_data);
            }
        }
    }

    protected Executor createThreadPool(int min_threads, int max_threads, long keep_alive_time, String rejection_policy, BlockingQueue<Runnable> queue, final String thread_group_name, final String thread_name) {
        ThreadPoolExecutor pool = null;
        pool = new ThreadPoolExecutor(min_threads, max_threads, keep_alive_time, TimeUnit.MILLISECONDS, queue);
        pool.setThreadFactory(new ThreadFactory(){
            ThreadGroup unmarshaller_threads;
            {
                this.unmarshaller_threads = new ThreadGroup(TP.this.pool_thread_group, thread_group_name);
            }

            public Thread newThread(Runnable command) {
                Thread retval = new Thread(this.unmarshaller_threads, command, thread_name);
                if (TP.this.thread_naming_pattern != null) {
                    TP.this.thread_naming_pattern.renameThread(thread_name, retval);
                }
                return retval;
            }
        });
        if (rejection_policy != null) {
            if (rejection_policy.equals("abort")) {
                pool.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
            } else if (rejection_policy.equals("discard")) {
                pool.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy());
            } else if (rejection_policy.equals("discardoldest")) {
                pool.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardOldestPolicy());
            } else {
                pool.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
            }
        }
        return pool;
    }

    private static void shutdownThreadPool(ThreadPoolExecutor thread_pool) {
        thread_pool.shutdownNow();
        try {
            thread_pool.awaitTermination(3000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        f.setGroupingUsed(false);
        f.setMaximumFractionDigits(2);
    }

    public class ThreadNamingPattern {
        final boolean includeClusterName;
        final boolean includeLocalAddress;

        public ThreadNamingPattern(String pattern) {
            this.includeClusterName = pattern.contains("c");
            this.includeLocalAddress = pattern.contains("l");
        }

        public boolean isIncludeLocalAddress() {
            return this.includeLocalAddress;
        }

        public boolean isIncludeClusterName() {
            return this.includeClusterName;
        }

        protected String renameThread(String base_name, Thread runner) {
            String oldName = null;
            if (runner != null) {
                oldName = runner.getName();
                StringBuilder threadName = new StringBuilder();
                threadName.append(base_name);
                if (this.isIncludeClusterName()) {
                    if (threadName.length() > 0) {
                        threadName.append(',');
                    }
                    threadName.append(TP.this.getChannelName());
                }
                if (this.isIncludeLocalAddress()) {
                    if (threadName.length() > 0) {
                        threadName.append(',');
                    }
                    threadName.append(TP.this.getLocalAddress());
                }
                runner.setName(threadName.toString());
            }
            return oldName;
        }
    }

    private class DiagnosticsHandler
    implements Runnable {
        public static final String THREAD_NAME = "DiagnosticsHandler";
        Thread thread = null;
        MulticastSocket diag_sock = null;

        DiagnosticsHandler() {
        }

        Thread getThread() {
            return this.thread;
        }

        void start() throws IOException {
            this.diag_sock = new MulticastSocket(TP.this.diagnostics_port);
            List<NetworkInterface> interfaces = Util.getAllAvailableInterfaces();
            this.bindToInterfaces(interfaces, this.diag_sock);
            if (this.thread == null || !this.thread.isAlive()) {
                this.thread = new Thread(Util.getGlobalThreadGroup(), this, THREAD_NAME);
                this.thread.setDaemon(true);
                this.thread.start();
            }
        }

        void stop() {
            if (this.diag_sock != null) {
                this.diag_sock.close();
            }
            if (this.thread != null) {
                try {
                    this.thread.join(300L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        public void run() {
            byte[] buf = new byte[1500];
            while (!this.diag_sock.isClosed() && Thread.currentThread().equals(this.thread)) {
                DatagramPacket packet = new DatagramPacket(buf, 0, buf.length);
                try {
                    this.diag_sock.receive(packet);
                    TP.this.handleDiagnosticProbe(packet.getSocketAddress(), this.diag_sock, new String(packet.getData(), packet.getOffset(), packet.getLength()));
                }
                catch (IOException iOException) {}
            }
        }

        private void bindToInterfaces(List interfaces, MulticastSocket s) {
            InetSocketAddress group_addr = new InetSocketAddress(TP.this.diagnostics_addr, TP.this.diagnostics_port);
            for (NetworkInterface i : interfaces) {
                try {
                    if (!i.getInetAddresses().hasMoreElements()) continue;
                    s.joinGroup(group_addr, i);
                    if (!TP.this.log.isTraceEnabled()) continue;
                    TP.this.log.trace((Object)("joined " + group_addr + " on " + i.getName()));
                }
                catch (IOException e) {
                    TP.this.log.warn((Object)("failed to join " + group_addr + " on " + i.getName() + ": " + e));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Bundler {
        static final int MIN_NUMBER_OF_BUNDLING_TASKS = 2;
        final Map<Address, List<Message>> msgs = new HashMap<Address, List<Message>>(36);
        long count = 0L;
        int num_msgs = 0;
        int num_bundling_tasks = 0;
        long last_bundle_time;
        final ReentrantLock lock = new ReentrantLock();

        private Bundler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void send(Message msg, Address dest) throws Exception {
            long length = msg.size();
            this.checkLength(length);
            Map<Address, List<Message>> bundled_msgs = null;
            this.lock.lock();
            try {
                if (this.count + length >= (long)TP.this.max_bundle_size) {
                    bundled_msgs = this.removeBundledMessages();
                }
                this.addMessage(msg, dest);
                this.count += length;
                if (this.num_bundling_tasks < 2) {
                    ++this.num_bundling_tasks;
                    TP.this.timer.schedule(new BundlingTimer(), TP.this.max_bundle_timeout, TimeUnit.MILLISECONDS);
                }
            }
            finally {
                this.lock.unlock();
            }
            if (bundled_msgs != null) {
                this.sendBundledMessages(bundled_msgs);
            }
        }

        private void addMessage(Message msg, Address dest) {
            List<Message> tmp;
            if (this.msgs.isEmpty()) {
                this.last_bundle_time = System.currentTimeMillis();
            }
            if ((tmp = this.msgs.get(dest)) == null) {
                tmp = new LinkedList<Message>();
                this.msgs.put(dest, tmp);
            }
            tmp.add(msg);
            ++this.num_msgs;
        }

        private Map<Address, List<Message>> removeBundledMessages() {
            if (this.msgs.isEmpty()) {
                return null;
            }
            HashMap<Address, List<Message>> copy = new HashMap<Address, List<Message>>(this.msgs);
            if (TP.this.log.isTraceEnabled()) {
                long stop = System.currentTimeMillis();
                double percentage = 100.0 / (double)TP.this.max_bundle_size * (double)this.count;
                StringBuilder sb = new StringBuilder("sending ").append(this.num_msgs).append(" msgs (");
                this.num_msgs = 0;
                sb.append(this.count).append(" bytes (" + f.format(percentage) + "% of max_bundle_size)");
                if (this.last_bundle_time > 0L) {
                    sb.append(", collected in ").append(stop - this.last_bundle_time).append("ms) ");
                }
                sb.append(" to ").append(copy.size()).append(" destination(s)");
                if (copy.size() > 1) {
                    sb.append(" (dests=").append(copy.keySet()).append(")");
                }
                TP.this.log.trace((Object)sb);
            }
            this.msgs.clear();
            this.count = 0L;
            return copy;
        }

        private void sendBundledMessages(Map<Address, List<Message>> msgs) {
            ExposedByteArrayOutputStream out_stream = new ExposedByteArrayOutputStream(1024);
            ExposedDataOutputStream dos = new ExposedDataOutputStream(out_stream);
            boolean first = true;
            for (Map.Entry<Address, List<Message>> entry : msgs.entrySet()) {
                List<Message> list = entry.getValue();
                if (list.isEmpty()) continue;
                Address dst = entry.getKey();
                boolean multicast = dst == null || dst.isMulticastAddress();
                try {
                    if (first) {
                        first = false;
                    } else {
                        out_stream.reset();
                        dos.reset();
                    }
                    TP.writeMessageList(list, dos, multicast);
                    Buffer buffer = new Buffer(out_stream.getRawBuffer(), 0, out_stream.size());
                    TP.this.doSend(buffer, dst, multicast);
                }
                catch (Throwable e) {
                    if (!TP.this.log.isErrorEnabled()) continue;
                    TP.this.log.error((Object)("exception sending msg: " + e.toString()), e.getCause());
                }
            }
        }

        private void checkLength(long len) throws Exception {
            if (len > (long)TP.this.max_bundle_size) {
                throw new Exception("message size (" + len + ") is greater than max bundling size (" + TP.this.max_bundle_size + "). Set the fragmentation/bundle size in FRAG and TP correctly");
            }
        }

        private class BundlingTimer
        implements Runnable {
            private BundlingTimer() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Map msgs = null;
                boolean unlocked = false;
                Bundler.this.lock.lock();
                try {
                    msgs = Bundler.this.removeBundledMessages();
                    if (msgs != null) {
                        Bundler.this.lock.unlock();
                        unlocked = true;
                        Bundler.this.sendBundledMessages(msgs);
                    }
                }
                finally {
                    if (unlocked) {
                        Bundler.this.lock.lock();
                    }
                    --Bundler.this.num_bundling_tasks;
                    Bundler.this.lock.unlock();
                }
            }
        }
    }

    class IncomingMessageHandler
    implements Runnable {
        public static final String THREAD_NAME = "IncomingMessageHandler";
        Thread t;

        IncomingMessageHandler() {
        }

        Thread getThread() {
            return this.t;
        }

        public void start() {
            if (this.t == null || !this.t.isAlive()) {
                this.t = new Thread(Util.getGlobalThreadGroup(), this, THREAD_NAME);
                this.t.setDaemon(true);
                this.t.start();
            }
        }

        public void stop() {
            TP.this.incoming_msg_queue.close(true);
            if (this.t != null) {
                try {
                    this.t.join(300L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        public void run() {
            while (!TP.this.incoming_msg_queue.closed() && Thread.currentThread().equals(this.t)) {
                try {
                    Message msg = (Message)TP.this.incoming_msg_queue.remove();
                    TP.this.handleIncomingMessage(msg);
                }
                catch (QueueClosedException closed_ex) {
                    break;
                }
                catch (Throwable ex) {
                    if (!TP.this.log.isErrorEnabled()) continue;
                    TP.this.log.error((Object)"error processing incoming message", ex);
                }
            }
            if (TP.this.log.isTraceEnabled()) {
                TP.this.log.trace((Object)"incoming message handler terminating");
            }
        }
    }

    class IncomingPacketHandler
    implements Runnable {
        public static final String THREAD_NAME = "IncomingPacketHandler";
        Thread t = null;

        IncomingPacketHandler() {
        }

        Thread getThread() {
            return this.t;
        }

        void start() {
            if (this.t == null || !this.t.isAlive()) {
                this.t = new Thread(Util.getGlobalThreadGroup(), this, THREAD_NAME);
                this.t.setDaemon(true);
                this.t.start();
            }
        }

        void stop() {
            TP.this.incoming_packet_queue.close(true);
            if (this.t != null) {
                try {
                    this.t.join(300L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        public void run() {
            while (!TP.this.incoming_packet_queue.closed() && Thread.currentThread().equals(this.t)) {
                try {
                    IncomingPacket entry = (IncomingPacket)TP.this.incoming_packet_queue.remove();
                    TP.this.handleIncomingPacket(entry.dest, entry.sender, entry.buf, entry.offset, entry.length);
                }
                catch (QueueClosedException closed_ex) {
                    break;
                }
                catch (Throwable ex) {
                    if (!TP.this.log.isErrorEnabled()) continue;
                    TP.this.log.error((Object)"error processing incoming packet", ex);
                }
            }
            if (TP.this.log.isTraceEnabled()) {
                TP.this.log.trace((Object)"incoming packet handler terminating");
            }
        }
    }

    class IncomingPacket
    implements Runnable {
        Address dest = null;
        Address sender = null;
        byte[] buf;
        int offset;
        int length;

        IncomingPacket(Address dest, Address sender, byte[] buf, int offset, int length) {
            this.dest = dest;
            this.sender = sender;
            this.buf = buf;
            this.offset = offset;
            this.length = length;
        }

        public void run() {
            block14: {
                short version = 0;
                ExposedByteArrayInputStream in_stream = null;
                DataInputStream dis = null;
                try {
                    boolean multicast;
                    byte flags;
                    in_stream = new ExposedByteArrayInputStream(this.buf, this.offset, this.length);
                    dis = new DataInputStream(in_stream);
                    try {
                        version = dis.readShort();
                    }
                    catch (IOException ex) {
                        if (TP.this.discard_incompatible_packets) {
                            return;
                        }
                        throw ex;
                    }
                    if (!Version.isBinaryCompatible(version)) {
                        if (TP.this.log.isWarnEnabled()) {
                            StringBuffer sb = new StringBuffer();
                            sb.append("packet from ").append(this.sender).append(" has different version (").append(Version.print(version));
                            sb.append(") from ours (").append(Version.printVersion()).append("). ");
                            if (TP.this.discard_incompatible_packets) {
                                sb.append("Packet is discarded");
                            } else {
                                sb.append("This may cause problems");
                            }
                            TP.this.log.warn((Object)sb);
                        }
                        if (TP.this.discard_incompatible_packets) {
                            return;
                        }
                    }
                    boolean is_message_list = ((flags = dis.readByte()) & 1) == 1;
                    boolean bl = multicast = (flags & 2) == 2;
                    if (is_message_list) {
                        List msgs = TP.this.readMessageList(dis, this.dest, multicast);
                        for (Message msg : msgs) {
                            if (msg.isFlagSet((byte)1)) {
                                TP.this.log.warn((Object)"bundled message should not be marked as OOB");
                            }
                            this.handleMyMessage(msg, multicast);
                        }
                    } else {
                        Message msg = TP.this.readMessage(dis, this.dest, this.sender, multicast);
                        this.handleMyMessage(msg, multicast);
                    }
                }
                catch (Throwable t) {
                    if (!TP.this.log.isErrorEnabled()) break block14;
                    TP.this.log.error((Object)"failed handling incoming message", t);
                }
            }
        }

        private void handleMyMessage(Message msg, boolean multicast) {
            if (TP.this.stats) {
                ++TP.this.num_msgs_received;
                TP.this.num_bytes_received += (long)msg.getLength();
            }
            Address src = msg.getSrc();
            if (TP.this.loopback && multicast && src != null && TP.this.local_addr.equals(src)) {
                return;
            }
            TpHeader hdr = (TpHeader)msg.getHeader(TP.this.name);
            if (hdr != null) {
                String ch_name = hdr.channel_name;
                if (TP.this.channel_name != null && !TP.this.channel_name.equals(ch_name)) {
                    if (TP.this.log.isWarnEnabled()) {
                        TP.this.log.warn((Object)new StringBuffer("discarded message from different group \"").append(ch_name).append("\" (our group is \"").append(TP.this.channel_name).append("\"). Sender was ").append(msg.getSrc()));
                    }
                    return;
                }
            } else {
                if (TP.this.log.isTraceEnabled()) {
                    TP.this.log.trace((Object)new StringBuffer("message does not have a transport header, msg is ").append(msg).append(", headers are ").append(msg.printHeaders()).append(", will be discarded"));
                }
                return;
            }
            Event evt = new Event(1, msg);
            if (TP.this.log.isTraceEnabled()) {
                StringBuffer sb = new StringBuffer("message is ").append(msg).append(", headers are ").append(msg.printHeaders());
                TP.this.log.trace((Object)sb);
            }
            TP.this.up_prot.up(evt);
        }
    }
}

