/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.contrib.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;

public class SVTableCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private static final Color black = SVTableCellEditor.getAWTColor(new HSSFColor.BLACK());
    private static final Color white = SVTableCellEditor.getAWTColor(new HSSFColor.WHITE());
    private Hashtable colors = HSSFColor.getIndexHash();
    private HSSFWorkbook wb;
    private JTextField editor;
    private HSSFCell editorValue;

    public SVTableCellEditor(HSSFWorkbook wb) {
        this.wb = wb;
        this.editor = new JTextField();
    }

    public boolean isCellEditable(EventObject e) {
        if (e instanceof MouseEvent) {
            return ((MouseEvent)e).getClickCount() >= 2;
        }
        return false;
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public boolean startCellEditing(EventObject anEvent) {
        System.out.println("Start Cell Editing");
        return true;
    }

    public boolean stopCellEditing() {
        System.out.println("Stop Cell Editing");
        this.fireEditingStopped();
        return true;
    }

    public void cancelCellEditing() {
        System.out.println("Cancel Cell Editing");
        this.fireEditingCanceled();
    }

    public void actionPerformed(ActionEvent e) {
        System.out.println("Action performed");
        this.stopCellEditing();
    }

    public Object getCellEditorValue() {
        System.out.println("GetCellEditorValue");
        return this.editor.getText();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        System.out.println("GetTableCellEditorComponent");
        HSSFCell cell = (HSSFCell)value;
        if (cell != null) {
            int fontheight;
            HSSFCellStyle style = cell.getCellStyle();
            HSSFFont f = this.wb.getFontAt(style.getFontIndex());
            boolean isbold = f.getBoldweight() > 400;
            boolean isitalics = f.getItalic();
            int fontstyle = 0;
            if (isbold) {
                fontstyle = 1;
            }
            if (isitalics) {
                fontstyle |= 2;
            }
            if ((fontheight = f.getFontHeightInPoints()) == 9) {
                fontheight = 10;
            }
            Font font = new Font(f.getFontName(), fontstyle, fontheight);
            this.editor.setFont(font);
            if (style.getFillPattern() == 1) {
                this.editor.setBackground(this.getAWTColor(style.getFillForegroundColor(), white));
            } else {
                this.editor.setBackground(white);
            }
            this.editor.setForeground(this.getAWTColor(f.getColor(), black));
            switch (cell.getCellType()) {
                case 3: {
                    this.editor.setText("");
                    break;
                }
                case 4: {
                    if (cell.getBooleanCellValue()) {
                        this.editor.setText("true");
                        break;
                    }
                    this.editor.setText("false");
                    break;
                }
                case 0: {
                    this.editor.setText(Double.toString(cell.getNumericCellValue()));
                    break;
                }
                case 1: {
                    this.editor.setText(cell.getRichStringCellValue().getString());
                    break;
                }
                default: {
                    this.editor.setText("?");
                }
            }
            switch (style.getAlignment()) {
                case 1: 
                case 4: 
                case 5: {
                    this.editor.setHorizontalAlignment(2);
                    break;
                }
                case 2: 
                case 6: {
                    this.editor.setHorizontalAlignment(0);
                    break;
                }
                case 0: 
                case 3: {
                    this.editor.setHorizontalAlignment(4);
                    break;
                }
                default: {
                    this.editor.setHorizontalAlignment(2);
                }
            }
        }
        return this.editor;
    }

    private final Color getAWTColor(int index, Color deflt) {
        HSSFColor clr = (HSSFColor)this.colors.get(new Integer(index));
        if (clr == null) {
            return deflt;
        }
        return SVTableCellEditor.getAWTColor(clr);
    }

    private static final Color getAWTColor(HSSFColor clr) {
        short[] rgb = clr.getTriplet();
        return new Color(rgb[0], rgb[1], rgb[2]);
    }
}

