/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.console.security;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileManager {
    private Map<String, Collection<String>> profilesMap = new HashMap<String, Collection<String>>();

    public void addProfile(String id, String profile) {
        if (!this.profilesMap.containsKey(id)) {
            this.profilesMap.put(id, new HashSet());
        }
        this.profilesMap.get(id).add(profile);
    }

    public void addProfiles(String id, Collection<String> profiles) {
        if (!this.profilesMap.containsKey(id)) {
            this.profilesMap.put(id, profiles);
        } else {
            this.profilesMap.get(id).addAll(profiles);
        }
    }

    public void removeProfiles(String id, Collection<String> profiles) {
        if (this.profilesMap.containsKey(id)) {
            this.profilesMap.get(id).removeAll(profiles);
        }
    }

    public Collection<String> getProfiles(String userName) {
        PortalContainer portalContainer = PortalContainer.getInstance();
        OrganizationService organisationService = (OrganizationService)portalContainer.getComponentInstanceOfType(OrganizationService.class);
        Collection userMemberships = null;
        try {
            userMemberships = organisationService.getMembershipHandler().findMembershipsByUser(userName);
        }
        catch (Exception e) {
            System.err.println("Impossible to get the memberships list");
        }
        HashSet<String> profiles = new HashSet<String>();
        if (userMemberships != null) {
            for (Membership membership : userMemberships) {
                String id = membership.getMembershipType() + ":" + membership.getGroupId();
                if (this.profilesMap.get(id) == null) continue;
                profiles.addAll(this.profilesMap.get(id));
            }
        }
        return profiles;
    }

    public Collection<String> getProfilesById(String id) {
        return this.profilesMap.get(id);
    }

    public void commit() {
    }
}

