/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.query.InvalidQueryException;
import org.apache.commons.logging.Log;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeType;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.query.AndQueryNode;
import org.exoplatform.services.jcr.impl.core.query.DerefQueryNode;
import org.exoplatform.services.jcr.impl.core.query.ExactQueryNode;
import org.exoplatform.services.jcr.impl.core.query.LocationStepQueryNode;
import org.exoplatform.services.jcr.impl.core.query.NodeTypeQueryNode;
import org.exoplatform.services.jcr.impl.core.query.NotQueryNode;
import org.exoplatform.services.jcr.impl.core.query.OrQueryNode;
import org.exoplatform.services.jcr.impl.core.query.OrderQueryNode;
import org.exoplatform.services.jcr.impl.core.query.PathQueryNode;
import org.exoplatform.services.jcr.impl.core.query.QueryNode;
import org.exoplatform.services.jcr.impl.core.query.QueryNodeVisitor;
import org.exoplatform.services.jcr.impl.core.query.QueryRootNode;
import org.exoplatform.services.jcr.impl.core.query.RelationQueryNode;
import org.exoplatform.services.jcr.impl.core.query.TextsearchQueryNode;
import org.exoplatform.services.jcr.impl.core.query.lucene.ChildAxisQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.DateField;
import org.exoplatform.services.jcr.impl.core.query.lucene.DerefQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.DescendantSelfAxisQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.DoubleField;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.LongField;
import org.exoplatform.services.jcr.impl.core.query.lucene.MatchAllQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.NotQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.RangeQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.WildcardQuery;
import org.exoplatform.services.jcr.impl.dataflow.session.WorkspaceStorageDataManagerProxy;
import org.exoplatform.services.log.ExoLogger;

public class LuceneQueryBuilder
implements QueryNodeVisitor {
    private static Log log = ExoLogger.getLogger((String)"jcr.LuceneQueryBuilder");
    private static InternalQName primaryType = Constants.JCR_PRIMARYTYPE;
    private static InternalQName mixinTypes = Constants.JCR_MIXINTYPES;
    private QueryRootNode root;
    private SessionImpl session;
    private WorkspaceStorageDataManagerProxy sharedItemMgr;
    private LocationFactory sysLocationFactory;
    private Analyzer analyzer;
    private List exceptions = new ArrayList();

    private LuceneQueryBuilder(QueryRootNode root, SessionImpl session, LocationFactory sysLocationFactory, Analyzer analyzer) {
        this.root = root;
        this.session = session;
        this.sysLocationFactory = sysLocationFactory;
        this.sharedItemMgr = session.getTransientNodesManager().getWorkspaceDataManager();
        this.analyzer = analyzer;
    }

    public static Query createQuery(QueryRootNode root, SessionImpl session, LocationFactory sysLocationFactory, Analyzer analyzer) throws RepositoryException {
        LuceneQueryBuilder builder = new LuceneQueryBuilder(root, session, sysLocationFactory, analyzer);
        Query q = builder.createLuceneQuery();
        if (builder.exceptions.size() > 0) {
            StringBuffer msg = new StringBuffer();
            Iterator it = builder.exceptions.iterator();
            while (it.hasNext()) {
                msg.append(it.next().toString()).append('\n');
            }
            throw new RepositoryException("Exception building query: " + msg.toString());
        }
        return q;
    }

    private Query createLuceneQuery() {
        return (Query)this.root.accept(this, null);
    }

    public Object visit(QueryRootNode node, Object data) {
        BooleanQuery root = new BooleanQuery();
        log.debug((Object)("Visit QueryRootNode: " + node));
        BooleanQuery wrapped = root;
        if (node.getLocationNode() != null) {
            wrapped = (Query)node.getLocationNode().accept(this, root);
        }
        return wrapped;
    }

    public Object visit(OrQueryNode node, Object data) {
        BooleanQuery orQuery = new BooleanQuery();
        Object[] result = node.acceptOperands(this, null);
        for (int i = 0; i < result.length; ++i) {
            Query operand = (Query)result[i];
            orQuery.add(operand, false, false);
        }
        return orQuery;
    }

    public Object visit(AndQueryNode node, Object data) {
        Object[] result = node.acceptOperands(this, null);
        if (result.length == 0) {
            return null;
        }
        BooleanQuery andQuery = new BooleanQuery();
        for (int i = 0; i < result.length; ++i) {
            Query operand = (Query)result[i];
            andQuery.add(operand, true, false);
        }
        return andQuery;
    }

    public Object visit(NotQueryNode node, Object data) {
        Object[] result = node.acceptOperands(this, null);
        if (result.length == 0) {
            return data;
        }
        BooleanQuery b = new BooleanQuery();
        for (int i = 0; i < result.length; ++i) {
            b.add((Query)result[i], false, false);
        }
        return new NotQuery((Query)b);
    }

    public Object visit(ExactQueryNode node, Object data) {
        String field = "";
        String value = "";
        try {
            field = this.sysLocationFactory.createJCRName(node.getPropertyName()).getAsString();
            value = this.sysLocationFactory.createJCRName(node.getValue()).getAsString();
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        return new TermQuery(new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, value)));
    }

    public Object visit(NodeTypeQueryNode node, Object data) {
        String field = "";
        ArrayList<String> values = new ArrayList<String>();
        try {
            String nodeTypeName = this.sysLocationFactory.createJCRName(node.getValue()).getAsString();
            InternalQName ntQName = this.sysLocationFactory.createJCRName(node.getValue()).getInternalName();
            values.add(nodeTypeName);
            NodeTypeManagerImpl ntMgr = this.session.getWorkspace().getNodeTypeManager();
            ExtendedNodeType base = ntMgr.getNodeType(ntQName);
            field = base.isMixin() ? this.sysLocationFactory.createJCRName(mixinTypes).getAsString() : this.sysLocationFactory.createJCRName(primaryType).getAsString();
            NodeTypeIterator allTypes = ntMgr.getAllNodeTypes();
            while (allTypes.hasNext()) {
                NodeType nt = allTypes.nextNodeType();
                NodeType[] superTypes = nt.getSupertypes();
                if (!Arrays.asList(superTypes).contains(base)) continue;
                values.add(nt.getName());
            }
        }
        catch (RepositoryException e) {
            this.exceptions.add(e);
        }
        if (values.size() == 0) {
            return new BooleanQuery();
        }
        if (values.size() == 1) {
            Term t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, (String)values.get(0)));
            return new TermQuery(t);
        }
        BooleanQuery b = new BooleanQuery();
        Iterator it = values.iterator();
        while (it.hasNext()) {
            Term t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, (String)it.next()));
            b.add((Query)new TermQuery(t), false, false);
        }
        return b;
    }

    public Object visit(TextsearchQueryNode node, Object data) {
        try {
            String fieldname;
            if (node.getPropertyName() == null) {
                fieldname = FieldNames.FULLTEXT;
            } else {
                StringBuffer tmp = new StringBuffer();
                tmp.append(this.sysLocationFactory.createJCRName(node.getPropertyName()).getPrefix());
                tmp.append(":").append("FULL:");
                tmp.append(node.getPropertyName().getName());
                fieldname = tmp.toString();
            }
            QueryParser parser = new QueryParser(fieldname, this.analyzer);
            parser.setOperator(1);
            StringBuffer query = new StringBuffer();
            String textsearch = node.getQuery();
            textsearch = textsearch.replaceAll("AND", "and");
            textsearch = textsearch.replaceAll("NOT", "not");
            boolean escaped = false;
            for (int i = 0; i < textsearch.length(); ++i) {
                if (textsearch.charAt(i) == '\\') {
                    if (escaped) {
                        query.append("\\\\");
                        escaped = false;
                        continue;
                    }
                    escaped = true;
                    continue;
                }
                if (textsearch.charAt(i) == '\'') {
                    if (escaped) {
                        query.append('\'');
                        escaped = false;
                        continue;
                    }
                    query.append('\"');
                    continue;
                }
                if (escaped) {
                    query.append('\\');
                    escaped = false;
                }
                query.append(textsearch.charAt(i));
            }
            return parser.parse(query.toString());
        }
        catch (NamespaceException e) {
            this.exceptions.add(e);
        }
        catch (ParseException e) {
            this.exceptions.add(e);
        }
        catch (RepositoryException e) {
            this.exceptions.add(e);
        }
        return null;
    }

    public Object visit(PathQueryNode node, Object data) {
        BooleanQuery constraint;
        TermQuery context = null;
        LocationStepQueryNode[] steps = node.getPathSteps();
        log.debug((Object)("PathQueryNode visited: absolute: " + node.isAbsolute() + " steps: " + steps.length));
        if (steps.length > 0) {
            if (node.isAbsolute() && !steps[0].getIncludeDescendants()) {
                InternalQName nameTest = steps[0].getNameTest();
                if (nameTest == null) {
                    context = new TermQuery(new Term(FieldNames.PARENT, ""));
                } else if (nameTest.getName().length() == 0) {
                    context = new TermQuery(new Term(FieldNames.PARENT, ""));
                } else {
                    String name = "";
                    try {
                        name = this.sysLocationFactory.createJCRName(nameTest).getAsString();
                    }
                    catch (RepositoryException e) {
                        this.exceptions.add(e);
                    }
                    BooleanQuery and = new BooleanQuery();
                    and.add((Query)new TermQuery(new Term(FieldNames.PARENT, "00exo0jcr0root0uuid0000000000000")), true, false);
                    and.add((Query)new TermQuery(new Term(FieldNames.LABEL, name)), true, false);
                    context = and;
                }
                LocationStepQueryNode[] tmp = new LocationStepQueryNode[steps.length - 1];
                System.arraycopy(steps, 1, tmp, 0, steps.length - 1);
                steps = tmp;
            } else {
                context = new TermQuery(new Term(FieldNames.PARENT, ""));
            }
        } else {
            this.exceptions.add(new InvalidQueryException("Number of location steps must be > 0"));
        }
        log.debug((Object)("PathQueryNode visited: context: " + context + " steps: " + steps.length));
        for (int i = 0; i < steps.length; ++i) {
            context = (Query)steps[i].accept(this, context);
        }
        if (data instanceof BooleanQuery && (constraint = (BooleanQuery)data).getClauses().length > 0) {
            constraint.add((Query)context, true, false);
            context = constraint;
        }
        return context;
    }

    public Object visit(LocationStepQueryNode node, Object data) {
        Query context = (Query)data;
        BooleanQuery andQuery = new BooleanQuery();
        if (context == null) {
            this.exceptions.add(new IllegalArgumentException("Unsupported query"));
        }
        Object[] predicates = node.acceptOperands(this, data);
        for (int i = 0; i < predicates.length; ++i) {
            andQuery.add((Query)predicates[i], true, false);
        }
        QueryNode[] pred = node.getPredicates();
        for (int i = 0; i < pred.length; ++i) {
            RelationQueryNode pos;
            if (pred[i].getType() != 2 || (pos = (RelationQueryNode)pred[i]).getValueType() != 6) continue;
            node.setIndex(pos.getPositionValue());
        }
        TermQuery nameTest = null;
        if (node.getNameTest() != null) {
            try {
                String internalName = this.sysLocationFactory.createJCRName(node.getNameTest()).getAsString();
                nameTest = new TermQuery(new Term(FieldNames.LABEL, internalName));
            }
            catch (RepositoryException e) {
                this.exceptions.add(e);
            }
        }
        log.debug((Object)("LocationStepQueryNode visited: nameTest: " + nameTest + " predicates: " + predicates.length + " includeDesc: " + node.getIncludeDescendants()));
        if (node.getIncludeDescendants()) {
            if (nameTest != null) {
                andQuery.add((Query)new DescendantSelfAxisQuery(context, (Query)nameTest), true, false);
            } else if (predicates.length > 0) {
                PathQueryNode pathNode = (PathQueryNode)node.getParent();
                if (pathNode.getPathSteps()[0] != node) {
                    DescendantSelfAxisQuery subQuery = new DescendantSelfAxisQuery(context, (Query)andQuery, false);
                    andQuery = new BooleanQuery();
                    andQuery.add((Query)subQuery, true, false);
                    log.debug((Object)("LocationStepQueryNode visited: subquery " + subQuery.toString() + " context: " + context + " andQuery: " + andQuery));
                }
            } else {
                MatchAllQuery subQuery = null;
                try {
                    subQuery = new MatchAllQuery(this.sysLocationFactory.createJCRName(primaryType).getAsString());
                }
                catch (RepositoryException e) {
                    log.error((Object)("Error: " + (Object)((Object)e)));
                }
                log.debug((Object)("LocationStepQueryNode visited: subquery " + subQuery.toString() + " context: " + context + " andQuery: " + andQuery));
                PathQueryNode pathNode = (PathQueryNode)node.getParent();
                if (pathNode.getPathSteps()[0] != node) {
                    context = new DescendantSelfAxisQuery(context, subQuery);
                    andQuery.add((Query)new ChildAxisQuery(this.sharedItemMgr, context, null, node.getIndex()), true, false);
                } else {
                    andQuery.add((Query)subQuery, true, false);
                }
            }
        } else {
            log.debug((Object)("Add ChildAxisQuery: " + node.getIndex() + " " + nameTest));
            if (nameTest != null) {
                andQuery.add((Query)new ChildAxisQuery(this.sharedItemMgr, context, nameTest.getTerm().text(), node.getIndex()), true, false);
            } else {
                andQuery.add((Query)new ChildAxisQuery(this.sharedItemMgr, context, null, node.getIndex()), true, false);
            }
        }
        return andQuery;
    }

    public Object visit(DerefQueryNode node, Object data) {
        Query context = (Query)data;
        if (context == null) {
            this.exceptions.add(new IllegalArgumentException("Unsupported query"));
        }
        try {
            String refProperty = this.sysLocationFactory.createJCRName(node.getRefProperty()).getAsString();
            String nameTest = null;
            if (node.getNameTest() != null) {
                nameTest = this.sysLocationFactory.createJCRName(node.getNameTest()).getAsString();
            }
            return new DerefQuery(context, refProperty, nameTest);
        }
        catch (RepositoryException e) {
            this.exceptions.add(e);
            return context;
        }
    }

    public Object visit(RelationQueryNode node, Object data) {
        Query query;
        String[] stringValues = new String[1];
        log.debug((Object)("RelationQueryNode visited:  value type:" + node.getValueType() + " operation: " + node.getOperation()));
        switch (node.getValueType()) {
            case 0: {
                break;
            }
            case 4: {
                stringValues[0] = DateField.dateToString(node.getDateValue());
                break;
            }
            case 2: {
                stringValues[0] = DoubleField.doubleToString(node.getDoubleValue());
                break;
            }
            case 1: {
                stringValues[0] = LongField.longToString(node.getLongValue());
                break;
            }
            case 3: {
                if (node.getOperation() == 12 || node.getOperation() == 11 || node.getOperation() == 14 || node.getOperation() == 13) {
                    stringValues = this.getStringValues(node.getProperty(), node.getStringValue());
                    break;
                }
                stringValues[0] = node.getStringValue();
                break;
            }
            case 6: {
                log.debug((Object)"RelationQueryNode visited:  TYPE_POSITION ignore");
                return null;
            }
            default: {
                throw new IllegalArgumentException("Unknown relation type: " + node.getValueType());
            }
        }
        if (node.getProperty() == null) {
            this.exceptions.add(new InvalidQueryException("@* not supported in predicate"));
            return data;
        }
        String field = "";
        try {
            field = this.sysLocationFactory.createJCRName(node.getProperty()).getAsString();
        }
        catch (RepositoryException e) {
            this.exceptions.add(e);
        }
        switch (node.getOperation()) {
            case 11: 
            case 12: {
                BooleanQuery or = new BooleanQuery();
                for (int i = 0; i < stringValues.length; ++i) {
                    or.add((Query)new TermQuery(new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]))), false, false);
                }
                query = or;
                if (node.getOperation() != 11) break;
                query = this.createSingleValueConstraint((Query)or, field);
                break;
            }
            case 19: 
            case 20: {
                BooleanQuery or = new BooleanQuery();
                for (int i = 0; i < stringValues.length; ++i) {
                    Term lower = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                    Term upper = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, "\uffff"));
                    or.add((Query)new RangeQuery(lower, upper, true), false, false);
                }
                query = or;
                if (node.getOperation() != 19) break;
                query = this.createSingleValueConstraint((Query)or, field);
                break;
            }
            case 17: 
            case 18: {
                BooleanQuery or = new BooleanQuery();
                for (int i = 0; i < stringValues.length; ++i) {
                    Term lower = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                    Term upper = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, "\uffff"));
                    or.add((Query)new RangeQuery(lower, upper, false), false, false);
                }
                query = or;
                if (node.getOperation() != 17) break;
                query = this.createSingleValueConstraint((Query)or, field);
                break;
            }
            case 21: 
            case 22: {
                BooleanQuery or = new BooleanQuery();
                for (int i = 0; i < stringValues.length; ++i) {
                    Term lower = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, ""));
                    Term upper = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                    or.add((Query)new RangeQuery(lower, upper, true), false, false);
                }
                query = or;
                if (node.getOperation() != 21) break;
                query = this.createSingleValueConstraint(query, field);
                break;
            }
            case 23: {
                if (stringValues[0].equals("%")) {
                    query = new MatchAllQuery(field);
                    break;
                }
                query = new WildcardQuery(FieldNames.PROPERTIES, field, stringValues[0]);
                break;
            }
            case 15: 
            case 16: {
                BooleanQuery or = new BooleanQuery();
                for (int i = 0; i < stringValues.length; ++i) {
                    Term lower = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, ""));
                    Term upper = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                    or.add((Query)new RangeQuery(lower, upper, false), false, false);
                }
                query = or;
                if (node.getOperation() != 15) break;
                query = this.createSingleValueConstraint((Query)or, field);
                break;
            }
            case 13: {
                BooleanQuery notQuery = new BooleanQuery();
                notQuery.add((Query)new MatchAllQuery(field), false, false);
                for (int i = 0; i < stringValues.length; ++i) {
                    Term t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                    notQuery.add((Query)new TermQuery(t), false, true);
                }
                notQuery.add((Query)new TermQuery(new Term(FieldNames.MVP, field)), false, true);
                query = notQuery;
                break;
            }
            case 14: {
                BooleanQuery notQuery = new BooleanQuery();
                notQuery.add((Query)new MatchAllQuery(field), false, false);
                for (int i = 0; i < stringValues.length; ++i) {
                    Term t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                    NotQuery svp = new NotQuery((Query)new TermQuery(new Term(FieldNames.MVP, field)));
                    BooleanQuery and = new BooleanQuery();
                    and.add((Query)new TermQuery(t), true, false);
                    and.add((Query)svp, true, false);
                    notQuery.add((Query)and, false, true);
                }
                query = notQuery;
                break;
            }
            case 26: {
                query = new NotQuery(new MatchAllQuery(field));
                break;
            }
            case 27: {
                query = new MatchAllQuery(field);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown relation operation: " + node.getOperation());
            }
        }
        return query;
    }

    public Object visit(OrderQueryNode node, Object data) {
        return data;
    }

    private Query createSingleValueConstraint(Query q, String propName) {
        TermQuery mvp = new TermQuery(new Term(FieldNames.MVP, propName));
        NotQuery svp = new NotQuery((Query)mvp);
        BooleanQuery and = new BooleanQuery();
        and.add(q, true, false);
        and.add((Query)svp, true, false);
        return and;
    }

    private String[] getStringValues(InternalQName propertyName, String literal) {
        ArrayList<String> values = new ArrayList<String>();
        if (values.size() == 0) {
            values.add(literal);
            log.debug((Object)("Using literal " + literal + " as is."));
        }
        return values.toArray(new String[values.size()]);
    }
}

