/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene.fulltext;

import java.io.IOException;
import org.exoplatform.services.jcr.impl.core.query.lucene.fulltext.CharStream;

public final class FastCharStream
implements CharStream {
    private int position;
    private int tokenStart;
    private String input;

    public FastCharStream(String input) {
        this.input = input;
    }

    public char readChar() throws IOException {
        if (this.position >= this.input.length()) {
            throw new IOException("read past eof");
        }
        return this.input.charAt(this.position++);
    }

    public char BeginToken() throws IOException {
        this.tokenStart = this.position;
        return this.readChar();
    }

    public void backup(int amount) {
        this.position -= amount;
    }

    public String GetImage() {
        return this.input.substring(this.tokenStart, this.position);
    }

    public char[] GetSuffix(int len) {
        char[] value = new char[len];
        for (int i = 0; i < len; ++i) {
            value[i] = this.input.charAt(this.position - len + i);
        }
        return value;
    }

    public void Done() {
    }

    public int getColumn() {
        return this.position;
    }

    public int getLine() {
        return 1;
    }

    public int getEndColumn() {
        return this.position;
    }

    public int getEndLine() {
        return 1;
    }

    public int getBeginColumn() {
        return this.tokenStart;
    }

    public int getBeginLine() {
        return 1;
    }
}

