/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.html.parser;

import java.util.List;
import org.exoplatform.services.html.HTMLNode;
import org.exoplatform.services.html.Name;
import org.exoplatform.services.html.Tag;
import org.exoplatform.services.html.parser.HTML;
import org.exoplatform.services.html.parser.NodeImpl;
import org.exoplatform.services.html.parser.ParserService;

final class NodeSetter {
    NodeSetter() {
    }

    void add(NodeImpl node) {
        List<HTMLNode> children;
        if (node.getConfig().only()) {
            this.set(node);
            return;
        }
        NodeImpl parent = ParserService.getNodeCreator().getOpenParent(node.getConfig(), true);
        if (parent != null && parent.getConfig().end() == Tag.OPTIONAL && HTML.isEndType(node, parent.getConfig())) {
            ParserService.getNodeCloser().close(parent);
            parent = ParserService.getNodeCreator().getOpenParent(node.getConfig(), true);
        }
        if ((children = parent.getChildren()).size() > 0) {
            ParserService.getNodeCloser().close((NodeImpl)children.get(children.size() - 1));
        }
        this.add(parent, node);
        if (node.getConfig().end() != Tag.FORBIDDEN && node.isOpen()) {
            ParserService.getNodeCreator().getOpens().add(node);
        }
    }

    HTMLNode add(HTMLNode node, HTMLNode ele) {
        ele.setParent(node);
        node.addChild(ele);
        if (ele.getConfig().end() != Tag.FORBIDDEN) {
            return ele;
        }
        return node;
    }

    NodeImpl set(NodeImpl node) {
        if (node.getName() == Name.HTML) {
            return ParserService.getRootNode();
        }
        List<HTMLNode> children = ParserService.getRootNode().getChildren();
        for (HTMLNode ele : children) {
            if (ele.getConfig().name() != node.getConfig().name()) continue;
            ele.setValue(node.getValue());
            return (NodeImpl)ele;
        }
        if (node.getName() == Name.BODY) {
            this.add(ParserService.getRootNode(), node);
            ParserService.getNodeCreator().getOpens().add(1, node);
            return node;
        }
        children.add(0, node);
        node.setParent(ParserService.getRootNode());
        node.setIsOpen(false);
        return node;
    }
}

