/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.form.UIFormInputBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="system:/groovy/webui/form/UIFormUploadInput.gtmpl")
public class UIFormUploadInput
extends UIFormInputBase<String> {
    private String uploadId_ = Integer.toString(Math.abs(this.hashCode()));
    private UploadResource uploadResource_;

    public UIFormUploadInput(String name, String bindingExpression) {
        super(name, bindingExpression, String.class);
        this.setComponentConfig(UIFormUploadInput.class, null);
    }

    @Override
    public void decode(Object input, WebuiRequestContext context) throws Exception {
        this.uploadResource_ = null;
        boolean hasUpload = "true".equals(input);
        if (hasUpload) {
            UploadService service = this.getApplicationComponent(UploadService.class);
            this.uploadResource_ = service.getUploadResource(this.uploadId_);
            System.out.println("upload stores at " + this.uploadResource_.getStoreLocation());
        }
    }

    public InputStream getUploadDataAsStream() throws Exception {
        if (this.uploadResource_ == null) {
            return null;
        }
        File file = new File(this.uploadResource_.getStoreLocation());
        return new FileInputStream(file);
    }

    public byte[] getUploadData() throws Exception {
        if (this.uploadResource_ == null) {
            return null;
        }
        File file = new File(this.uploadResource_.getStoreLocation());
        FileInputStream inputStream = new FileInputStream(file);
        FileChannel fchan = inputStream.getChannel();
        long fsize = fchan.size();
        ByteBuffer buff = ByteBuffer.allocate((int)fsize);
        fchan.read(buff);
        buff.rewind();
        byte[] data = buff.array();
        buff.clear();
        fchan.close();
        inputStream.close();
        return data;
    }

    public String getUploadId() {
        return this.uploadId_;
    }

    public String getActionUpload() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        WebuiRequestContext pcontext = (WebuiRequestContext)context.getParentAppRequestContext();
        if (pcontext == null) {
            pcontext = context;
        }
        String uploadAction = pcontext.getRequestContextPath() + "/command?";
        uploadAction = uploadAction + "type=org.exoplatform.web.command.handler.UploadHandler";
        uploadAction = uploadAction + "&uploadId=" + this.uploadId_ + "&action=upload";
        return uploadAction;
    }

    public UploadResource getUploadResource() {
        return this.uploadResource_;
    }
}

