/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.javascript;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import org.exoplatform.resolver.ResourceResolver;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptEngine {
    public Script loadScript(ResourceResolver resolver, String url, boolean reload) throws Exception {
        return this.loadScript(resolver, url);
    }

    public Script loadTemplate(ResourceResolver resolver, String url, boolean reload) throws Exception {
        return this.loadTemplate(resolver, url);
    }

    public Script loadScript(ResourceResolver resolver, String url) throws Exception {
        InputStream is = resolver.getInputStream(url);
        InputStreamReader reader = new InputStreamReader(is);
        Script script = this.compileScript(url, reader);
        return script;
    }

    public Script loadTemplate(ResourceResolver resolver, String url) throws Exception {
        String template = new String(resolver.getResourceContentAsBytes(url));
        Script script = this.compileTemplate(url, template);
        return script;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runScript(Script script, Map<String, Object> context) throws Exception {
        Context cx = Context.enter();
        try {
            cx.setApplicationClassLoader(Thread.currentThread().getContextClassLoader());
            ScriptableObject scope = cx.initStandardObjects();
            for (Map.Entry<String, Object> entry : context.entrySet()) {
                scope.put(entry.getKey(), (Scriptable)scope, entry.getValue());
            }
            script.exec(cx, (Scriptable)scope);
        }
        finally {
            Context.exit();
        }
    }

    public void merge(Script template, Map<String, Object> context, Writer out) throws Exception {
        context.put("_w", out);
        this.runScript(template, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Script compileScript(String name, String script) throws Exception {
        Context cx = Context.enter();
        try {
            Script scriptObject;
            cx.setApplicationClassLoader(Thread.currentThread().getContextClassLoader());
            Script script2 = scriptObject = cx.compileString(script, name, 1, null);
            return script2;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Script compileScript(String name, Reader reader) throws Exception {
        Context cx = Context.enter();
        try {
            Script scriptObject;
            cx.setApplicationClassLoader(Thread.currentThread().getContextClassLoader());
            Script script = scriptObject = cx.compileReader(reader, name, 1, null);
            return script;
        }
        finally {
            Context.exit();
        }
    }

    public Script compileTemplate(String name, String template) throws Exception {
        String[] lines;
        String tmp;
        char[] buf = template.toCharArray();
        StringBuilder script = new StringBuilder(10000);
        StringBuilder text = new StringBuilder(1500);
        StringBuilder code = new StringBuilder(1500);
        int pos = 0;
        boolean codeBlock = false;
        boolean codeBlockReturn = false;
        while (pos < buf.length) {
            if (buf[pos] == '\r') {
                ++pos;
                continue;
            }
            if (buf[pos] == '<' && buf[pos + 1] == '%') {
                codeBlockReturn = false;
                if (buf[++pos + 1] == '=') {
                    ++pos;
                    codeBlockReturn = true;
                }
                codeBlock = true;
                if (text.length() > 0) {
                    tmp = text.toString();
                    if (tmp.length() > 0) {
                        lines = tmp.split("\n");
                        for (int i = 0; i < lines.length; ++i) {
                            if (i != lines.length - 1) {
                                script.append("_w.append(\"").append(lines[i]).append("\\n\"); \n");
                                continue;
                            }
                            script.append("_w.append(\"").append(lines[i]).append("\"); \n");
                        }
                    }
                    text.setLength(0);
                }
            } else if (buf[pos] == '%' && buf[pos + 1] == '>') {
                ++pos;
                codeBlock = false;
                if (codeBlockReturn) {
                    script.append("\n_w.append(").append((CharSequence)code).append("); \n");
                } else {
                    script.append((CharSequence)code).append('\n');
                }
                code.setLength(0);
            } else if (codeBlock) {
                code.append(buf[pos]);
            } else {
                if (buf[pos] == '\"') {
                    text.append('\\');
                }
                text.append(buf[pos]);
            }
            ++pos;
        }
        if (text.length() > 0 && (tmp = text.toString()).length() > 0) {
            for (String line : lines = tmp.split("\n")) {
                script.append("_w.append(\"").append(line).append("\\n\"); \n");
            }
        }
        return this.compileScript(name, script.toString());
    }
}

