/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import java.io.IOException;
import java.net.URLDecoder;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.portal.webui.skin.SkinService;
import org.exoplatform.services.log.ExoLogger;

public class ResourceRequestFilter
implements Filter {
    protected static Log log = ExoLogger.getLogger((String)"portal:ResourceRequestFilter");
    private boolean cacheResource_ = false;

    public void init(FilterConfig filterConfig) {
        this.cacheResource_ = !"true".equals(System.getProperty("exo.product.developing"));
        log.info((Object)("Cache eXo Resource at client: " + this.cacheResource_));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String uri = URLDecoder.decode(httpRequest.getRequestURI(), "UTF-8");
        if (this.cacheResource_) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            if (uri.endsWith(".css")) {
                httpResponse.setHeader("Cache-Control", "no-cache");
                RootContainer rootContainer = RootContainer.getInstance();
                PortalContainer portalContainer = rootContainer.getPortalContainer("portal");
                SkinService skinService = (SkinService)portalContainer.getComponentInstanceOfType(SkinService.class);
                String mergedCSS = skinService.getMergedCSS(uri);
                if (mergedCSS != null) {
                    log.info((Object)("Use a merged CSS: " + uri));
                    response.getWriter().print(mergedCSS);
                    return;
                }
            } else {
                httpResponse.addHeader("Cache-Control", "max-age=2592000,s-maxage=2592000");
            }
        } else {
            if (uri.endsWith(".jstmpl") || uri.endsWith(".css") || uri.endsWith(".js")) {
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                httpResponse.setHeader("Cache-Control", "no-cache");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(" Load Resource: " + uri));
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

