/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.json;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import org.exoplatform.json.ArrayToJSONPlugin;
import org.exoplatform.json.BeanToJSONPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectToJSONPlugin
extends BeanToJSONPlugin<Object> {
    @Override
    public void toJSONScript(Object object, StringBuilder builder, int indentLevel) throws Exception {
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            Object[] array = new Object[collection.size()];
            collection.toArray(array);
            object = array;
        }
        this.appendIndentation(builder, indentLevel);
        builder.append('{').append('\n');
        if (object.getClass().isArray()) {
            ArrayToJSONPlugin arrayToJSONPlugin = this.service_.getArrayToJSONPlugin();
            arrayToJSONPlugin.toJSONScript(object, builder, indentLevel);
        } else {
            Field[] fields;
            for (Field field : fields = object.getClass().getDeclaredFields()) {
                String name;
                int modified = field.getModifiers();
                if (Modifier.isStatic(modified) || Modifier.isTransient(modified) || (name = field.getName()).startsWith("this")) continue;
                this.toJSONString(object, field, builder, indentLevel + 1);
            }
        }
        builder.deleteCharAt(builder.length() - 2);
        builder.append('\n');
        this.appendIndentation(builder, indentLevel);
        builder.append('}');
    }

    private void toJSONString(Object object, Field field, StringBuilder builder, int indentLevel) throws Exception {
        Class<?> type = field.getType();
        Object value = this.getValue(object, field);
        if (value == null) {
            value = new String();
        }
        this.appendIndentation(builder, indentLevel);
        builder.append('\'').append(field.getName()).append('\'').append(':').append(' ');
        if (type.isArray()) {
            ArrayToJSONPlugin arrayToJSONPlugin = this.service_.getArrayToJSONPlugin();
            arrayToJSONPlugin.toJSONScript(value, builder, indentLevel);
            return;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            Object[] array = new Object[collection.size()];
            collection.toArray(array);
            ArrayToJSONPlugin arrayToJSONPlugin = this.service_.getArrayToJSONPlugin();
            arrayToJSONPlugin.toJSONScript(array, builder, indentLevel);
            return;
        }
        if (this.isPrimitiveType(type)) {
            builder.append(value).append(',').append('\n');
            return;
        }
        if (this.isCharacterType(type)) {
            String charValue = this.encode(value.toString());
            builder.append('\'').append(charValue).append('\'').append(',').append('\n');
            return;
        }
        if (this.isDateType(type)) {
            this.toDateValue(builder, value);
            return;
        }
        BeanToJSONPlugin plugin = this.service_.getConverterPlugin(value);
        plugin.toJSONScript(value, builder, indentLevel + 1);
    }

    private Object getValue(Object bean, Field field) throws Exception {
        Class<?> clazz = bean.getClass();
        Method method = this.getMethod("get", field, clazz);
        if (method != null) {
            return method.invoke(bean, new Object[0]);
        }
        method = this.getMethod("is", field, clazz);
        if (method != null) {
            return method.invoke(bean, new Object[0]);
        }
        field.setAccessible(true);
        return field.get(bean);
    }

    private Method getMethod(String prefix, Field field, Class clazz) throws Exception {
        StringBuilder name = new StringBuilder(field.getName());
        name.setCharAt(0, Character.toUpperCase(name.charAt(0)));
        name.insert(0, prefix);
        try {
            Method method = clazz.getDeclaredMethod(name.toString(), new Class[0]);
            return method;
        }
        catch (Exception e) {
            return null;
        }
    }
}

