/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.transformer;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.rest.transformer.GenericEntityTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityTransformerFactory {
    private ExoContainer container_;

    public EntityTransformerFactory(ExoContainerContext containerContext) {
        this.container_ = containerContext.getContainer();
    }

    public final GenericEntityTransformer newTransformer(Class<? extends GenericEntityTransformer> transformerType) throws Exception {
        Constructor<?>[] constructors = transformerType.getConstructors();
        this.sortConstructorsByParamsLength(constructors, 0, constructors.length - 1);
        block0: for (Constructor<?> c : constructors) {
            Class<?>[] parameterTypes = c.getParameterTypes();
            if (parameterTypes.length == 0) {
                return (GenericEntityTransformer)c.newInstance(new Object[0]);
            }
            ArrayList<Object> parameters = new ArrayList<Object>(parameterTypes.length);
            for (Class<?> clazz : c.getParameterTypes()) {
                Object p = this.container_.getComponentInstanceOfType(clazz);
                if (p == null) continue block0;
                parameters.add(p);
            }
            return (GenericEntityTransformer)c.newInstance(parameters.toArray(new Object[parameters.size()]));
        }
        return null;
    }

    private void sortConstructorsByParamsLength(Constructor<? extends GenericEntityTransformer>[] constructors, int i0, int k0) {
        int i = i0;
        int k = k0;
        if (k0 > i0) {
            int middleElementParameterArrayLength = constructors[(i0 + k0) / 2].getParameterTypes().length;
            while (i <= k) {
                while (i < k0 && constructors[i].getParameterTypes().length > middleElementParameterArrayLength) {
                    ++i;
                }
                while (k > i0 && constructors[k].getParameterTypes().length < middleElementParameterArrayLength) {
                    --k;
                }
                if (i > k) continue;
                this.swapResources(constructors, i, k);
                ++i;
                --k;
            }
            if (i0 < k) {
                this.sortConstructorsByParamsLength(constructors, i0, k);
            }
            if (i < k0) {
                this.sortConstructorsByParamsLength(constructors, i, k0);
            }
        }
    }

    private void swapResources(Constructor<? extends GenericEntityTransformer>[] constructors, int i, int k) {
        Constructor<? extends GenericEntityTransformer> temp = constructors[i];
        constructors[i] = constructors[k];
        constructors[k] = temp;
    }
}

