/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.value;

import java.io.IOException;
import java.util.StringTokenizer;
import javax.jcr.ValueFormatException;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.impl.core.value.BaseValue;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;

public class PermissionValue
extends BaseValue {
    private static final int TYPE = 100;
    private String identity;
    private String permission;

    public PermissionValue(TransientValueData data) throws IOException {
        super(100, data);
        try {
            String[] persArray = PermissionValue.parse(new String(data.getAsByteArray()));
            this.identity = persArray[0];
            this.permission = persArray[1];
        }
        catch (IOException e) {
            throw new RuntimeException("FATAL ERROR IOException occured: " + e.getMessage(), e);
        }
    }

    public PermissionValue(String identity, String permission) throws IOException {
        super(100, new TransientValueData(PermissionValue.asString(identity, permission)));
        if (identity != null && identity.indexOf(" ") != -1) {
            throw new RuntimeException("Identity should not contain ' '");
        }
        if (!(permission == null || permission.equals("read") || permission.equals("add_node") || permission.equals("remove") || permission.equals("set_property"))) {
            throw new RuntimeException("Permission should be one of defined in PermissionType. Have " + permission);
        }
        this.identity = identity;
        this.permission = permission;
    }

    public static PermissionValue parseValue(String pstring) throws IOException {
        String[] persArray = PermissionValue.parse(pstring);
        return new PermissionValue(persArray[0], persArray[1]);
    }

    public static String[] parse(String pstring) {
        StringTokenizer parser = new StringTokenizer(pstring, " ");
        String identityString = parser.nextToken();
        String permissionString = parser.nextToken();
        String[] persArray = new String[]{identityString != null ? identityString : SystemIdentity.ANY, permissionString != null ? permissionString : "read"};
        return persArray;
    }

    protected String getInternalString() throws ValueFormatException {
        return PermissionValue.asString(this.identity, this.permission);
    }

    protected static String asString(String identity, String permission) {
        if (identity != null || permission != null) {
            return (identity != null ? identity : SystemIdentity.ANY) + " " + (permission != null ? permission : "read");
        }
        return "";
    }

    public String getIdentity() {
        return this.identity;
    }

    public String getPermission() {
        return this.permission;
    }
}

