/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemsArrayList<E extends ItemData>
extends ArrayList<E> {
    protected static Log log = ExoLogger.getLogger((String)"jcr.ItemsArrayList");
    private final long timestamp = System.currentTimeMillis();

    ItemsArrayList() {
    }

    @Override
    public void add(int index, ItemData element) {
        log.info((Object)(this.timestamp + " -- add(" + index + "," + element.getQPath().getAsString() + ")"));
        super.add(index, element);
    }

    @Override
    public boolean add(ItemData element) {
        log.info((Object)(this.timestamp + " -- add(" + element.getQPath().getAsString() + ")"));
        return super.add(element);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        log.info((Object)(this.timestamp + " -- addAll(" + c + ")"));
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        log.info((Object)(this.timestamp + " -- addAll(" + index + "," + c + ")"));
        return super.addAll(index, c);
    }

    @Override
    public void clear() {
        log.info((Object)(this.timestamp + " -- clear()"));
        super.clear();
    }

    @Override
    public Iterator<E> iterator() {
        Itr iter = new Itr();
        log.info((Object)(this.timestamp + " -- iterator()"));
        return iter;
    }

    @Override
    public ListIterator<E> listIterator() {
        log.info((Object)(this.timestamp + " -- listIterator()"));
        return super.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        log.info((Object)(this.timestamp + " -- listIterator(" + index + ")"));
        return super.listIterator(index);
    }

    @Override
    public E remove(int index) {
        log.info((Object)(this.timestamp + " -- remove(" + index + ")"));
        return (E)((ItemData)super.remove(index));
    }

    @Override
    public boolean remove(Object o) {
        log.info((Object)(this.timestamp + " -- remove(" + (o instanceof ItemData ? ((ItemData)o).getQPath().getAsString() : o) + ")"));
        return super.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        log.info((Object)(this.timestamp + " -- removeAll(" + c + ")"));
        return super.removeAll(c);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        log.info((Object)(this.timestamp + " -- removeRange(" + fromIndex + " " + toIndex + ")"));
        super.removeRange(fromIndex, toIndex);
    }

    @Override
    public E set(int index, E element) {
        log.info((Object)(this.timestamp + " -- set(" + index + "," + element.getQPath().getAsString() + ")"));
        return (E)((ItemData)super.set(index, element));
    }

    static /* synthetic */ int access$000(ItemsArrayList x0) {
        return x0.modCount;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Itr
    implements Iterator<E> {
        int cursor = 0;
        int lastRet = -1;
        int expectedModCount = ItemsArrayList.access$000(ItemsArrayList.this);

        @Override
        public boolean hasNext() {
            return this.cursor != ItemsArrayList.this.size();
        }

        @Override
        public E next() {
            ConcurrentModificationException concurrentException = null;
            try {
                this.checkForComodification();
            }
            catch (ConcurrentModificationException e) {
                log.error((Object)(ItemsArrayList.this.timestamp + " >>>> ConcurrentModificationException"));
                concurrentException = e;
            }
            try {
                ItemData next = (ItemData)ItemsArrayList.this.get(this.cursor);
                if (concurrentException != null) {
                    log.warn((Object)(ItemsArrayList.this.timestamp + " next accesed with concurrent changes " + next.getQPath().getAsString()), (Throwable)concurrentException);
                    throw concurrentException;
                }
                this.lastRet = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                ItemsArrayList.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = ItemsArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (ItemsArrayList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

