/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form;

import java.io.Writer;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.form.UIFormInputBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIFormDateTimeInput
extends UIFormInputBase<String> {
    private DateFormat dateFormat_;
    private boolean isDisplayTime_;

    public UIFormDateTimeInput(String name, String bindField, Date date, boolean isDisplayTime) {
        super(name, bindField, String.class);
        this.setDisplayTime(isDisplayTime);
        if (date != null) {
            this.value_ = this.dateFormat_.format(date);
        }
    }

    public UIFormDateTimeInput(String name, String bindField, Date date) {
        this(name, bindField, date, true);
    }

    public void setDisplayTime(boolean isDisplayTime) {
        this.isDisplayTime_ = isDisplayTime;
        this.dateFormat_ = this.isDisplayTime_ ? new SimpleDateFormat("MM/dd/yyyy HH:mm:ss") : new SimpleDateFormat("MM/dd/yyyy");
    }

    public void setCalendar(Calendar date) {
        this.value_ = this.dateFormat_.format(date.getTime());
    }

    public Calendar getCalendar() {
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(this.dateFormat_.parse((String)this.value_ + " 0:0:0"));
            return calendar;
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Override
    public void decode(Object input, WebuiRequestContext context) throws Exception {
        if (input != null) {
            this.value_ = ((String)input).trim();
        }
    }

    @Override
    public void processRender(WebuiRequestContext context) throws Exception {
        context.getJavascriptManager().importJavascript((CharSequence)"eXo.webui.UICalendar");
        Writer w = context.getWriter();
        w.write("<input type='text' onfocus='eXo.webui.UICalendar.init(this,");
        w.write(String.valueOf(this.isDisplayTime_));
        w.write(");' onkeyup='eXo.webui.UICalendar.show();' name='");
        w.write(this.getName());
        w.write(39);
        if (this.value_ != null && ((String)this.value_).length() > 0) {
            w.write(" value='");
            w.write(((String)this.value_).toString());
            w.write(39);
        }
        w.write(" onmousedown='event.cancelBubble = true' />");
    }
}

