/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form;

import java.io.Writer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.form.UIFormStringInput;

public class UIFormTextAreaInput
extends UIFormStringInput {
    private int rows = -1;
    private int columns = -1;

    public UIFormTextAreaInput(String name, String bindingExpression, String value) {
        super(name, bindingExpression, value);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        Writer w = context.getWriter();
        String value = (String)this.getValue();
        if (value == null) {
            value = (String)this.getDefaultValue();
        }
        w.append("<textarea class='textarea' name='").append(this.getName()).append("' id='").append(this.getId()).append("'");
        if (this.readonly_) {
            w.write(" readonly ");
        }
        if (!this.enable_) {
            w.write(" disabled ");
        }
        if (this.rows > -1) {
            w.append(" rows=\"").append(String.valueOf(this.rows)).append("\"");
        }
        if (this.columns > -1) {
            w.append(" cols=\"").append(String.valueOf(this.columns)).append("\"");
        }
        w.write(">");
        if (value != null) {
            w.write(value);
        }
        w.write("</textarea>");
        if (this.isMandatory()) {
            w.write(" *");
        }
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }
}

