/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.text.unicode;

import org.exoplatform.services.common.ThreadSoftRef;

public class UTF16 {
    private static final int LEAD_SURROGATE_SHIFT_ = 10;
    public static final int SUPPLEMENTARY_MIN_VALUE = 65536;
    public static final int LEAD_SURROGATE_MIN_VALUE = 55296;
    public static final int TRAIL_SURROGATE_MAX_VALUE = 57343;
    private static final int TRAIL_SURROGATE_MASK_ = 1023;
    public static final int TRAIL_SURROGATE_MIN_VALUE = 56320;
    public static final int CODEPOINT_MIN_VALUE = 0;
    public static final int CODEPOINT_MAX_VALUE = 0x10FFFF;
    public static final int SURROGATE_MIN_VALUE = 55296;
    private static final int SURROGATE_OFFSET_ = -56613888;
    private static final int LEAD_SURROGATE_OFFSET_ = 55232;
    static ThreadSoftRef<UTF16> INSTANCE = new ThreadSoftRef(UTF16.class);
    public final int LEAD_SURROGATE_MAX_VALUE = 56319;

    static UTF16 getInstance() {
        return INSTANCE.getRef();
    }

    public int getRawSupplementary(char lead, char trail) {
        return (lead << 10) + trail + -56613888;
    }

    public int charAt(String source, int offset16) {
        char single = source.charAt(offset16);
        if (single < '\ud800') {
            return single;
        }
        return this._charAt(source, offset16, single);
    }

    private int _charAt(String source, int offset16, char single) {
        char lead;
        if (single > '\udfff') {
            return single;
        }
        if (single <= '\udbff') {
            char trail;
            if (source.length() != ++offset16 && (trail = source.charAt(offset16)) >= '\udc00' && trail <= '\udfff') {
                return this.getRawSupplementary(single, trail);
            }
        } else if (--offset16 >= 0 && (lead = source.charAt(offset16)) >= '\ud800' && lead <= '\udbff') {
            return this.getRawSupplementary(lead, single);
        }
        return single;
    }

    public int charAt(StringBuilder source, int offset16) {
        char lead;
        if (offset16 < 0 || offset16 >= source.length()) {
            throw new StringIndexOutOfBoundsException(offset16);
        }
        char single = source.charAt(offset16);
        if (!this.isSurrogate(single)) {
            return single;
        }
        if (single <= '\udbff') {
            char trail;
            if (source.length() != ++offset16 && this.isTrailSurrogate(trail = source.charAt(offset16))) {
                return this.getRawSupplementary(single, trail);
            }
        } else if (--offset16 >= 0 && this.isLeadSurrogate(lead = source.charAt(offset16))) {
            return this.getRawSupplementary(lead, single);
        }
        return single;
    }

    public void setCharAt(StringBuilder target, int offset16, int char32) {
        int count = 1;
        char single = target.charAt(offset16);
        if (this.isSurrogate(single)) {
            if (this.isLeadSurrogate(single) && target.length() > offset16 + 1 && this.isTrailSurrogate(target.charAt(offset16 + 1))) {
                ++count;
            } else if (this.isTrailSurrogate(single) && offset16 > 0 && this.isLeadSurrogate(target.charAt(offset16 - 1))) {
                --offset16;
                ++count;
            }
        }
        target.replace(offset16, offset16 + count, this.valueOf(char32));
    }

    public boolean isSurrogate(char char16) {
        return '\ud800' <= char16 && char16 <= '\udfff';
    }

    public boolean isTrailSurrogate(char char16) {
        return '\udc00' <= char16 && char16 <= '\udfff';
    }

    public boolean isLeadSurrogate(char char16) {
        return '\ud800' <= char16 && char16 <= '\udbff';
    }

    public int getCharCount(int char32) {
        return char32 < 65536 ? 1 : 2;
    }

    public String valueOf(int char32) {
        if (char32 < 0 || char32 > 0x10FFFF) {
            throw new IllegalArgumentException("Illegal codepoint");
        }
        return this.toString(char32);
    }

    public char getLeadSurrogate(int char32) {
        return char32 >= 65536 ? (char)(55232 + (char32 >> 10)) : (char)'\u0000';
    }

    public char getTrailSurrogate(int char32) {
        return char32 >= 65536 ? (char)(56320 + (char32 & 0x3FF)) : (char)char32;
    }

    private String toString(int ch) {
        if (ch < 65536) {
            return String.valueOf((char)ch);
        }
        StringBuilder result = new StringBuilder(this.getLeadSurrogate(ch)).append(this.getTrailSurrogate(ch));
        return result.toString();
    }
}

