/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.command.handler;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.json.BeanToJSONPlugin;
import org.exoplatform.json.JSONService;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.command.Command;

public class GetApplicationHandler
extends Command {
    private String[] applicationType;

    public void setApplicationTypes(String[] type) {
        this.applicationType = type;
    }

    public void execute(WebAppController controller, HttpServletRequest req, HttpServletResponse res) throws Exception {
        res.setHeader("Cache-Control", "no-cache");
        PrintWriter writer = res.getWriter();
        try {
            ((Writer)writer).append(this.getApplications(req.getRemoteUser()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    private StringBuilder getApplications(String remoteUser) throws Exception {
        PortalContainer container = PortalContainer.getInstance();
        ApplicationRegistryService prService = (ApplicationRegistryService)container.getComponentInstanceOfType(ApplicationRegistryService.class);
        if (this.applicationType == null) {
            this.applicationType = new String[0];
        }
        List appCategories = prService.getApplicationCategories(remoteUser, this.applicationType);
        ApplicationCategoryToJSONPlugin toJSON = new ApplicationCategoryToJSONPlugin();
        StringBuilder value = new StringBuilder();
        JSONService jsonService = new JSONService();
        jsonService.register(ApplicationCategory.class, (BeanToJSONPlugin)toJSON);
        if (appCategories.size() < 1) {
            return value;
        }
        value.append("{\n").append("  applicationRegistry : {\n");
        for (int i = 0; i < appCategories.size(); ++i) {
            ApplicationCategory category = (ApplicationCategory)appCategories.get(i);
            jsonService.toJSONScript((Object)category, value, 1);
            if (i >= appCategories.size() - 1) continue;
            value.append("   ,\n");
        }
        value.append("  }\n").append("}\n");
        return value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ApplicationCategoryToJSONPlugin
    extends BeanToJSONPlugin<ApplicationCategory> {
        private ApplicationCategoryToJSONPlugin() {
        }

        public void toJSONScript(ApplicationCategory category, StringBuilder builder, int indentLevel) throws Exception {
            StringBuilder builderPortlet = this.toJSONScript(category, indentLevel + 2);
            if (builderPortlet.length() < 1) {
                return;
            }
            this.appendIndentation(builder, indentLevel);
            builder.append('\'').append(category.getName()).append("' : {\n");
            this.appendIndentation(builder, indentLevel + 1);
            builder.append("'name' : '").append(category.getDisplayName()).append("',\n");
            this.appendIndentation(builder, indentLevel + 1);
            builder.append("'applications' : {\n");
            builder.append((CharSequence)builderPortlet);
            this.appendIndentation(builder, indentLevel + 1);
            builder.append("}\n");
            this.appendIndentation(builder, indentLevel);
            builder.append("}\n");
        }

        private StringBuilder toJSONScript(ApplicationCategory category, int indentLevel) throws Exception {
            StringBuilder builder = new StringBuilder();
            List applications = category.getApplications();
            for (int j = 0; j < applications.size(); ++j) {
                this.toJSONScript((Application)applications.get(j), builder, indentLevel);
                if (j >= applications.size() - 1) continue;
                this.appendIndentation(builder, indentLevel);
                builder.append(",\n");
            }
            return builder;
        }

        private void toJSONScript(Application application, StringBuilder builder, int indentLevel) {
            this.appendIndentation(builder, indentLevel);
            builder.append('\'').append(application.getId()).append("' : {\n");
            this.appendIndentation(builder, indentLevel + 1);
            builder.append("'name' : ").append("'").append(application.getApplicationName()).append("',\n");
            this.appendIndentation(builder, indentLevel + 1);
            builder.append("'title' : ").append("'").append(application.getDisplayName()).append("',\n");
            this.appendIndentation(builder, indentLevel + 1);
            builder.append("'des' : ").append("'").append(application.getDescription()).append("',\n");
            this.appendIndentation(builder, indentLevel + 1);
            builder.append("'id' : ").append("'").append(application.getId()).append("',\n");
            this.appendIndentation(builder, indentLevel + 1);
            builder.append("'type' : ").append("'").append(application.getApplicationType()).append("'\n");
            this.appendIndentation(builder, indentLevel);
            builder.append("}\n");
        }
    }
}

