/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hwpf.model.CHPBinTable;
import org.apache.poi.hwpf.model.ComplexFileTable;
import org.apache.poi.hwpf.model.DocumentProperties;
import org.apache.poi.hwpf.model.FileInformationBlock;
import org.apache.poi.hwpf.model.FontTable;
import org.apache.poi.hwpf.model.GenericPropertyNode;
import org.apache.poi.hwpf.model.ListTables;
import org.apache.poi.hwpf.model.PAPBinTable;
import org.apache.poi.hwpf.model.PlexOfCps;
import org.apache.poi.hwpf.model.PropertyNode;
import org.apache.poi.hwpf.model.SectionTable;
import org.apache.poi.hwpf.model.StyleSheet;
import org.apache.poi.hwpf.model.TextPiece;
import org.apache.poi.hwpf.model.TextPieceTable;
import org.apache.poi.hwpf.model.io.HWPFFileSystem;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;
import org.apache.poi.hwpf.usermodel.HWPFList;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class HWPFDocument {
    protected FileInformationBlock _fib;
    private byte[] _mainStream;
    private byte[] _tableStream;
    protected byte[] _dataStream;
    protected DocumentProperties _dop;
    protected ComplexFileTable _cft;
    protected TextPieceTable _tpt;
    protected CHPBinTable _cbt;
    protected PAPBinTable _pbt;
    protected SectionTable _st;
    protected StyleSheet _ss;
    protected FontTable _ft;
    protected ListTables _lt;

    protected HWPFDocument() {
    }

    public HWPFDocument(InputStream istream) throws IOException {
        POIFSFileSystem filesystem = new POIFSFileSystem(istream);
        DocumentEntry documentProps = (DocumentEntry)filesystem.getRoot().getEntry("WordDocument");
        this._mainStream = new byte[documentProps.getSize()];
        filesystem.createDocumentInputStream("WordDocument").read(this._mainStream);
        this._fib = new FileInformationBlock(this._mainStream);
        String name = "0Table";
        if (this._fib.isFWhichTblStm()) {
            name = "1Table";
        }
        DocumentEntry tableProps = (DocumentEntry)filesystem.getRoot().getEntry(name);
        this._tableStream = new byte[tableProps.getSize()];
        filesystem.createDocumentInputStream(name).read(this._tableStream);
        this._fib.fillVariableFields(this._mainStream, this._tableStream);
        try {
            DocumentEntry dataProps = (DocumentEntry)filesystem.getRoot().getEntry("Data");
            this._dataStream = new byte[dataProps.getSize()];
            filesystem.createDocumentInputStream("Data").read(this._dataStream);
        }
        catch (FileNotFoundException e) {
            this._dataStream = new byte[0];
        }
        int fcMin = this._fib.getFcMin();
        this._dop = new DocumentProperties(this._tableStream, this._fib.getFcDop());
        this._cft = new ComplexFileTable(this._mainStream, this._tableStream, this._fib.getFcClx(), fcMin);
        this._tpt = this._cft.getTextPieceTable();
        this._cbt = new CHPBinTable(this._mainStream, this._tableStream, this._fib.getFcPlcfbteChpx(), this._fib.getLcbPlcfbteChpx(), fcMin);
        this._pbt = new PAPBinTable(this._mainStream, this._tableStream, this._dataStream, this._fib.getFcPlcfbtePapx(), this._fib.getLcbPlcfbtePapx(), fcMin);
        int cpMin = this._tpt.getCpMin();
        if (cpMin > 0) {
            this._cbt.adjustForDelete(0, 0, cpMin);
            this._pbt.adjustForDelete(0, 0, cpMin);
        }
        this._st = new SectionTable(this._mainStream, this._tableStream, this._fib.getFcPlcfsed(), this._fib.getLcbPlcfsed(), fcMin, this.getTextTable().getTextPieces());
        this._ss = new StyleSheet(this._tableStream, this._fib.getFcStshf());
        this._ft = new FontTable(this._tableStream, this._fib.getFcSttbfffn(), this._fib.getLcbSttbfffn());
        int listOffset = this._fib.getFcPlcfLst();
        int lfoOffset = this._fib.getFcPlfLfo();
        if (listOffset != 0 && this._fib.getLcbPlcfLst() != 0) {
            this._lt = new ListTables(this._tableStream, this._fib.getFcPlcfLst(), this._fib.getFcPlfLfo());
        }
        PlexOfCps plc = new PlexOfCps(this._tableStream, this._fib.getFcPlcffldMom(), this._fib.getLcbPlcffldMom(), 2);
        for (int x = 0; x < plc.length(); ++x) {
            GenericPropertyNode node = plc.getProperty(x);
            byte[] fld = node.getBytes();
            boolean breakpoint = false;
        }
    }

    public StyleSheet getStyleSheet() {
        return this._ss;
    }

    public FileInformationBlock getFileInformationBlock() {
        return this._fib;
    }

    public DocumentProperties getDocProperties() {
        return this._dop;
    }

    public Range getRange() {
        List text = this._tpt.getTextPieces();
        PropertyNode p = (PropertyNode)text.get(text.size() - 1);
        return new Range(0, p.getEnd(), this);
    }

    public int characterLength() {
        List textPieces = this._tpt.getTextPieces();
        Iterator textIt = textPieces.iterator();
        int length = 0;
        while (textIt.hasNext()) {
            TextPiece tp = (TextPiece)textIt.next();
            length += tp.characterLength();
        }
        return length;
    }

    public ListTables getListTables() {
        return this._lt;
    }

    public void write(OutputStream out) throws IOException {
        byte[] dataBuf;
        HWPFFileSystem docSys = new HWPFFileSystem();
        HWPFOutputStream mainStream = docSys.getStream("WordDocument");
        HWPFOutputStream tableStream = docSys.getStream("1Table");
        int tableOffset = 0;
        this._fib.clearOffsetsSizes();
        int fibSize = this._fib.getSize();
        fibSize += 512 - fibSize % 512;
        byte[] placeHolder = new byte[fibSize];
        mainStream.write(placeHolder);
        int mainOffset = mainStream.getOffset();
        this._fib.setFcStshf(tableOffset);
        this._ss.writeTo(tableStream);
        this._fib.setLcbStshf(tableStream.getOffset() - tableOffset);
        tableOffset = tableStream.getOffset();
        int fcMin = mainOffset;
        this._fib.setFcClx(tableOffset);
        this._cft.writeTo(docSys);
        this._fib.setLcbClx(tableStream.getOffset() - tableOffset);
        tableOffset = tableStream.getOffset();
        int fcMac = mainStream.getOffset();
        this._fib.setFcPlcfbteChpx(tableOffset);
        this._cbt.writeTo(docSys, fcMin);
        this._fib.setLcbPlcfbteChpx(tableStream.getOffset() - tableOffset);
        tableOffset = tableStream.getOffset();
        this._fib.setFcPlcfbtePapx(tableOffset);
        this._pbt.writeTo(docSys, fcMin);
        this._fib.setLcbPlcfbtePapx(tableStream.getOffset() - tableOffset);
        tableOffset = tableStream.getOffset();
        this._fib.setFcPlcfsed(tableOffset);
        this._st.writeTo(docSys, fcMin);
        this._fib.setLcbPlcfsed(tableStream.getOffset() - tableOffset);
        tableOffset = tableStream.getOffset();
        if (this._lt != null) {
            this._fib.setFcPlcfLst(tableOffset);
            this._lt.writeListDataTo(tableStream);
            this._fib.setLcbPlcfLst(tableStream.getOffset() - tableOffset);
            this._fib.setFcPlfLfo(tableStream.getOffset());
            this._lt.writeListOverridesTo(tableStream);
            this._fib.setLcbPlfLfo(tableStream.getOffset() - tableOffset);
            tableOffset = tableStream.getOffset();
        }
        this._fib.setFcSttbfffn(tableOffset);
        this._ft.writeTo(docSys);
        this._fib.setLcbSttbfffn(tableStream.getOffset() - tableOffset);
        tableOffset = tableStream.getOffset();
        this._fib.setFcDop(tableOffset);
        byte[] buf = new byte[this._dop.getSize()];
        this._fib.setLcbDop(this._dop.getSize());
        this._dop.serialize(buf, 0);
        tableStream.write(buf);
        this._fib.setFcMin(fcMin);
        this._fib.setFcMac(fcMac);
        this._fib.setCbMac(mainStream.getOffset());
        byte[] mainBuf = mainStream.toByteArray();
        if (mainBuf.length < 4096) {
            byte[] tempBuf = new byte[4096];
            System.arraycopy(mainBuf, 0, tempBuf, 0, mainBuf.length);
            mainBuf = tempBuf;
        }
        this._fib.writeTo(mainBuf, tableStream);
        byte[] tableBuf = tableStream.toByteArray();
        if (tableBuf.length < 4096) {
            byte[] tempBuf = new byte[4096];
            System.arraycopy(tableBuf, 0, tempBuf, 0, tableBuf.length);
            tableBuf = tempBuf;
        }
        if ((dataBuf = this._dataStream) == null) {
            dataBuf = new byte[4096];
        }
        if (dataBuf.length < 4096) {
            byte[] tempBuf = new byte[4096];
            System.arraycopy(dataBuf, 0, tempBuf, 0, dataBuf.length);
            dataBuf = tempBuf;
        }
        POIFSFileSystem pfs = new POIFSFileSystem();
        pfs.createDocument((InputStream)new ByteArrayInputStream(mainBuf), "WordDocument");
        pfs.createDocument((InputStream)new ByteArrayInputStream(tableBuf), "1Table");
        pfs.createDocument((InputStream)new ByteArrayInputStream(dataBuf), "Data");
        pfs.writeFilesystem(out);
    }

    public CHPBinTable getCharacterTable() {
        return this._cbt;
    }

    public PAPBinTable getParagraphTable() {
        return this._pbt;
    }

    public SectionTable getSectionTable() {
        return this._st;
    }

    public TextPieceTable getTextTable() {
        return this._cft.getTextPieceTable();
    }

    public byte[] getDataStream() {
        return this._dataStream;
    }

    public int registerList(HWPFList list) {
        if (this._lt == null) {
            this._lt = new ListTables();
        }
        return this._lt.addList(list.getListData(), list.getOverride());
    }

    public FontTable getFontTable() {
        return this._ft;
    }

    public void delete(int start, int length) {
        Range r = new Range(start, start + length, this);
        r.delete();
    }

    public static void main(String[] args) {
        try {
            HWPFDocument doc = new HWPFDocument(new FileInputStream(args[0]));
            Range r = doc.getRange();
            String str = r.text();
            boolean x = false;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

