/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.UserWidgetStorage;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.UIWelcomeComponent;
import org.exoplatform.portal.webui.application.UIAddNewApplication;
import org.exoplatform.portal.webui.application.UIWidget;
import org.exoplatform.portal.webui.navigation.PageNavigationUtils;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.page.UIPageForm;
import org.exoplatform.portal.webui.portal.PageNodeEvent;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIControlWorkspace;
import org.exoplatform.portal.webui.workspace.UIExoStart;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIPortalToolPanel;
import org.exoplatform.portal.webui.workspace.UIWorkspace;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

public class UIPageActionListener {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShowAddNewApplicationActionListener
    extends EventListener<UIPage> {
        public void execute(Event<UIPage> event) throws Exception {
            UIPage uiPage = (UIPage)((Object)event.getSource());
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiPage.getAncestorOfType(UIPortalApplication.class);
            UIMaskWorkspace uiMaskWorkspace = (UIMaskWorkspace)uiPortalApp.getChildById("UIMaskWorkspace");
            UIAddNewApplication uiAddApplication = (UIAddNewApplication)uiPage.createUIComponent(UIAddNewApplication.class, null, null);
            uiAddApplication.setInPage(true);
            uiAddApplication.setUiComponentParent((UIComponent)uiPage);
            uiAddApplication.getApplicationCategories(event.getRequestContext().getRemoteUser(), null);
            uiMaskWorkspace.setWindowSize(700, 375);
            uiMaskWorkspace.setUIComponent((UIComponent)uiAddApplication);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWorkspace);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveWindowPropertiesActionListener
    extends EventListener<UIPage> {
        public void execute(Event<UIPage> event) throws Exception {
            String appStatus;
            String zIndex;
            String objectId;
            UIPage uiPage = (UIPage)((Object)event.getSource());
            org.exoplatform.portal.webui.application.UIApplication uiApp = (org.exoplatform.portal.webui.application.UIApplication)uiPage.getChildById(objectId = event.getRequestContext().getRequestParameter("objectId"));
            if (uiApp == null) {
                return;
            }
            String posX = event.getRequestContext().getRequestParameter("posX");
            String posY = event.getRequestContext().getRequestParameter("posY");
            if (posX != null) {
                uiApp.getProperties().put((Object)"locationX", (Object)posX);
            }
            if (posY != null) {
                uiApp.getProperties().put((Object)"locationY", (Object)posY);
            }
            if ((zIndex = event.getRequestContext().getRequestParameter("zIndex")) != null) {
                uiApp.getProperties().put((Object)"zIndex", (Object)zIndex);
            }
            String windowWidth = event.getRequestContext().getRequestParameter("windowWidth");
            String windowHeight = event.getRequestContext().getRequestParameter("windowHeight");
            if (windowWidth != null) {
                uiApp.getProperties().put((Object)"windowWidth", (Object)windowWidth);
            }
            if (windowHeight != null) {
                uiApp.getProperties().put((Object)"windowHeight", (Object)windowHeight);
            }
            if ((appStatus = event.getRequestContext().getRequestParameter("appStatus")) != null) {
                uiApp.getProperties().put((Object)"appStatus", (Object)appStatus);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveWidgetPropertiesActionListener
    extends EventListener<UIPage> {
        public void execute(Event<UIPage> event) throws Exception {
            UIPage uiPage = (UIPage)((Object)event.getSource());
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            ArrayList uiWidgets = new ArrayList();
            uiPage.findComponentOfType(uiWidgets, UIWidget.class);
            UIWidget uiWidget = null;
            for (UIWidget ele : uiWidgets) {
                if (!ele.getApplicationInstanceUniqueId().equals(objectId)) continue;
                uiWidget = ele;
                break;
            }
            if (uiWidget == null) {
                return;
            }
            String posX = event.getRequestContext().getRequestParameter("posX");
            String posY = event.getRequestContext().getRequestParameter("posY");
            String zIndex = event.getRequestContext().getRequestParameter("zIndex");
            uiWidget.getProperties().put((Object)"locationX", (Object)posX);
            uiWidget.getProperties().put((Object)"locationY", (Object)posY);
            uiWidget.getProperties().put((Object)"zIndex", (Object)zIndex);
            if (!uiPage.isModifiable()) {
                return;
            }
            Page page = PortalDataMapper.toPageModel(uiPage);
            UserPortalConfigService configService = (UserPortalConfigService)uiPage.getApplicationComponent(UserPortalConfigService.class);
            if (page.getChildren() == null) {
                page.setChildren(new ArrayList());
            }
            configService.update(page);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveChildActionListener
    extends EventListener<UIPage> {
        public void execute(Event<UIPage> event) throws Exception {
            UIPage uiPage = (UIPage)((Object)event.getSource());
            String id = event.getRequestContext().getRequestParameter("objectId");
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            if (uiPage.isModifiable()) {
                uiPage.removeChildById(id);
                Page page = PortalDataMapper.toPageModel(uiPage);
                UserPortalConfigService configService = (UserPortalConfigService)uiPage.getApplicationComponent(UserPortalConfigService.class);
                if (page.getChildren() == null) {
                    page.setChildren(new ArrayList());
                }
                configService.update(page);
                pcontext.setFullRender(false);
                pcontext.setResponseComplete(true);
                pcontext.getWriter().write("OK");
            } else {
                UIApplication uiApp = pcontext.getUIApplication();
                uiApp.addMessage(new ApplicationMessage("UIPage.msg.EditPermission.null", null));
                pcontext.addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteWidgetActionListener
    extends EventListener<UIPage> {
        public void execute(Event<UIPage> event) throws Exception {
            WebuiRequestContext pContext = event.getRequestContext();
            String id = pContext.getRequestParameter("objectId");
            UIPage uiPage = (UIPage)((Object)event.getSource());
            ArrayList uiWidgets = new ArrayList();
            uiPage.findComponentOfType(uiWidgets, UIWidget.class);
            for (UIWidget uiWidget : uiWidgets) {
                if (!uiWidget.getApplicationInstanceUniqueId().equals(id)) continue;
                uiPage.getChildren().remove((Object)uiWidget);
                String userName = pContext.getRemoteUser();
                if (userName != null && userName.trim().length() > 0) {
                    UserWidgetStorage widgetDataService = (UserWidgetStorage)uiPage.getApplicationComponent(UserWidgetStorage.class);
                    widgetDataService.delete(userName, uiWidget.getApplicationName(), uiWidget.getApplicationInstanceUniqueId());
                }
                if (!uiPage.isModifiable()) break;
                Page page = PortalDataMapper.toPageModel(uiPage);
                UserPortalConfigService configService = (UserPortalConfigService)uiPage.getApplicationComponent(UserPortalConfigService.class);
                if (page.getChildren() == null) {
                    page.setChildren(new ArrayList());
                }
                configService.update(page);
                break;
            }
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            pcontext.setFullRender(false);
            pcontext.setResponseComplete(true);
            pcontext.getWriter().write("OK");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditPageActionListener
    extends EventListener<UIPage> {
        public void execute(Event<UIPage> event) throws Exception {
            UIPage uiPage = (UIPage)((Object)event.getSource());
            UIPageForm uiForm = (UIPageForm)uiPage.createUIComponent(UIPageForm.class, null, null);
            uiForm.setValues(uiPage);
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiPage.getAncestorOfType(UIPortalApplication.class);
            UIWorkspace uiWorkingWS = (UIWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
            UIPortalToolPanel uiToolPanel = (UIPortalToolPanel)uiWorkingWS.findFirstComponentOfType(UIPortalToolPanel.class);
            uiToolPanel.setUIComponent((UIComponent)uiForm);
            uiWorkingWS.setRenderedChild(UIPortalToolPanel.class);
        }
    }

    public static class ChangePageNodeActionListener
    extends EventListener {
        private UIPortal uiPortal;
        private List<PageNode> selectedPaths_;

        public void execute(Event event) throws Exception {
            ArrayList nodes;
            PageNavigation nav3;
            int idx;
            PageNodeEvent pnevent = (PageNodeEvent)event;
            this.uiPortal = (UIPortal)((Object)event.getSource());
            UIPageBody uiPageBody = (UIPageBody)this.uiPortal.findFirstComponentOfType(UIPageBody.class);
            UIPortalApplication uiPortalApp = (UIPortalApplication)this.uiPortal.getAncestorOfType(UIPortalApplication.class);
            uiPortalApp.setEditting(false);
            UIWorkspace uiWorkingWS = (UIWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
            PortalRequestContext pcontext = Util.getPortalRequestContext();
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            this.uiPortal.setRenderSibbling(UIPortal.class);
            pcontext.setFullRender(true);
            UIControlWorkspace uiControl = (UIControlWorkspace)uiPortalApp.getChildById("UIControlWorkspace");
            if (uiControl != null) {
                UIControlWorkspace.UIControlWSWorkingArea uiWorking = (UIControlWorkspace.UIControlWSWorkingArea)uiControl.getChild(UIControlWorkspace.UIControlWSWorkingArea.class);
                pcontext.addUIComponentToUpdateByAjax((UIComponent)uiControl);
                UIExoStart exoStart = (UIExoStart)uiPortalApp.findFirstComponentOfType(UIExoStart.class);
                pcontext.addUIComponentToUpdateByAjax(exoStart);
                if (!UIWelcomeComponent.class.isInstance(uiWorking.getUIComponent())) {
                    uiWorking.setUIComponent(uiWorking.createUIComponent(UIWelcomeComponent.class, null, null));
                }
            }
            this.selectedPaths_ = new ArrayList<PageNode>(5);
            List<PageNavigation> navigations = this.uiPortal.getNavigations();
            String uri = pnevent.getTargetNodeUri();
            if (uri == null || (uri = uri.trim()).length() < 1) {
                return;
            }
            if (uri.length() == 1 && uri.charAt(0) == '/') {
                for (PageNavigation nav2 : navigations) {
                    for (PageNode child : nav2.getNodes()) {
                        if (PageNavigationUtils.filter(child, pcontext.getRemoteUser()) == null) continue;
                        this.selectedPaths_.add(child);
                        this.uiPortal.setSelectedNode(child);
                        this.uiPortal.setSelectedPaths(this.selectedPaths_);
                        uiPageBody.setPageBody(this.uiPortal.getSelectedNode(), this.uiPortal);
                        return;
                    }
                }
            }
            if (uri.charAt(0) == '/') {
                uri = uri.substring(1);
            }
            if ((idx = uri.lastIndexOf("::")) < 0) {
                for (PageNavigation nav3 : navigations) {
                    nodes = nav3.getNodes();
                    PageNode nodeResult = null;
                    for (PageNode node : nodes) {
                        nodeResult = this.searchPageNodeByUri(uri, node);
                        if (nodeResult == null) continue;
                        this.selectedPaths_.add(0, nodeResult);
                        break;
                    }
                    if (nodeResult == null) continue;
                    this.uiPortal.setSelectedNavigation(nav3);
                    break;
                }
                this.uiPortal.setSelectedPaths(this.selectedPaths_);
                uiPageBody.setPageBody(this.uiPortal.getSelectedNode(), this.uiPortal);
                return;
            }
            String navId = uri.substring(0, idx);
            uri = uri.substring(idx + 2, uri.length());
            nav3 = null;
            for (PageNavigation ele : navigations) {
                if (!ele.getId().equals(navId)) continue;
                nav3 = ele;
                break;
            }
            if (nav3 != null) {
                nodes = nav3.getNodes();
                for (PageNode node : nodes) {
                    PageNode nodeResult = this.searchPageNodeByUri(uri, node);
                    if (nodeResult == null) continue;
                    this.selectedPaths_.add(0, nodeResult);
                    break;
                }
                this.uiPortal.setSelectedNavigation(nav3);
            }
            this.uiPortal.setSelectedPaths(this.selectedPaths_);
            uiPageBody.setPageBody(this.uiPortal.getSelectedNode(), this.uiPortal);
        }

        private PageNode searchPageNodeByUri(String uri, PageNode node) {
            if (node.getUri().equals(uri)) {
                this.uiPortal.setSelectedNode(node);
                return node;
            }
            List children = node.getChildren();
            if (children == null) {
                return null;
            }
            for (PageNode ele : children) {
                PageNode nodeResult = this.searchPageNodeByUri(uri, ele);
                if (nodeResult == null) continue;
                this.selectedPaths_.add(0, nodeResult);
                return node;
            }
            return null;
        }
    }
}

