/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.access;

import java.util.Set;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.auth.AuthenticationService;
import org.exoplatform.services.organization.auth.Identity;
import org.exoplatform.services.security.impl.CredentialsImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRAuthenticationListener
extends Listener<AuthenticationService, Identity> {
    private Log log = ExoLogger.getLogger((String)"kernel.JCRAuthenticationListener");

    public void onEvent(Event<AuthenticationService, Identity> event) {
        Identity identity = (Identity)event.getData();
        String username = identity.getUsername();
        Subject subject = identity.getSubject();
        Set<String> temp = subject.getPrivateCredentials(String.class);
        if (temp.size() == 1) {
            subject.getPublicCredentials().add(new CredentialsImpl(username, temp.iterator().next().toCharArray()));
        } else {
            this.log.warn((Object)"Could not obtain the password credentials from AuthenticationService.JCR Credentials will not be created.");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Call JCRAuthenticationListener");
        }
    }
}

