/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.util.Date;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.query.QueryConstants;
import org.exoplatform.services.jcr.impl.core.query.QueryNode;
import org.exoplatform.services.jcr.impl.core.query.QueryNodeVisitor;

public class RelationQueryNode
extends QueryNode
implements QueryConstants {
    private InternalQName property;
    private boolean unaryMinus;
    private long valueLong;
    private int valuePosition;
    private double valueDouble;
    private String valueString;
    private Date valueDate;
    private int operation;
    private int type;

    public RelationQueryNode(QueryNode parent, int operation) {
        super(parent);
        this.operation = operation;
    }

    public RelationQueryNode(QueryNode parent, InternalQName property, long value, int operation) {
        super(parent);
        this.property = property;
        this.valueLong = value;
        this.operation = operation;
        this.type = 1;
    }

    public RelationQueryNode(QueryNode parent, InternalQName property, double value, int operation) {
        super(parent);
        this.property = property;
        this.valueDouble = value;
        this.operation = operation;
        this.type = 2;
    }

    public RelationQueryNode(QueryNode parent, InternalQName property, Date value, int operation) {
        super(parent);
        this.property = property;
        this.valueDate = value;
        this.operation = operation;
        this.type = 4;
    }

    public RelationQueryNode(QueryNode parent, InternalQName property, String value, int operation) {
        super(parent);
        this.property = property;
        this.valueString = value;
        this.operation = operation;
        this.type = 3;
    }

    public Object accept(QueryNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public int getType() {
        return 2;
    }

    public void setUnaryMinus(boolean b) {
        this.unaryMinus = b;
    }

    public int getValueType() {
        return this.type;
    }

    public InternalQName getProperty() {
        return this.property;
    }

    public void setProperty(InternalQName name) {
        this.property = name;
    }

    public long getLongValue() {
        return this.valueLong;
    }

    public void setLongValue(long value) {
        this.valueLong = this.unaryMinus ? -value : value;
        this.type = 1;
    }

    public int getPositionValue() {
        return this.valuePosition;
    }

    public void setPositionValue(int value) {
        this.valuePosition = value;
        this.type = 6;
    }

    public double getDoubleValue() {
        return this.valueDouble;
    }

    public void setDoubleValue(double value) {
        this.valueDouble = this.unaryMinus ? -value : value;
        this.type = 2;
    }

    public String getStringValue() {
        return this.valueString;
    }

    public void setStringValue(String value) {
        this.valueString = value;
        this.type = 3;
    }

    public Date getDateValue() {
        return this.valueDate;
    }

    public void setDateValue(Date value) {
        this.valueDate = value;
        this.type = 4;
    }

    public int getOperation() {
        return this.operation;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RelationQueryNode) {
            RelationQueryNode other = (RelationQueryNode)obj;
            return this.type == other.type && (this.valueDate == null ? other.valueDate == null : this.valueDate.equals(other.valueDate)) && this.valueDouble == other.valueDouble && this.valueLong == other.valueLong && this.valuePosition == other.valuePosition && (this.valueString == null ? other.valueString == null : this.valueString.equals(other.valueString)) && (this.property == null ? other.property == null : this.property.equals((Object)other.property));
        }
        return false;
    }
}

