/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.dataflow.ItemDataVisitor;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.MutablePropertyData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientItemData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.util.IdGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransientPropertyData
extends TransientItemData
implements MutablePropertyData,
Externalizable {
    private static final int NULL_VALUES = -1;
    private List<ValueData> values;
    private int type;
    private boolean multiValued = false;

    public TransientPropertyData(QPath path, String identifier, int version, int type, String parentIdentifier, boolean multiValued) {
        super(path, identifier, version, parentIdentifier);
        this.type = type;
        this.multiValued = multiValued;
    }

    @Override
    public boolean isNode() {
        return false;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public List<ValueData> getValues() {
        return this.values;
    }

    @Override
    public boolean isMultiValued() {
        return this.multiValued;
    }

    @Override
    public void setValues(List<ValueData> values) {
        this.values = values;
    }

    @Override
    public void setType(int type) {
        this.type = type;
    }

    public void setValue(ValueData value) {
        this.values = new ArrayList<ValueData>();
        this.values.add(value);
    }

    public static TransientPropertyData createPropertyData(NodeData parent, InternalQName name, int type, boolean multiValued) {
        TransientPropertyData propData = null;
        QPath path = QPath.makeChildPath(parent.getQPath(), name);
        propData = new TransientPropertyData(path, IdGenerator.generate(), -1, type, parent.getIdentifier(), multiValued);
        return propData;
    }

    public static TransientPropertyData createPropertyData(NodeData parent, InternalQName name, int type, boolean multiValued, ValueData value) {
        TransientPropertyData propData = TransientPropertyData.createPropertyData(parent, name, type, multiValued);
        propData.setValue(value);
        return propData;
    }

    public static TransientPropertyData createPropertyData(NodeData parent, InternalQName name, int type, boolean multiValued, List<ValueData> values) {
        TransientPropertyData propData = TransientPropertyData.createPropertyData(parent, name, type, multiValued);
        propData.setValues(values);
        return propData;
    }

    @Override
    public void accept(ItemDataVisitor visitor) throws RepositoryException {
        visitor.visit(this);
    }

    public TransientPropertyData clone() {
        TransientPropertyData dataCopy = new TransientPropertyData(this.getQPath(), this.getIdentifier(), this.getPersistedVersion(), this.getType(), this.getParentIdentifier(), this.isMultiValued());
        ArrayList<ValueData> copyValues = new ArrayList<ValueData>();
        try {
            for (ValueData vdata : this.getValues()) {
                copyValues.add(((TransientValueData)vdata).createTransientCopy());
            }
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        dataCopy.setValues(copyValues);
        return dataCopy;
    }

    public TransientPropertyData() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.type);
        out.writeBoolean(this.multiValued);
        if (this.values != null) {
            int listSize = this.values.size();
            out.writeInt(listSize);
            for (int i = 0; i < listSize; ++i) {
                out.writeObject(this.values.get(i));
            }
        } else {
            out.writeInt(-1);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.type = in.readInt();
        this.multiValued = in.readBoolean();
        int listSize = in.readInt();
        if (listSize != -1) {
            this.values = new ArrayList<ValueData>();
            for (int i = 0; i < listSize; ++i) {
                this.values.add((ValueData)in.readObject());
            }
        }
    }
}

